/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.core;

import java.util.Map;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.messaging.core.AbstractMessageReceivingTemplate;
import org.springframework.messaging.core.MessagePostProcessor;
import org.springframework.messaging.core.MessageRequestReplyOperations;

public abstract class AbstractMessagingTemplate<D>
extends AbstractMessageReceivingTemplate<D>
implements MessageRequestReplyOperations<D> {
    @Override
    @Nullable
    public Message<?> sendAndReceive(Message<?> requestMessage) throws MessagingException {
        return this.sendAndReceive(this.getRequiredDefaultDestination(), requestMessage);
    }

    @Override
    @Nullable
    public Message<?> sendAndReceive(D destination, Message<?> requestMessage) throws MessagingException {
        return this.doSendAndReceive(destination, requestMessage);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceive(Object request, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(this.getRequiredDefaultDestination(), request, targetClass);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceive(D destination, Object request, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(destination, request, null, targetClass);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceive(D destination, Object request, @Nullable Map<String, Object> headers, Class<T> targetClass) throws MessagingException {
        return this.convertSendAndReceive(destination, request, headers, targetClass, null);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceive(Object request, Class<T> targetClass, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        return this.convertSendAndReceive(this.getRequiredDefaultDestination(), request, targetClass, postProcessor);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceive(D destination, Object request, Class<T> targetClass, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        return this.convertSendAndReceive(destination, request, null, targetClass, postProcessor);
    }

    @Override
    @Nullable
    public <T> T convertSendAndReceive(D destination, Object request, @Nullable Map<String, Object> headers, Class<T> targetClass, @Nullable MessagePostProcessor postProcessor) throws MessagingException {
        Message<?> requestMessage = this.doConvert(request, headers, postProcessor);
        Message<?> replyMessage = this.sendAndReceive(destination, requestMessage);
        return (T)(replyMessage != null ? this.getMessageConverter().fromMessage(replyMessage, targetClass) : null);
    }

    @Nullable
    protected abstract Message<?> doSendAndReceive(D var1, Message<?> var2);
}

