/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.tools.sjavac.client;

import java.io.OutputStreamWriter;
import java.io.Writer;
import org.openjdk.tools.javac.main.Main;
import org.openjdk.tools.sjavac.AutoFlushWriter;
import org.openjdk.tools.sjavac.Log;
import org.openjdk.tools.sjavac.client.SjavacClient;
import org.openjdk.tools.sjavac.comp.SjavacImpl;
import org.openjdk.tools.sjavac.options.Options;
import org.openjdk.tools.sjavac.server.Sjavac;

public class ClientMain {
    public static int run(String[] stringArray) {
        return ClientMain.run(stringArray, new AutoFlushWriter(new OutputStreamWriter(System.out)), new AutoFlushWriter(new OutputStreamWriter(System.err)));
    }

    public static int run(String[] stringArray, Writer writer, Writer writer2) {
        Options options;
        Log.setLogForCurrentThread(new Log(writer, writer2));
        try {
            options = Options.parseArgs(stringArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Log.error(illegalArgumentException.getMessage());
            return Main.Result.CMDERR.exitCode;
        }
        Log.setLogLevel(options.getLogLevel());
        Log.debug("==========================================================");
        Log.debug("Launching sjavac client with the following parameters:");
        Log.debug("    " + options.getStateArgsString());
        Log.debug("==========================================================");
        boolean bl = options.getServerConf() != null;
        Sjavac sjavac = bl ? new SjavacClient(options) : new SjavacImpl();
        Main.Result result = sjavac.compile(stringArray);
        if (!bl) {
            sjavac.shutdown();
        }
        return result.exitCode;
    }
}

