/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.impl.mixin;

import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.Content;
import org.apache.axiom.core.CoreChildNode;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreDocumentFragment;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreModelException;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.DetachPolicy;
import org.apache.axiom.core.NoParentException;
import org.apache.axiom.core.NodeConsumedException;
import org.apache.axiom.core.NodeFilter;
import org.apache.axiom.core.SelfRelationshipException;
import org.apache.axiom.core.Semantics;
import org.apache.axiom.weaver.annotation.Mixin;

@Mixin
public abstract class CoreChildNodeMixin
implements CoreChildNode {
    private CoreParentNode owner;
    CoreChildNode nextSibling;
    CoreChildNode previousSibling;

    @Override
    public final boolean coreHasParent() {
        return this.internalGetFlag(8);
    }

    @Override
    public final CoreParentNode coreGetParent() {
        return this.internalGetFlag(8) ? this.owner : null;
    }

    @Override
    public final CoreElement coreGetParentElement() {
        return this.owner instanceof CoreElement ? (CoreElement)this.owner : null;
    }

    @Override
    public void internalSetParent(CoreParentNode parent) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        this.owner = parent;
        this.internalSetFlag(8, true);
    }

    @Override
    public final void internalUnsetParent(CoreDocument newOwnerDocument) {
        this.owner = newOwnerDocument;
        this.internalSetFlag(8, false);
    }

    @Override
    public final CoreNode getRootOrOwnerDocument() {
        if (this.owner == null) {
            return this;
        }
        return this.owner.getRootOrOwnerDocument();
    }

    @Override
    public final void coreSetOwnerDocument(CoreDocument document) {
        if (this.internalGetFlag(8)) {
            throw new IllegalStateException();
        }
        this.owner = document;
    }

    @Override
    public final CoreChildNode coreGetNextSiblingIfAvailable() {
        return this.nextSibling;
    }

    @Override
    public final void internalSetNextSibling(CoreChildNode nextSibling) {
        this.nextSibling = nextSibling;
    }

    @Override
    public final CoreChildNode coreGetPreviousSibling() {
        return this.previousSibling;
    }

    @Override
    public final CoreChildNode coreGetPreviousSibling(NodeFilter filter) {
        CoreChildNode sibling;
        for (sibling = this.coreGetPreviousSibling(); sibling != null && !filter.accept(sibling); sibling = sibling.coreGetPreviousSibling()) {
        }
        return sibling;
    }

    @Override
    public final void internalSetPreviousSibling(CoreChildNode previousSibling) {
        this.previousSibling = previousSibling;
    }

    @Override
    public final CoreChildNode coreGetNextSibling() throws CoreModelException {
        CoreParentNode parent;
        CoreChildNode nextSibling = this.coreGetNextSiblingIfAvailable();
        if (nextSibling == null && (parent = this.coreGetParent()) != null) {
            switch (parent.getState()) {
                case 3: 
                case 4: {
                    throw new NodeConsumedException();
                }
                case 2: {
                    if (parent.coreGetBuilder() == null) break;
                    do {
                        parent.internalBuildNext();
                    } while (parent.getState() == 2 && (nextSibling = this.coreGetNextSiblingIfAvailable()) == null);
                }
            }
        }
        return nextSibling;
    }

    @Override
    public final CoreChildNode coreGetNextSibling(NodeFilter filter) throws CoreModelException {
        CoreChildNode sibling;
        for (sibling = this.coreGetNextSibling(); sibling != null && !filter.accept(sibling); sibling = sibling.coreGetNextSibling()) {
        }
        return sibling;
    }

    @Override
    public final void coreInsertSiblingAfter(CoreChildNode sibling) throws CoreModelException {
        CoreParentNode parent = this.coreGetParent();
        if (parent == null) {
            throw new NoParentException("Parent can not be null");
        }
        if (this == sibling) {
            throw new SelfRelationshipException("Inserting self as the sibling is not allowed");
        }
        parent.internalCheckNewChild(sibling, null);
        sibling.internalDetach(null, parent);
        CoreChildNode nextSibling = this.coreGetNextSibling();
        sibling.internalSetPreviousSibling(this);
        if (nextSibling == null) {
            parent.internalGetContent((boolean)true).lastChild = sibling;
        } else {
            nextSibling.internalSetPreviousSibling(sibling);
        }
        sibling.internalSetNextSibling(nextSibling);
        this.nextSibling = sibling;
    }

    @Override
    public final void coreInsertSiblingBefore(CoreChildNode sibling) throws CoreModelException {
        CoreParentNode parent = this.coreGetParent();
        if (parent == null) {
            throw new NoParentException("Parent can not be null");
        }
        if (this == sibling) {
            throw new SelfRelationshipException("Inserting self as the sibling is not allowed");
        }
        parent.internalCheckNewChild(sibling, null);
        sibling.internalDetach(null, parent);
        sibling.internalSetNextSibling(this);
        if (this.previousSibling == null) {
            parent.internalGetContent((boolean)true).firstChild = sibling;
        } else {
            this.previousSibling.internalSetNextSibling(sibling);
        }
        sibling.internalSetPreviousSibling(this.previousSibling);
        this.previousSibling = sibling;
    }

    @Override
    public final void coreInsertSiblingsBefore(CoreDocumentFragment fragment) {
        Content fragmentContent = fragment.internalGetContent(false);
        if (fragmentContent == null || fragmentContent.firstChild == null) {
            return;
        }
        CoreParentNode parent = this.coreGetParent();
        for (CoreChildNode child = fragmentContent.firstChild; child != null; child = child.coreGetNextSiblingIfAvailable()) {
            child.internalSetParent(parent);
        }
        fragmentContent.lastChild.internalSetNextSibling(this);
        if (this.previousSibling == null) {
            parent.internalGetContent((boolean)true).firstChild = fragmentContent.firstChild;
        } else {
            this.previousSibling.internalSetNextSibling(fragmentContent.firstChild);
        }
        fragmentContent.firstChild.internalSetPreviousSibling(this.previousSibling);
        this.previousSibling = fragmentContent.lastChild;
        fragmentContent.firstChild = null;
        fragmentContent.lastChild = null;
    }

    @Override
    public final void coreDetach(Semantics semantics) {
        this.internalDetach(semantics.getDetachPolicy(), null);
    }

    @Override
    public final void coreDetach(CoreDocument newOwnerDocument) {
        this.internalDetach(DetachPolicy.NEW_DOCUMENT, null);
        this.owner = newOwnerDocument;
    }

    @Override
    public final void internalDetach(DetachPolicy detachPolicy, CoreParentNode newParent) {
        CoreParentNode parent = this.coreGetParent();
        if (parent != null) {
            if (this.previousSibling == null) {
                parent.internalGetContent((boolean)true).firstChild = this.nextSibling;
            } else {
                this.previousSibling.internalSetNextSibling(this.nextSibling);
            }
            if (this.nextSibling == null) {
                parent.internalGetContent((boolean)true).lastChild = this.previousSibling;
            } else {
                this.nextSibling.internalSetPreviousSibling(this.previousSibling);
            }
            this.nextSibling = null;
            this.previousSibling = null;
            if (newParent == null) {
                this.internalUnsetParent(detachPolicy.getNewOwnerDocument(parent));
            }
        }
        if (newParent != null) {
            this.internalSetParent(newParent);
        }
    }

    @Override
    public final void coreReplaceWith(CoreChildNode newNode, Semantics semantics) throws CoreModelException {
        if (newNode == this) {
            return;
        }
        CoreParentNode parent = this.coreGetParent();
        if (parent != null) {
            parent.internalCheckNewChild(newNode, this);
            newNode.internalDetach(null, parent);
            if (this.previousSibling == null) {
                parent.internalGetContent((boolean)true).firstChild = newNode;
            } else {
                this.previousSibling.internalSetNextSibling(newNode);
                newNode.internalSetPreviousSibling(this.previousSibling);
                this.previousSibling = null;
            }
            if (this.nextSibling == null) {
                parent.internalGetContent((boolean)true).lastChild = newNode;
            } else {
                this.nextSibling.internalSetPreviousSibling(newNode);
                newNode.internalSetNextSibling(this.nextSibling);
                this.nextSibling = null;
            }
            this.internalUnsetParent(semantics.getDetachPolicy().getNewOwnerDocument(parent));
        }
    }

    @Override
    public final <T> CoreNode coreClone(ClonePolicy<T> policy, T options, CoreParentNode targetParent) throws CoreModelException {
        return this.internalClone(policy, options, targetParent);
    }
}

