/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.tcp;

import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.kernel.TransportUtils;
import org.apache.axis2.transport.tcp.TCPEndpoint;
import org.apache.axis2.transport.tcp.TCPOutTransportInfo;
import org.apache.axis2.util.MessageContextBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TCPWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(TCPWorker.class);
    private TCPEndpoint endpoint;
    private Socket socket;

    public TCPWorker(TCPEndpoint endpoint, Socket socket) {
        this.endpoint = endpoint;
        this.socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        MessageContext msgContext = null;
        try {
            msgContext = this.endpoint.createMessageContext();
            msgContext.setIncomingTransportName("tcp");
            TCPOutTransportInfo outInfo = new TCPOutTransportInfo();
            outInfo.setSocket(this.socket);
            outInfo.setContentType(this.endpoint.getContentType());
            msgContext.setProperty("OutTransportInfo", (Object)outInfo);
            SOAPEnvelope envelope = TransportUtils.createSOAPMessage((MessageContext)msgContext, (InputStream)this.socket.getInputStream(), (String)this.endpoint.getContentType());
            msgContext.setEnvelope(envelope);
            AxisEngine.receive((MessageContext)msgContext);
        }
        catch (Exception e) {
            this.sendFault(msgContext, e);
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                log.error((Object)"Error while closing a TCP socket", (Throwable)e);
            }
        }
    }

    private void sendFault(MessageContext msgContext, Exception fault) {
        log.error((Object)"Error while processing TCP request through the Axis2 engine", (Throwable)fault);
        try {
            if (msgContext != null) {
                msgContext.setProperty("TRANSPORT_OUT", (Object)this.socket.getOutputStream());
                MessageContext faultContext = MessageContextBuilder.createFaultMessageContext((MessageContext)msgContext, (Throwable)fault);
                AxisEngine.sendFault((MessageContext)faultContext);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while sending the fault response", (Throwable)e);
        }
    }
}

