/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.mime;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.axiom.mime.ContentTypeTokenizer;
import org.apache.axiom.mime.MediaType;

public final class ContentType {
    private final MediaType mediaType;
    private final String[] parameters;

    public ContentType(MediaType mediaType, String ... parameters) {
        Objects.requireNonNull(mediaType);
        for (String parameter : parameters) {
            Objects.requireNonNull(parameter);
        }
        this.mediaType = mediaType;
        this.parameters = (String[])parameters.clone();
    }

    public ContentType(String type) throws ParseException {
        String name;
        ContentTypeTokenizer tokenizer = new ContentTypeTokenizer(type);
        String primaryType = tokenizer.requireToken();
        tokenizer.require('/');
        String subType = tokenizer.requireToken();
        this.mediaType = new MediaType(primaryType, subType);
        ArrayList<String> parameters = new ArrayList<String>();
        while (tokenizer.expect(';') && (name = tokenizer.expectToken()) != null) {
            parameters.add(name);
            tokenizer.require('=');
            parameters.add(tokenizer.requireTokenOrQuotedString());
        }
        this.parameters = parameters.toArray(new String[parameters.size()]);
    }

    ContentType(MediaType mediaType, Map<String, String> parameters) {
        this.mediaType = mediaType;
        this.parameters = new String[parameters.size() * 2];
        int i = 0;
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.parameters[i++] = entry.getKey();
            this.parameters[i++] = entry.getValue();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String getParameter(String name) {
        for (int i = 0; i < this.parameters.length; i += 2) {
            if (!name.equalsIgnoreCase(this.parameters[i])) continue;
            return this.parameters[i + 1];
        }
        return null;
    }

    public boolean isTextual() {
        return this.mediaType.hasPrimaryType("text") || this.mediaType.isXML() || this.getParameter("charset") != null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.mediaType.getPrimaryType());
        buffer.append('/');
        buffer.append(this.mediaType.getSubType());
        int i = 0;
        while (i < this.parameters.length) {
            buffer.append("; ");
            buffer.append(this.parameters[i++]);
            buffer.append("=\"");
            String value = this.parameters[i++];
            int l = value.length();
            for (int j = 0; j < l; ++j) {
                char c = value.charAt(j);
                if (c == '\"' || c == '\\') {
                    buffer.append('\\');
                }
                buffer.append(c);
            }
            buffer.append('\"');
        }
        return buffer.toString();
    }

    void getParameters(Map<String, String> map) {
        for (int i = 0; i < this.parameters.length; i += 2) {
            map.put(this.parameters[i].toLowerCase(Locale.ENGLISH), this.parameters[i + 1]);
        }
    }

    public static final class Builder {
        private MediaType mediaType;
        private final LinkedHashMap<String, String> parameters = new LinkedHashMap();

        Builder() {
        }

        Builder(ContentType type) {
            this.mediaType = type.mediaType;
            type.getParameters(this.parameters);
        }

        public MediaType getMediaType() {
            return this.mediaType;
        }

        public Builder setMediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public String getParameter(String name) {
            return this.parameters.get(name.toLowerCase(Locale.ENGLISH));
        }

        public Builder setParameter(String name, String value) {
            if (value == null) {
                this.parameters.remove(name.toLowerCase(Locale.ENGLISH));
            } else {
                this.parameters.put(name.toLowerCase(Locale.ENGLISH), value);
            }
            return this;
        }

        public Builder removeParameter(String name) {
            this.parameters.remove(name.toLowerCase(Locale.ENGLISH));
            return this;
        }

        public Builder clearParameters() {
            this.parameters.clear();
            return this;
        }

        public ContentType build() {
            return new ContentType(this.mediaType, this.parameters);
        }
    }
}

