/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.stax;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.blob.Blob;
import org.apache.axiom.blob.Blobs;
import org.apache.axiom.blob.MemoryBlob;
import org.apache.axiom.ext.stax.BlobReader;
import org.apache.axiom.ext.stax.CharacterDataReader;
import org.apache.axiom.ext.stax.DelegatingXMLStreamReader;
import org.apache.axiom.util.base64.Base64DecodingOutputStreamWriter;
import org.apache.axiom.util.stax.TextFromElementReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLStreamReaderUtils {
    private static final Log log = LogFactory.getLog(XMLStreamReaderUtils.class);

    private XMLStreamReaderUtils() {
    }

    public static BlobReader getBlobReader(XMLStreamReader reader) {
        try {
            return (BlobReader)reader.getProperty(BlobReader.PROPERTY);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static Object processGetProperty(BlobReader extension, String propertyName) {
        if (extension == null || propertyName == null) {
            throw new IllegalArgumentException();
        }
        if (propertyName.equals(BlobReader.PROPERTY)) {
            return extension;
        }
        return null;
    }

    public static Blob getBlobFromElement(XMLStreamReader reader) throws XMLStreamException {
        int event = reader.next();
        if (event == 2) {
            return Blobs.createBlob(new byte[0]);
        }
        if (event != 4) {
            throw new XMLStreamException("Expected a CHARACTER event");
        }
        BlobReader blobReader = XMLStreamReaderUtils.getBlobReader(reader);
        if (blobReader != null && blobReader.isBinary()) {
            Blob blob = blobReader.getBlob();
            reader.next();
            return blob;
        }
        MemoryBlob blob = Blobs.createMemoryBlob();
        Base64DecodingOutputStreamWriter out = new Base64DecodingOutputStreamWriter(blob.getOutputStream());
        try {
            XMLStreamReaderUtils.writeTextTo(reader, out);
            block6: while (true) {
                switch (reader.next()) {
                    case 4: {
                        XMLStreamReaderUtils.writeTextTo(reader, out);
                        continue block6;
                    }
                    case 2: {
                        break block6;
                    }
                    default: {
                        throw new XMLStreamException("Expected a CHARACTER event");
                    }
                }
                break;
            }
            ((Writer)out).close();
        }
        catch (IOException ex) {
            throw new XMLStreamException("Error during base64 decoding", ex);
        }
        return blob;
    }

    public static void writeTextTo(XMLStreamReader reader, Writer writer) throws XMLStreamException, IOException {
        CharacterDataReader cdataReader;
        try {
            cdataReader = (CharacterDataReader)reader.getProperty(CharacterDataReader.PROPERTY);
        }
        catch (IllegalArgumentException ex) {
            cdataReader = null;
        }
        if (cdataReader != null) {
            cdataReader.writeTextTo(writer);
        } else {
            writer.write(reader.getText());
        }
    }

    public static Reader getElementTextAsStream(XMLStreamReader reader, boolean allowNonTextChildren) {
        if (reader.getEventType() != 1) {
            throw new IllegalStateException("Reader must be on a START_ELEMENT event");
        }
        return new TextFromElementReader(reader, allowNonTextChildren);
    }

    public static XMLStreamReader getOriginalXMLStreamReader(XMLStreamReader parser) {
        String clsName;
        if (log.isDebugEnabled()) {
            clsName = parser != null ? parser.getClass().toString() : "null";
            log.debug((Object)("Entry getOriginalXMLStreamReader: " + clsName));
        }
        while (parser instanceof DelegatingXMLStreamReader) {
            parser = ((DelegatingXMLStreamReader)parser).getParent();
            if (!log.isDebugEnabled()) continue;
            clsName = parser != null ? parser.getClass().toString() : "null";
            log.debug((Object)("  parent: " + clsName));
        }
        if (log.isDebugEnabled()) {
            clsName = parser != null ? parser.getClass().toString() : "null";
            log.debug((Object)("Exit getOriginalXMLStreamReader: " + clsName));
        }
        return parser;
    }
}

