/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.secpolicy.model;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.secpolicy.SP11Constants;
import org.apache.ws.secpolicy.SP12Constants;
import org.apache.ws.secpolicy.SPConstants;
import org.apache.ws.secpolicy.WSSPolicyException;
import org.apache.ws.secpolicy.model.AbstractConfigurableSecurityAssertion;

public class AlgorithmSuite
extends AbstractConfigurableSecurityAssertion {
    private String algoSuiteString;
    private String symmetricSignature = "http://www.w3.org/2000/09/xmldsig#hmac-sha1";
    private String asymmetricSignature = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
    private String computedKey = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
    private int maximumSymmetricKeyLength = 256;
    private int minimumAsymmetricKeyLength = 1024;
    private int maximumAsymmetricKeyLength = 4096;
    private String digest;
    private String encryption;
    private String symmetricKeyWrap;
    private String asymmetricKeyWrap;
    private String encryptionKeyDerivation;
    private int encryptionDerivedKeyLength;
    private String signatureKeyDerivation;
    private int signatureDerivedKeyLength;
    private int minimumSymmetricKeyLength;
    private String c14n = "http://www.w3.org/2001/10/xml-exc-c14n#";
    private String soapNormalization;
    private String strTransform;
    private String xPath;

    public AlgorithmSuite(int version) {
        this.setVersion(version);
    }

    public void setAlgorithmSuite(String algoSuite) throws WSSPolicyException {
        this.setAlgoSuiteString(algoSuite);
        this.algoSuiteString = algoSuite;
        if ("Basic256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 256;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 256;
            this.encryptionDerivedKeyLength = 256;
        } else if ("Basic192".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
            this.maximumSymmetricKeyLength = 192;
        } else if ("Basic128".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 128;
            this.signatureDerivedKeyLength = 128;
            this.minimumSymmetricKeyLength = 128;
            this.maximumSymmetricKeyLength = 128;
        } else if ("TripleDes".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
            this.maximumSymmetricKeyLength = 192;
        } else if ("Basic256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 256;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 256;
        } else if ("Basic192Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
            this.maximumSymmetricKeyLength = 192;
        } else if ("Basic128Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 128;
            this.signatureDerivedKeyLength = 128;
            this.minimumSymmetricKeyLength = 128;
            this.maximumSymmetricKeyLength = 128;
        } else if ("TripleDesRsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2000/09/xmldsig#sha1";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
            this.maximumSymmetricKeyLength = 192;
        } else if ("Basic256Sha256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 256;
            this.signatureDerivedKeyLength = 256;
            this.minimumSymmetricKeyLength = 256;
        } else if ("Basic192Sha256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
            this.maximumSymmetricKeyLength = 192;
        } else if ("Basic128Sha256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 128;
            this.signatureDerivedKeyLength = 128;
            this.minimumSymmetricKeyLength = 128;
            this.maximumSymmetricKeyLength = 128;
        } else if ("TripleDesSha256".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
            this.maximumSymmetricKeyLength = 192;
        } else if ("Basic256Sha256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes256-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes256";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 256;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 256;
        } else if ("Basic192Sha256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes192-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes192";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
            this.maximumSymmetricKeyLength = 192;
        } else if ("Basic128Sha256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#aes128-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-aes128";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 128;
            this.signatureDerivedKeyLength = 128;
            this.minimumSymmetricKeyLength = 128;
            this.maximumSymmetricKeyLength = 192;
        } else if ("TripleDesSha256Rsa15".equals(algoSuite)) {
            this.digest = "http://www.w3.org/2001/04/xmlenc#sha256";
            this.encryption = "http://www.w3.org/2001/04/xmlenc#tripledes-cbc";
            this.symmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#kw-tripledes";
            this.asymmetricKeyWrap = "http://www.w3.org/2001/04/xmlenc#rsa-1_5";
            this.encryptionKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.signatureKeyDerivation = "http://schemas.xmlsoap.org/ws/2005/02/sc/dk/p_sha1";
            this.encryptionDerivedKeyLength = 192;
            this.signatureDerivedKeyLength = 192;
            this.minimumSymmetricKeyLength = 192;
            this.maximumSymmetricKeyLength = 192;
        } else {
            throw new WSSPolicyException("Invalid algorithm suite : " + algoSuite);
        }
    }

    public String getAsymmetricKeyWrap() {
        return this.asymmetricKeyWrap;
    }

    public String getAsymmetricSignature() {
        if (this.digest == "http://www.w3.org/2001/04/xmlenc#sha256") {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
        }
        if (this.digest == "http://www.w3.org/2001/04/xmlenc#sha512") {
            return "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
        }
        return this.asymmetricSignature;
    }

    public String getComputedKey() {
        return this.computedKey;
    }

    public String getDigest() {
        return this.digest;
    }

    public String getEncryption() {
        return this.encryption;
    }

    public String getEncryptionKeyDerivation() {
        return this.encryptionKeyDerivation;
    }

    public int getMaximumAsymmetricKeyLength() {
        return this.maximumAsymmetricKeyLength;
    }

    public int getMaximumSymmetricKeyLength() {
        return this.maximumSymmetricKeyLength;
    }

    public int getMinimumAsymmetricKeyLength() {
        return this.minimumAsymmetricKeyLength;
    }

    public int getMinimumSymmetricKeyLength() {
        return this.minimumSymmetricKeyLength;
    }

    public String getSignatureKeyDerivation() {
        return this.signatureKeyDerivation;
    }

    public String getSymmetricKeyWrap() {
        return this.symmetricKeyWrap;
    }

    public String getSymmetricSignature() {
        return this.symmetricSignature;
    }

    public String getInclusiveC14n() {
        return this.c14n;
    }

    public void setC14n(String c14n) {
        this.c14n = c14n;
    }

    public String getSoapNormalization() {
        return this.soapNormalization;
    }

    public void setSoapNormalization(String soapNormalization) {
        this.soapNormalization = soapNormalization;
    }

    public String getStrTransform() {
        return this.strTransform;
    }

    public void setStrTransform(String strTransform) {
        this.strTransform = strTransform;
    }

    public String getXPath() {
        return this.xPath;
    }

    public void setXPath(String path) {
        this.xPath = path;
    }

    private void setAlgoSuiteString(String algoSuiteString) {
        this.algoSuiteString = algoSuiteString;
    }

    private String getAlgoSuiteString() {
        return this.algoSuiteString;
    }

    public QName getName() {
        if (this.version == 2) {
            return SP12Constants.ALGORITHM_SUITE;
        }
        return SP11Constants.ALGORITHM_SUITE;
    }

    @Override
    public PolicyComponent normalize() {
        throw new UnsupportedOperationException("AlgorithmSuite.normalize() is not supported");
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String prefix = this.getName().getPrefix();
        String localName = this.getName().getLocalPart();
        String namespaceURI = this.getName().getNamespaceURI();
        AlgorithmSuite.writeStartElement(writer, prefix, localName, namespaceURI);
        AlgorithmSuite.writeStartElement(writer, SPConstants.POLICY);
        AlgorithmSuite.writeEmptyElement(writer, prefix, this.getAlgoSuiteString(), namespaceURI);
        if ("http://www.w3.org/2001/10/xml-c14n#".equals(this.getInclusiveC14n())) {
            AlgorithmSuite.writeEmptyElement(writer, prefix, "InclusiveC14N", namespaceURI);
        }
        if ("http://www.w3.org/TR/soap12-n11n".equals(this.getSoapNormalization())) {
            AlgorithmSuite.writeEmptyElement(writer, prefix, "SoapNormalization10", namespaceURI);
        }
        if ("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#STR-Transform".equals(this.getStrTransform())) {
            AlgorithmSuite.writeEmptyElement(writer, prefix, "STRTransform10", namespaceURI);
        }
        if ("http://www.w3.org/TR/1999/REC-xpath-19991116".equals(this.getXPath())) {
            AlgorithmSuite.writeEmptyElement(writer, prefix, "XPath10", namespaceURI);
        }
        if ("http://www.w3.org/2002/06/xmldsig-filter2".equals(this.getXPath())) {
            AlgorithmSuite.writeEmptyElement(writer, prefix, "XPathFilter20", namespaceURI);
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public int getEncryptionDerivedKeyLength() {
        return this.encryptionDerivedKeyLength;
    }

    public int getSignatureDerivedKeyLength() {
        return this.signatureDerivedKeyLength;
    }

    public void setAsymmetricKeyWrap(String asymmetricKeyWrap) {
        this.asymmetricKeyWrap = asymmetricKeyWrap;
    }
}

