/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationspec.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationspec.traits.Toleration;
import org.apache.camel.v1.integrationspec.traits.toleration.Configuration;
import org.apache.camel.v1.integrationspec.traits.toleration.ConfigurationBuilder;
import org.apache.camel.v1.integrationspec.traits.toleration.ConfigurationFluent;

public class TolerationFluent<A extends TolerationFluent<A>>
extends BaseFluent<A> {
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private List<String> taints;

    public TolerationFluent() {
    }

    public TolerationFluent(Toleration instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Toleration instance) {
        Toleration toleration = instance = instance != null ? instance : new Toleration();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withTaints(instance.getTaints());
        }
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A addToTaints(int index, String item) {
        if (this.taints == null) {
            this.taints = new ArrayList<String>();
        }
        this.taints.add(index, item);
        return (A)((Object)this);
    }

    public A setToTaints(int index, String item) {
        if (this.taints == null) {
            this.taints = new ArrayList<String>();
        }
        this.taints.set(index, item);
        return (A)((Object)this);
    }

    public A addToTaints(String ... items) {
        if (this.taints == null) {
            this.taints = new ArrayList<String>();
        }
        for (String item : items) {
            this.taints.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToTaints(Collection<String> items) {
        if (this.taints == null) {
            this.taints = new ArrayList<String>();
        }
        for (String item : items) {
            this.taints.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromTaints(String ... items) {
        if (this.taints == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.taints.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromTaints(Collection<String> items) {
        if (this.taints == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.taints.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getTaints() {
        return this.taints;
    }

    public String getTaint(int index) {
        return this.taints.get(index);
    }

    public String getFirstTaint() {
        return this.taints.get(0);
    }

    public String getLastTaint() {
        return this.taints.get(this.taints.size() - 1);
    }

    public String getMatchingTaint(Predicate<String> predicate) {
        for (String item : this.taints) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingTaint(Predicate<String> predicate) {
        for (String item : this.taints) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withTaints(List<String> taints) {
        if (taints != null) {
            this.taints = new ArrayList<String>();
            for (String item : taints) {
                this.addToTaints(item);
            }
        } else {
            this.taints = null;
        }
        return (A)((Object)this);
    }

    public A withTaints(String ... taints) {
        if (this.taints != null) {
            this.taints.clear();
            this._visitables.remove((Object)"taints");
        }
        if (taints != null) {
            for (String item : taints) {
                this.addToTaints(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasTaints() {
        return this.taints != null && !this.taints.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TolerationFluent that = (TolerationFluent)((Object)o);
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        return Objects.equals(this.taints, that.taints);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.enabled, this.taints, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.taints != null && !this.taints.isEmpty()) {
            sb.append("taints:");
            sb.append(this.taints);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)TolerationFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

