/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationplatformspec.traits;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.integrationplatformspec.traits.Affinity;
import org.apache.camel.v1.integrationplatformspec.traits.affinity.Configuration;
import org.apache.camel.v1.integrationplatformspec.traits.affinity.ConfigurationBuilder;
import org.apache.camel.v1.integrationplatformspec.traits.affinity.ConfigurationFluent;

public class AffinityFluent<A extends AffinityFluent<A>>
extends BaseFluent<A> {
    private ConfigurationBuilder configuration;
    private Boolean enabled;
    private List<String> nodeAffinityLabels;
    private Boolean podAffinity;
    private List<String> podAffinityLabels;
    private Boolean podAntiAffinity;
    private List<String> podAntiAffinityLabels;

    public AffinityFluent() {
    }

    public AffinityFluent(Affinity instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(Affinity instance) {
        Affinity affinity = instance = instance != null ? instance : new Affinity();
        if (instance != null) {
            this.withConfiguration(instance.getConfiguration());
            this.withEnabled(instance.getEnabled());
            this.withNodeAffinityLabels(instance.getNodeAffinityLabels());
            this.withPodAffinity(instance.getPodAffinity());
            this.withPodAffinityLabels(instance.getPodAffinityLabels());
            this.withPodAntiAffinity(instance.getPodAntiAffinity());
            this.withPodAntiAffinityLabels(instance.getPodAntiAffinityLabels());
        }
    }

    public Configuration buildConfiguration() {
        return this.configuration != null ? this.configuration.build() : null;
    }

    public A withConfiguration(Configuration configuration) {
        this._visitables.remove((Object)"configuration");
        if (configuration != null) {
            this.configuration = new ConfigurationBuilder(configuration);
            this._visitables.get((Object)"configuration").add(this.configuration);
        } else {
            this.configuration = null;
            this._visitables.get((Object)"configuration").remove((Object)this.configuration);
        }
        return (A)((Object)this);
    }

    public boolean hasConfiguration() {
        return this.configuration != null;
    }

    public ConfigurationNested<A> withNewConfiguration() {
        return new ConfigurationNested(null);
    }

    public ConfigurationNested<A> withNewConfigurationLike(Configuration item) {
        return new ConfigurationNested(item);
    }

    public ConfigurationNested<A> editConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(null));
    }

    public ConfigurationNested<A> editOrNewConfiguration() {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(new ConfigurationBuilder().build()));
    }

    public ConfigurationNested<A> editOrNewConfigurationLike(Configuration item) {
        return this.withNewConfigurationLike(Optional.ofNullable(this.buildConfiguration()).orElse(item));
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public A withEnabled(Boolean enabled) {
        this.enabled = enabled;
        return (A)((Object)this);
    }

    public boolean hasEnabled() {
        return this.enabled != null;
    }

    public A addToNodeAffinityLabels(int index, String item) {
        if (this.nodeAffinityLabels == null) {
            this.nodeAffinityLabels = new ArrayList<String>();
        }
        this.nodeAffinityLabels.add(index, item);
        return (A)((Object)this);
    }

    public A setToNodeAffinityLabels(int index, String item) {
        if (this.nodeAffinityLabels == null) {
            this.nodeAffinityLabels = new ArrayList<String>();
        }
        this.nodeAffinityLabels.set(index, item);
        return (A)((Object)this);
    }

    public A addToNodeAffinityLabels(String ... items) {
        if (this.nodeAffinityLabels == null) {
            this.nodeAffinityLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.nodeAffinityLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToNodeAffinityLabels(Collection<String> items) {
        if (this.nodeAffinityLabels == null) {
            this.nodeAffinityLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.nodeAffinityLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromNodeAffinityLabels(String ... items) {
        if (this.nodeAffinityLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.nodeAffinityLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromNodeAffinityLabels(Collection<String> items) {
        if (this.nodeAffinityLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.nodeAffinityLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getNodeAffinityLabels() {
        return this.nodeAffinityLabels;
    }

    public String getNodeAffinityLabel(int index) {
        return this.nodeAffinityLabels.get(index);
    }

    public String getFirstNodeAffinityLabel() {
        return this.nodeAffinityLabels.get(0);
    }

    public String getLastNodeAffinityLabel() {
        return this.nodeAffinityLabels.get(this.nodeAffinityLabels.size() - 1);
    }

    public String getMatchingNodeAffinityLabel(Predicate<String> predicate) {
        for (String item : this.nodeAffinityLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingNodeAffinityLabel(Predicate<String> predicate) {
        for (String item : this.nodeAffinityLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withNodeAffinityLabels(List<String> nodeAffinityLabels) {
        if (nodeAffinityLabels != null) {
            this.nodeAffinityLabels = new ArrayList<String>();
            for (String item : nodeAffinityLabels) {
                this.addToNodeAffinityLabels(item);
            }
        } else {
            this.nodeAffinityLabels = null;
        }
        return (A)((Object)this);
    }

    public A withNodeAffinityLabels(String ... nodeAffinityLabels) {
        if (this.nodeAffinityLabels != null) {
            this.nodeAffinityLabels.clear();
            this._visitables.remove((Object)"nodeAffinityLabels");
        }
        if (nodeAffinityLabels != null) {
            for (String item : nodeAffinityLabels) {
                this.addToNodeAffinityLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasNodeAffinityLabels() {
        return this.nodeAffinityLabels != null && !this.nodeAffinityLabels.isEmpty();
    }

    public Boolean getPodAffinity() {
        return this.podAffinity;
    }

    public A withPodAffinity(Boolean podAffinity) {
        this.podAffinity = podAffinity;
        return (A)((Object)this);
    }

    public boolean hasPodAffinity() {
        return this.podAffinity != null;
    }

    public A addToPodAffinityLabels(int index, String item) {
        if (this.podAffinityLabels == null) {
            this.podAffinityLabels = new ArrayList<String>();
        }
        this.podAffinityLabels.add(index, item);
        return (A)((Object)this);
    }

    public A setToPodAffinityLabels(int index, String item) {
        if (this.podAffinityLabels == null) {
            this.podAffinityLabels = new ArrayList<String>();
        }
        this.podAffinityLabels.set(index, item);
        return (A)((Object)this);
    }

    public A addToPodAffinityLabels(String ... items) {
        if (this.podAffinityLabels == null) {
            this.podAffinityLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podAffinityLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPodAffinityLabels(Collection<String> items) {
        if (this.podAffinityLabels == null) {
            this.podAffinityLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podAffinityLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPodAffinityLabels(String ... items) {
        if (this.podAffinityLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.podAffinityLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPodAffinityLabels(Collection<String> items) {
        if (this.podAffinityLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.podAffinityLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPodAffinityLabels() {
        return this.podAffinityLabels;
    }

    public String getPodAffinityLabel(int index) {
        return this.podAffinityLabels.get(index);
    }

    public String getFirstPodAffinityLabel() {
        return this.podAffinityLabels.get(0);
    }

    public String getLastPodAffinityLabel() {
        return this.podAffinityLabels.get(this.podAffinityLabels.size() - 1);
    }

    public String getMatchingPodAffinityLabel(Predicate<String> predicate) {
        for (String item : this.podAffinityLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPodAffinityLabel(Predicate<String> predicate) {
        for (String item : this.podAffinityLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPodAffinityLabels(List<String> podAffinityLabels) {
        if (podAffinityLabels != null) {
            this.podAffinityLabels = new ArrayList<String>();
            for (String item : podAffinityLabels) {
                this.addToPodAffinityLabels(item);
            }
        } else {
            this.podAffinityLabels = null;
        }
        return (A)((Object)this);
    }

    public A withPodAffinityLabels(String ... podAffinityLabels) {
        if (this.podAffinityLabels != null) {
            this.podAffinityLabels.clear();
            this._visitables.remove((Object)"podAffinityLabels");
        }
        if (podAffinityLabels != null) {
            for (String item : podAffinityLabels) {
                this.addToPodAffinityLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPodAffinityLabels() {
        return this.podAffinityLabels != null && !this.podAffinityLabels.isEmpty();
    }

    public Boolean getPodAntiAffinity() {
        return this.podAntiAffinity;
    }

    public A withPodAntiAffinity(Boolean podAntiAffinity) {
        this.podAntiAffinity = podAntiAffinity;
        return (A)((Object)this);
    }

    public boolean hasPodAntiAffinity() {
        return this.podAntiAffinity != null;
    }

    public A addToPodAntiAffinityLabels(int index, String item) {
        if (this.podAntiAffinityLabels == null) {
            this.podAntiAffinityLabels = new ArrayList<String>();
        }
        this.podAntiAffinityLabels.add(index, item);
        return (A)((Object)this);
    }

    public A setToPodAntiAffinityLabels(int index, String item) {
        if (this.podAntiAffinityLabels == null) {
            this.podAntiAffinityLabels = new ArrayList<String>();
        }
        this.podAntiAffinityLabels.set(index, item);
        return (A)((Object)this);
    }

    public A addToPodAntiAffinityLabels(String ... items) {
        if (this.podAntiAffinityLabels == null) {
            this.podAntiAffinityLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podAntiAffinityLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToPodAntiAffinityLabels(Collection<String> items) {
        if (this.podAntiAffinityLabels == null) {
            this.podAntiAffinityLabels = new ArrayList<String>();
        }
        for (String item : items) {
            this.podAntiAffinityLabels.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromPodAntiAffinityLabels(String ... items) {
        if (this.podAntiAffinityLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.podAntiAffinityLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromPodAntiAffinityLabels(Collection<String> items) {
        if (this.podAntiAffinityLabels == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.podAntiAffinityLabels.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getPodAntiAffinityLabels() {
        return this.podAntiAffinityLabels;
    }

    public String getPodAntiAffinityLabel(int index) {
        return this.podAntiAffinityLabels.get(index);
    }

    public String getFirstPodAntiAffinityLabel() {
        return this.podAntiAffinityLabels.get(0);
    }

    public String getLastPodAntiAffinityLabel() {
        return this.podAntiAffinityLabels.get(this.podAntiAffinityLabels.size() - 1);
    }

    public String getMatchingPodAntiAffinityLabel(Predicate<String> predicate) {
        for (String item : this.podAntiAffinityLabels) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingPodAntiAffinityLabel(Predicate<String> predicate) {
        for (String item : this.podAntiAffinityLabels) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withPodAntiAffinityLabels(List<String> podAntiAffinityLabels) {
        if (podAntiAffinityLabels != null) {
            this.podAntiAffinityLabels = new ArrayList<String>();
            for (String item : podAntiAffinityLabels) {
                this.addToPodAntiAffinityLabels(item);
            }
        } else {
            this.podAntiAffinityLabels = null;
        }
        return (A)((Object)this);
    }

    public A withPodAntiAffinityLabels(String ... podAntiAffinityLabels) {
        if (this.podAntiAffinityLabels != null) {
            this.podAntiAffinityLabels.clear();
            this._visitables.remove((Object)"podAntiAffinityLabels");
        }
        if (podAntiAffinityLabels != null) {
            for (String item : podAntiAffinityLabels) {
                this.addToPodAntiAffinityLabels(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasPodAntiAffinityLabels() {
        return this.podAntiAffinityLabels != null && !this.podAntiAffinityLabels.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AffinityFluent that = (AffinityFluent)((Object)o);
        if (!Objects.equals((Object)this.configuration, (Object)that.configuration)) {
            return false;
        }
        if (!Objects.equals(this.enabled, that.enabled)) {
            return false;
        }
        if (!Objects.equals(this.nodeAffinityLabels, that.nodeAffinityLabels)) {
            return false;
        }
        if (!Objects.equals(this.podAffinity, that.podAffinity)) {
            return false;
        }
        if (!Objects.equals(this.podAffinityLabels, that.podAffinityLabels)) {
            return false;
        }
        if (!Objects.equals(this.podAntiAffinity, that.podAntiAffinity)) {
            return false;
        }
        return Objects.equals(this.podAntiAffinityLabels, that.podAntiAffinityLabels);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.configuration, this.enabled, this.nodeAffinityLabels, this.podAffinity, this.podAffinityLabels, this.podAntiAffinity, this.podAntiAffinityLabels, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.configuration != null) {
            sb.append("configuration:");
            sb.append(this.configuration + ",");
        }
        if (this.enabled != null) {
            sb.append("enabled:");
            sb.append(this.enabled + ",");
        }
        if (this.nodeAffinityLabels != null && !this.nodeAffinityLabels.isEmpty()) {
            sb.append("nodeAffinityLabels:");
            sb.append(this.nodeAffinityLabels + ",");
        }
        if (this.podAffinity != null) {
            sb.append("podAffinity:");
            sb.append(this.podAffinity + ",");
        }
        if (this.podAffinityLabels != null && !this.podAffinityLabels.isEmpty()) {
            sb.append("podAffinityLabels:");
            sb.append(this.podAffinityLabels + ",");
        }
        if (this.podAntiAffinity != null) {
            sb.append("podAntiAffinity:");
            sb.append(this.podAntiAffinity + ",");
        }
        if (this.podAntiAffinityLabels != null && !this.podAntiAffinityLabels.isEmpty()) {
            sb.append("podAntiAffinityLabels:");
            sb.append(this.podAntiAffinityLabels);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withEnabled() {
        return this.withEnabled(true);
    }

    public A withPodAffinity() {
        return this.withPodAffinity(true);
    }

    public A withPodAntiAffinity() {
        return this.withPodAntiAffinity(true);
    }

    public class ConfigurationNested<N>
    extends ConfigurationFluent<ConfigurationNested<N>>
    implements Nested<N> {
        ConfigurationBuilder builder;

        ConfigurationNested(Configuration item) {
            this.builder = new ConfigurationBuilder(this, item);
        }

        public N and() {
            return (N)AffinityFluent.this.withConfiguration(this.builder.build());
        }

        public N endConfiguration() {
            return this.and();
        }
    }
}

