/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.camel.v1.CamelCatalogSpec;
import org.apache.camel.v1.camelcatalogspec.Artifacts;
import org.apache.camel.v1.camelcatalogspec.Loaders;
import org.apache.camel.v1.camelcatalogspec.Runtime;
import org.apache.camel.v1.camelcatalogspec.RuntimeBuilder;
import org.apache.camel.v1.camelcatalogspec.RuntimeFluent;

public class CamelCatalogSpecFluent<A extends CamelCatalogSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Artifacts> artifacts;
    private Map<String, Loaders> loaders;
    private RuntimeBuilder runtime;

    public CamelCatalogSpecFluent() {
    }

    public CamelCatalogSpecFluent(CamelCatalogSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(CamelCatalogSpec instance) {
        CamelCatalogSpec camelCatalogSpec = instance = instance != null ? instance : new CamelCatalogSpec();
        if (instance != null) {
            this.withArtifacts(instance.getArtifacts());
            this.withLoaders(instance.getLoaders());
            this.withRuntime(instance.getRuntime());
        }
    }

    public A addToArtifacts(String key, Artifacts value) {
        if (this.artifacts == null && key != null && value != null) {
            this.artifacts = new LinkedHashMap<String, Artifacts>();
        }
        if (key != null && value != null) {
            this.artifacts.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToArtifacts(Map<String, Artifacts> map) {
        if (this.artifacts == null && map != null) {
            this.artifacts = new LinkedHashMap<String, Artifacts>();
        }
        if (map != null) {
            this.artifacts.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromArtifacts(String key) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        if (key != null && this.artifacts != null) {
            this.artifacts.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromArtifacts(Map<String, Artifacts> map) {
        if (this.artifacts == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.artifacts == null) continue;
                this.artifacts.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Artifacts> getArtifacts() {
        return this.artifacts;
    }

    public <K, V> A withArtifacts(Map<String, Artifacts> artifacts) {
        this.artifacts = artifacts == null ? null : new LinkedHashMap<String, Artifacts>(artifacts);
        return (A)((Object)this);
    }

    public boolean hasArtifacts() {
        return this.artifacts != null;
    }

    public A addToLoaders(String key, Loaders value) {
        if (this.loaders == null && key != null && value != null) {
            this.loaders = new LinkedHashMap<String, Loaders>();
        }
        if (key != null && value != null) {
            this.loaders.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLoaders(Map<String, Loaders> map) {
        if (this.loaders == null && map != null) {
            this.loaders = new LinkedHashMap<String, Loaders>();
        }
        if (map != null) {
            this.loaders.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromLoaders(String key) {
        if (this.loaders == null) {
            return (A)((Object)this);
        }
        if (key != null && this.loaders != null) {
            this.loaders.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromLoaders(Map<String, Loaders> map) {
        if (this.loaders == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.loaders == null) continue;
                this.loaders.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Loaders> getLoaders() {
        return this.loaders;
    }

    public <K, V> A withLoaders(Map<String, Loaders> loaders) {
        this.loaders = loaders == null ? null : new LinkedHashMap<String, Loaders>(loaders);
        return (A)((Object)this);
    }

    public boolean hasLoaders() {
        return this.loaders != null;
    }

    public Runtime buildRuntime() {
        return this.runtime != null ? this.runtime.build() : null;
    }

    public A withRuntime(Runtime runtime) {
        this._visitables.remove((Object)"runtime");
        if (runtime != null) {
            this.runtime = new RuntimeBuilder(runtime);
            this._visitables.get((Object)"runtime").add(this.runtime);
        } else {
            this.runtime = null;
            this._visitables.get((Object)"runtime").remove((Object)this.runtime);
        }
        return (A)((Object)this);
    }

    public boolean hasRuntime() {
        return this.runtime != null;
    }

    public RuntimeNested<A> withNewRuntime() {
        return new RuntimeNested(null);
    }

    public RuntimeNested<A> withNewRuntimeLike(Runtime item) {
        return new RuntimeNested(item);
    }

    public RuntimeNested<A> editCamelcatalogspecRuntime() {
        return this.withNewRuntimeLike(Optional.ofNullable(this.buildRuntime()).orElse(null));
    }

    public RuntimeNested<A> editOrNewRuntime() {
        return this.withNewRuntimeLike(Optional.ofNullable(this.buildRuntime()).orElse(new RuntimeBuilder().build()));
    }

    public RuntimeNested<A> editOrNewRuntimeLike(Runtime item) {
        return this.withNewRuntimeLike(Optional.ofNullable(this.buildRuntime()).orElse(item));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CamelCatalogSpecFluent that = (CamelCatalogSpecFluent)((Object)o);
        if (!Objects.equals(this.artifacts, that.artifacts)) {
            return false;
        }
        if (!Objects.equals(this.loaders, that.loaders)) {
            return false;
        }
        return Objects.equals((Object)this.runtime, (Object)that.runtime);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.artifacts, this.loaders, this.runtime, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.artifacts != null && !this.artifacts.isEmpty()) {
            sb.append("artifacts:");
            sb.append(this.artifacts + ",");
        }
        if (this.loaders != null && !this.loaders.isEmpty()) {
            sb.append("loaders:");
            sb.append(this.loaders + ",");
        }
        if (this.runtime != null) {
            sb.append("runtime:");
            sb.append((Object)this.runtime);
        }
        sb.append("}");
        return sb.toString();
    }

    public class RuntimeNested<N>
    extends RuntimeFluent<RuntimeNested<N>>
    implements Nested<N> {
        RuntimeBuilder builder;

        RuntimeNested(Runtime item) {
            this.builder = new RuntimeBuilder(this, item);
        }

        public N and() {
            return (N)CamelCatalogSpecFluent.this.withRuntime(this.builder.build());
        }

        public N endCamelcatalogspecRuntime() {
            return this.and();
        }
    }
}

