/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.camel.v1.KameletSpec;
import org.apache.camel.v1.kameletspec.DataTypes;
import org.apache.camel.v1.kameletspec.Definition;
import org.apache.camel.v1.kameletspec.DefinitionBuilder;
import org.apache.camel.v1.kameletspec.DefinitionFluent;
import org.apache.camel.v1.kameletspec.Sources;
import org.apache.camel.v1.kameletspec.SourcesBuilder;
import org.apache.camel.v1.kameletspec.SourcesFluent;
import org.apache.camel.v1.kameletspec.Template;
import org.apache.camel.v1.kameletspec.TemplateBuilder;
import org.apache.camel.v1.kameletspec.TemplateFluent;
import org.apache.camel.v1.kameletspec.Types;
import org.apache.camel.v1.kameletspec.Versions;

public class KameletSpecFluent<A extends KameletSpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, DataTypes> dataTypes;
    private DefinitionBuilder definition;
    private List<String> dependencies;
    private ArrayList<SourcesBuilder> sources;
    private TemplateBuilder template;
    private Map<String, Types> types;
    private Map<String, Versions> versions;

    public KameletSpecFluent() {
    }

    public KameletSpecFluent(KameletSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(KameletSpec instance) {
        KameletSpec kameletSpec = instance = instance != null ? instance : new KameletSpec();
        if (instance != null) {
            this.withDataTypes(instance.getDataTypes());
            this.withDefinition(instance.getDefinition());
            this.withDependencies(instance.getDependencies());
            this.withSources(instance.getSources());
            this.withTemplate(instance.getTemplate());
            this.withTypes(instance.getTypes());
            this.withVersions(instance.getVersions());
        }
    }

    public A addToDataTypes(String key, DataTypes value) {
        if (this.dataTypes == null && key != null && value != null) {
            this.dataTypes = new LinkedHashMap<String, DataTypes>();
        }
        if (key != null && value != null) {
            this.dataTypes.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToDataTypes(Map<String, DataTypes> map) {
        if (this.dataTypes == null && map != null) {
            this.dataTypes = new LinkedHashMap<String, DataTypes>();
        }
        if (map != null) {
            this.dataTypes.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromDataTypes(String key) {
        if (this.dataTypes == null) {
            return (A)((Object)this);
        }
        if (key != null && this.dataTypes != null) {
            this.dataTypes.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromDataTypes(Map<String, DataTypes> map) {
        if (this.dataTypes == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.dataTypes == null) continue;
                this.dataTypes.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, DataTypes> getDataTypes() {
        return this.dataTypes;
    }

    public <K, V> A withDataTypes(Map<String, DataTypes> dataTypes) {
        this.dataTypes = dataTypes == null ? null : new LinkedHashMap<String, DataTypes>(dataTypes);
        return (A)((Object)this);
    }

    public boolean hasDataTypes() {
        return this.dataTypes != null;
    }

    public Definition buildDefinition() {
        return this.definition != null ? this.definition.build() : null;
    }

    public A withDefinition(Definition definition) {
        this._visitables.remove((Object)"definition");
        if (definition != null) {
            this.definition = new DefinitionBuilder(definition);
            this._visitables.get((Object)"definition").add(this.definition);
        } else {
            this.definition = null;
            this._visitables.get((Object)"definition").remove((Object)this.definition);
        }
        return (A)((Object)this);
    }

    public boolean hasDefinition() {
        return this.definition != null;
    }

    public DefinitionNested<A> withNewDefinition() {
        return new DefinitionNested(null);
    }

    public DefinitionNested<A> withNewDefinitionLike(Definition item) {
        return new DefinitionNested(item);
    }

    public DefinitionNested<A> editDefinition() {
        return this.withNewDefinitionLike(Optional.ofNullable(this.buildDefinition()).orElse(null));
    }

    public DefinitionNested<A> editOrNewDefinition() {
        return this.withNewDefinitionLike(Optional.ofNullable(this.buildDefinition()).orElse(new DefinitionBuilder().build()));
    }

    public DefinitionNested<A> editOrNewDefinitionLike(Definition item) {
        return this.withNewDefinitionLike(Optional.ofNullable(this.buildDefinition()).orElse(item));
    }

    public A addToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.add(index, item);
        return (A)((Object)this);
    }

    public A setToDependencies(int index, String item) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        this.dependencies.set(index, item);
        return (A)((Object)this);
    }

    public A addToDependencies(String ... items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            this.dependencies = new ArrayList<String>();
        }
        for (String item : items) {
            this.dependencies.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromDependencies(String ... items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dependencies.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromDependencies(Collection<String> items) {
        if (this.dependencies == null) {
            return (A)((Object)this);
        }
        for (String item : items) {
            this.dependencies.remove(item);
        }
        return (A)((Object)this);
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public String getDependency(int index) {
        return this.dependencies.get(index);
    }

    public String getFirstDependency() {
        return this.dependencies.get(0);
    }

    public String getLastDependency() {
        return this.dependencies.get(this.dependencies.size() - 1);
    }

    public String getMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingDependency(Predicate<String> predicate) {
        for (String item : this.dependencies) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withDependencies(List<String> dependencies) {
        if (dependencies != null) {
            this.dependencies = new ArrayList<String>();
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        } else {
            this.dependencies = null;
        }
        return (A)((Object)this);
    }

    public A withDependencies(String ... dependencies) {
        if (this.dependencies != null) {
            this.dependencies.clear();
            this._visitables.remove((Object)"dependencies");
        }
        if (dependencies != null) {
            for (String item : dependencies) {
                this.addToDependencies(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasDependencies() {
        return this.dependencies != null && !this.dependencies.isEmpty();
    }

    public A addToSources(int index, Sources item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        SourcesBuilder builder = new SourcesBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get((Object)"sources").add(index, builder);
            this.sources.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToSources(int index, Sources item) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        SourcesBuilder builder = new SourcesBuilder(item);
        if (index < 0 || index >= this.sources.size()) {
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        } else {
            this._visitables.get((Object)"sources").set(index, builder);
            this.sources.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToSources(Sources ... items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (Sources item : items) {
            SourcesBuilder builder = new SourcesBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToKameletspecSources(Collection<Sources> items) {
        if (this.sources == null) {
            this.sources = new ArrayList();
        }
        for (Sources item : items) {
            SourcesBuilder builder = new SourcesBuilder(item);
            this._visitables.get((Object)"sources").add(builder);
            this.sources.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromSources(Sources ... items) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        for (Sources item : items) {
            SourcesBuilder builder = new SourcesBuilder(item);
            this._visitables.get((Object)"sources").remove((Object)builder);
            this.sources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromKameletspecSources(Collection<Sources> items) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        for (Sources item : items) {
            SourcesBuilder builder = new SourcesBuilder(item);
            this._visitables.get((Object)"sources").remove((Object)builder);
            this.sources.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromKameletspecSources(Predicate<SourcesBuilder> predicate) {
        if (this.sources == null) {
            return (A)((Object)this);
        }
        Iterator<SourcesBuilder> each = this.sources.iterator();
        List visitables = this._visitables.get((Object)"sources");
        while (each.hasNext()) {
            SourcesBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<Sources> buildSources() {
        return this.sources != null ? KameletSpecFluent.build(this.sources) : null;
    }

    public Sources buildSource(int index) {
        return this.sources.get(index).build();
    }

    public Sources buildFirstSource() {
        return this.sources.get(0).build();
    }

    public Sources buildLastSource() {
        return this.sources.get(this.sources.size() - 1).build();
    }

    public Sources buildMatchingSource(Predicate<SourcesBuilder> predicate) {
        for (SourcesBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingSource(Predicate<SourcesBuilder> predicate) {
        for (SourcesBuilder item : this.sources) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withSources(List<Sources> sources) {
        if (this.sources != null) {
            this._visitables.get((Object)"sources").clear();
        }
        if (sources != null) {
            this.sources = new ArrayList();
            for (Sources item : sources) {
                this.addToSources(item);
            }
        } else {
            this.sources = null;
        }
        return (A)((Object)this);
    }

    public A withSources(Sources ... sources) {
        if (this.sources != null) {
            this.sources.clear();
            this._visitables.remove((Object)"sources");
        }
        if (sources != null) {
            for (Sources item : sources) {
                this.addToSources(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasSources() {
        return this.sources != null && !this.sources.isEmpty();
    }

    public SourcesNested<A> addNewSource() {
        return new SourcesNested(-1, null);
    }

    public SourcesNested<A> addNewSourceLike(Sources item) {
        return new SourcesNested(-1, item);
    }

    public SourcesNested<A> setNewSourceLike(int index, Sources item) {
        return new SourcesNested(index, item);
    }

    public SourcesNested<A> editSource(int index) {
        if (this.sources.size() <= index) {
            throw new RuntimeException("Can't edit sources. Index exceeds size.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editFirstSource() {
        if (this.sources.size() == 0) {
            throw new RuntimeException("Can't edit first sources. The list is empty.");
        }
        return this.setNewSourceLike(0, this.buildSource(0));
    }

    public SourcesNested<A> editLastSource() {
        int index = this.sources.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last sources. The list is empty.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public SourcesNested<A> editMatchingSource(Predicate<SourcesBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.sources.size(); ++i) {
            if (!predicate.test(this.sources.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching sources. No match found.");
        }
        return this.setNewSourceLike(index, this.buildSource(index));
    }

    public Template buildTemplate() {
        return this.template != null ? this.template.build() : null;
    }

    public A withTemplate(Template template) {
        this._visitables.remove((Object)"template");
        if (template != null) {
            this.template = new TemplateBuilder(template);
            this._visitables.get((Object)"template").add(this.template);
        } else {
            this.template = null;
            this._visitables.get((Object)"template").remove((Object)this.template);
        }
        return (A)((Object)this);
    }

    public boolean hasTemplate() {
        return this.template != null;
    }

    public TemplateNested<A> withNewTemplate() {
        return new TemplateNested(null);
    }

    public TemplateNested<A> withNewTemplateLike(Template item) {
        return new TemplateNested(item);
    }

    public TemplateNested<A> editKameletspecTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(null));
    }

    public TemplateNested<A> editOrNewTemplate() {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(new TemplateBuilder().build()));
    }

    public TemplateNested<A> editOrNewTemplateLike(Template item) {
        return this.withNewTemplateLike(Optional.ofNullable(this.buildTemplate()).orElse(item));
    }

    public A addToTypes(String key, Types value) {
        if (this.types == null && key != null && value != null) {
            this.types = new LinkedHashMap<String, Types>();
        }
        if (key != null && value != null) {
            this.types.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToTypes(Map<String, Types> map) {
        if (this.types == null && map != null) {
            this.types = new LinkedHashMap<String, Types>();
        }
        if (map != null) {
            this.types.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromTypes(String key) {
        if (this.types == null) {
            return (A)((Object)this);
        }
        if (key != null && this.types != null) {
            this.types.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromTypes(Map<String, Types> map) {
        if (this.types == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.types == null) continue;
                this.types.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Types> getTypes() {
        return this.types;
    }

    public <K, V> A withTypes(Map<String, Types> types) {
        this.types = types == null ? null : new LinkedHashMap<String, Types>(types);
        return (A)((Object)this);
    }

    public boolean hasTypes() {
        return this.types != null;
    }

    public A addToVersions(String key, Versions value) {
        if (this.versions == null && key != null && value != null) {
            this.versions = new LinkedHashMap<String, Versions>();
        }
        if (key != null && value != null) {
            this.versions.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToVersions(Map<String, Versions> map) {
        if (this.versions == null && map != null) {
            this.versions = new LinkedHashMap<String, Versions>();
        }
        if (map != null) {
            this.versions.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromVersions(String key) {
        if (this.versions == null) {
            return (A)((Object)this);
        }
        if (key != null && this.versions != null) {
            this.versions.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromVersions(Map<String, Versions> map) {
        if (this.versions == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.versions == null) continue;
                this.versions.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Versions> getVersions() {
        return this.versions;
    }

    public <K, V> A withVersions(Map<String, Versions> versions) {
        this.versions = versions == null ? null : new LinkedHashMap<String, Versions>(versions);
        return (A)((Object)this);
    }

    public boolean hasVersions() {
        return this.versions != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        KameletSpecFluent that = (KameletSpecFluent)((Object)o);
        if (!Objects.equals(this.dataTypes, that.dataTypes)) {
            return false;
        }
        if (!Objects.equals((Object)this.definition, (Object)that.definition)) {
            return false;
        }
        if (!Objects.equals(this.dependencies, that.dependencies)) {
            return false;
        }
        if (!Objects.equals(this.sources, that.sources)) {
            return false;
        }
        if (!Objects.equals((Object)this.template, (Object)that.template)) {
            return false;
        }
        if (!Objects.equals(this.types, that.types)) {
            return false;
        }
        return Objects.equals(this.versions, that.versions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dataTypes, this.definition, this.dependencies, this.sources, this.template, this.types, this.versions, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dataTypes != null && !this.dataTypes.isEmpty()) {
            sb.append("dataTypes:");
            sb.append(this.dataTypes + ",");
        }
        if (this.definition != null) {
            sb.append("definition:");
            sb.append(this.definition + ",");
        }
        if (this.dependencies != null && !this.dependencies.isEmpty()) {
            sb.append("dependencies:");
            sb.append(this.dependencies + ",");
        }
        if (this.sources != null && !this.sources.isEmpty()) {
            sb.append("sources:");
            sb.append(this.sources + ",");
        }
        if (this.template != null) {
            sb.append("template:");
            sb.append(this.template + ",");
        }
        if (this.types != null && !this.types.isEmpty()) {
            sb.append("types:");
            sb.append(this.types + ",");
        }
        if (this.versions != null && !this.versions.isEmpty()) {
            sb.append("versions:");
            sb.append(this.versions);
        }
        sb.append("}");
        return sb.toString();
    }

    public class DefinitionNested<N>
    extends DefinitionFluent<DefinitionNested<N>>
    implements Nested<N> {
        DefinitionBuilder builder;

        DefinitionNested(Definition item) {
            this.builder = new DefinitionBuilder(this, item);
        }

        public N and() {
            return (N)KameletSpecFluent.this.withDefinition(this.builder.build());
        }

        public N endDefinition() {
            return this.and();
        }
    }

    public class SourcesNested<N>
    extends SourcesFluent<SourcesNested<N>>
    implements Nested<N> {
        SourcesBuilder builder;
        int index;

        SourcesNested(int index, Sources item) {
            this.index = index;
            this.builder = new SourcesBuilder(this, item);
        }

        public N and() {
            return (N)KameletSpecFluent.this.setToSources(this.index, this.builder.build());
        }

        public N endKameletspecSource() {
            return this.and();
        }
    }

    public class TemplateNested<N>
    extends TemplateFluent<TemplateNested<N>>
    implements Nested<N> {
        TemplateBuilder builder;

        TemplateNested(Template item) {
            this.builder = new TemplateBuilder(this, item);
        }

        public N and() {
            return (N)KameletSpecFluent.this.withTemplate(this.builder.build());
        }

        public N endKameletspecTemplate() {
            return this.and();
        }
    }
}

