/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.v1.integrationstatus.traits;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.builder.Editable;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import java.util.Map;
import org.apache.camel.v1.integrationstatus.traits.KnativeServiceBuilder;
import org.apache.camel.v1.integrationstatus.traits.knativeservice.Configuration;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"annotations", "auto", "autoscalingMetric", "autoscalingTarget", "class", "configuration", "enabled", "maxScale", "minScale", "rolloutDuration", "timeoutSeconds", "visibility"})
@JsonDeserialize(using=JsonDeserializer.None.class)
public class KnativeService
implements Editable<KnativeServiceBuilder>,
KubernetesResource {
    @JsonProperty(value="annotations")
    @JsonPropertyDescription(value="The annotations added to route.\nThis can be used to set knative service specific annotations\nCLI usage example: -t \"knative-service.annotations.'haproxy.router.openshift.io/balance'=true\"")
    @JsonSetter(nulls=Nulls.SKIP)
    private Map<String, String> annotations;
    @JsonProperty(value="auto")
    @JsonPropertyDescription(value="Automatically deploy the integration as Knative service when all conditions hold:\n\n\n* Integration is using the Knative profile\n* All routes are either starting from an HTTP based consumer or a passive consumer (e.g. `direct` is a passive consumer)")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean auto;
    @JsonProperty(value="autoscalingMetric")
    @JsonPropertyDescription(value="Configures the Knative autoscaling metric property (e.g. to set `concurrency` based or `cpu` based autoscaling).\n\n\nRefer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String autoscalingMetric;
    @JsonProperty(value="autoscalingTarget")
    @JsonPropertyDescription(value="Sets the allowed concurrency level or CPU percentage (depending on the autoscaling metric) for each Pod.\n\n\nRefer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long autoscalingTarget;
    @JsonProperty(value="class")
    @JsonPropertyDescription(value="Configures the Knative autoscaling class property (e.g. to set `hpa.autoscaling.knative.dev` or `kpa.autoscaling.knative.dev` autoscaling).\n\n\nRefer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Class _class;
    @JsonProperty(value="configuration")
    @JsonPropertyDescription(value="Legacy trait configuration parameters.\nDeprecated: for backward compatibility.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Configuration configuration;
    @JsonProperty(value="enabled")
    @JsonPropertyDescription(value="Can be used to enable or disable a trait. All traits share this common property.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Boolean enabled;
    @JsonProperty(value="maxScale")
    @JsonPropertyDescription(value="An upper bound for the number of Pods that can be running in parallel for the integration.\nKnative has its own cap value that depends on the installation.\n\n\nRefer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long maxScale;
    @JsonProperty(value="minScale")
    @JsonPropertyDescription(value="The minimum number of Pods that should be running at any time for the integration. It's **zero** by default, meaning that\nthe integration is scaled down to zero when not used for a configured amount of time.\n\n\nRefer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long minScale;
    @JsonProperty(value="rolloutDuration")
    @JsonPropertyDescription(value="Enables to gradually shift traffic to the latest Revision and sets the rollout duration.\nIt's disabled by default and must be expressed as a Golang `time.Duration` string representation,\nrounded to a second precision.")
    @JsonSetter(nulls=Nulls.SKIP)
    private String rolloutDuration;
    @JsonProperty(value="timeoutSeconds")
    @JsonPropertyDescription(value="The maximum duration in seconds that the request instance is allowed to respond to a request.\nThis field propagates to the integration pod's terminationGracePeriodSeconds\n\n\nRefer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Long timeoutSeconds;
    @JsonProperty(value="visibility")
    @JsonPropertyDescription(value="Setting `cluster-local`, Knative service becomes a private service.\nSpecifically, this option applies the `networking.knative.dev/visibility` label to Knative service.\n\n\nRefer to the Knative documentation for more information.")
    @JsonSetter(nulls=Nulls.SKIP)
    private Visibility visibility;

    public KnativeServiceBuilder edit() {
        return new KnativeServiceBuilder(this);
    }

    public Map<String, String> getAnnotations() {
        return this.annotations;
    }

    public void setAnnotations(Map<String, String> annotations) {
        this.annotations = annotations;
    }

    public Boolean getAuto() {
        return this.auto;
    }

    public void setAuto(Boolean auto) {
        this.auto = auto;
    }

    public String getAutoscalingMetric() {
        return this.autoscalingMetric;
    }

    public void setAutoscalingMetric(String autoscalingMetric) {
        this.autoscalingMetric = autoscalingMetric;
    }

    public Long getAutoscalingTarget() {
        return this.autoscalingTarget;
    }

    public void setAutoscalingTarget(Long autoscalingTarget) {
        this.autoscalingTarget = autoscalingTarget;
    }

    public Class get_class() {
        return this._class;
    }

    public void set_class(Class _class) {
        this._class = _class;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Long getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(Long maxScale) {
        this.maxScale = maxScale;
    }

    public Long getMinScale() {
        return this.minScale;
    }

    public void setMinScale(Long minScale) {
        this.minScale = minScale;
    }

    public String getRolloutDuration() {
        return this.rolloutDuration;
    }

    public void setRolloutDuration(String rolloutDuration) {
        this.rolloutDuration = rolloutDuration;
    }

    public Long getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    public void setTimeoutSeconds(Long timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(Visibility visibility) {
        this.visibility = visibility;
    }

    public String toString() {
        return "KnativeService(annotations=" + this.getAnnotations() + ", auto=" + this.getAuto() + ", autoscalingMetric=" + this.getAutoscalingMetric() + ", autoscalingTarget=" + this.getAutoscalingTarget() + ", _class=" + this.get_class() + ", configuration=" + this.getConfiguration() + ", enabled=" + this.getEnabled() + ", maxScale=" + this.getMaxScale() + ", minScale=" + this.getMinScale() + ", rolloutDuration=" + this.getRolloutDuration() + ", timeoutSeconds=" + this.getTimeoutSeconds() + ", visibility=" + this.getVisibility() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KnativeService)) {
            return false;
        }
        KnativeService other = (KnativeService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$auto = this.getAuto();
        Boolean other$auto = other.getAuto();
        if (this$auto == null ? other$auto != null : !((Object)this$auto).equals(other$auto)) {
            return false;
        }
        Long this$autoscalingTarget = this.getAutoscalingTarget();
        Long other$autoscalingTarget = other.getAutoscalingTarget();
        if (this$autoscalingTarget == null ? other$autoscalingTarget != null : !((Object)this$autoscalingTarget).equals(other$autoscalingTarget)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Long this$maxScale = this.getMaxScale();
        Long other$maxScale = other.getMaxScale();
        if (this$maxScale == null ? other$maxScale != null : !((Object)this$maxScale).equals(other$maxScale)) {
            return false;
        }
        Long this$minScale = this.getMinScale();
        Long other$minScale = other.getMinScale();
        if (this$minScale == null ? other$minScale != null : !((Object)this$minScale).equals(other$minScale)) {
            return false;
        }
        Long this$timeoutSeconds = this.getTimeoutSeconds();
        Long other$timeoutSeconds = other.getTimeoutSeconds();
        if (this$timeoutSeconds == null ? other$timeoutSeconds != null : !((Object)this$timeoutSeconds).equals(other$timeoutSeconds)) {
            return false;
        }
        Map<String, String> this$annotations = this.getAnnotations();
        Map<String, String> other$annotations = other.getAnnotations();
        if (this$annotations == null ? other$annotations != null : !((Object)this$annotations).equals(other$annotations)) {
            return false;
        }
        String this$autoscalingMetric = this.getAutoscalingMetric();
        String other$autoscalingMetric = other.getAutoscalingMetric();
        if (this$autoscalingMetric == null ? other$autoscalingMetric != null : !this$autoscalingMetric.equals(other$autoscalingMetric)) {
            return false;
        }
        Class this$_class = this.get_class();
        Class other$_class = other.get_class();
        if (this$_class == null ? other$_class != null : !((Object)((Object)this$_class)).equals((Object)other$_class)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !((Object)this$configuration).equals(other$configuration)) {
            return false;
        }
        String this$rolloutDuration = this.getRolloutDuration();
        String other$rolloutDuration = other.getRolloutDuration();
        if (this$rolloutDuration == null ? other$rolloutDuration != null : !this$rolloutDuration.equals(other$rolloutDuration)) {
            return false;
        }
        Visibility this$visibility = this.getVisibility();
        Visibility other$visibility = other.getVisibility();
        return !(this$visibility == null ? other$visibility != null : !((Object)((Object)this$visibility)).equals((Object)other$visibility));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KnativeService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $auto = this.getAuto();
        result = result * 59 + ($auto == null ? 43 : ((Object)$auto).hashCode());
        Long $autoscalingTarget = this.getAutoscalingTarget();
        result = result * 59 + ($autoscalingTarget == null ? 43 : ((Object)$autoscalingTarget).hashCode());
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Long $maxScale = this.getMaxScale();
        result = result * 59 + ($maxScale == null ? 43 : ((Object)$maxScale).hashCode());
        Long $minScale = this.getMinScale();
        result = result * 59 + ($minScale == null ? 43 : ((Object)$minScale).hashCode());
        Long $timeoutSeconds = this.getTimeoutSeconds();
        result = result * 59 + ($timeoutSeconds == null ? 43 : ((Object)$timeoutSeconds).hashCode());
        Map<String, String> $annotations = this.getAnnotations();
        result = result * 59 + ($annotations == null ? 43 : ((Object)$annotations).hashCode());
        String $autoscalingMetric = this.getAutoscalingMetric();
        result = result * 59 + ($autoscalingMetric == null ? 43 : $autoscalingMetric.hashCode());
        Class $_class = this.get_class();
        result = result * 59 + ($_class == null ? 43 : ((Object)((Object)$_class)).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : ((Object)$configuration).hashCode());
        String $rolloutDuration = this.getRolloutDuration();
        result = result * 59 + ($rolloutDuration == null ? 43 : $rolloutDuration.hashCode());
        Visibility $visibility = this.getVisibility();
        result = result * 59 + ($visibility == null ? 43 : ((Object)((Object)$visibility)).hashCode());
        return result;
    }

    public static enum Class {
        KPA_AUTOSCALING_KNATIVE_DEV("kpa.autoscaling.knative.dev"),
        HPA_AUTOSCALING_KNATIVE_DEV("hpa.autoscaling.knative.dev");

        String value;

        private Class(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }

    public static enum Visibility {
        CLUSTERLOCAL("cluster-local");

        String value;

        private Visibility(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

