/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.dialog.datadomain;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JPopupMenu;
import org.apache.cayenne.modeler.ProjectController;
import org.apache.cayenne.modeler.dialog.datadomain.FilterController;
import org.apache.cayenne.swing.BindingBuilder;

public class FilterDialog
extends JPopupMenu {
    private JCheckBox dbEntity;
    private JCheckBox objEntity;
    private JCheckBox embeddable;
    private JCheckBox procedure;
    private JCheckBox query;
    private JCheckBox all;
    private ProjectController eventController;
    private FilterController filterController;

    public Boolean getDbEntityFilter() {
        return this.filterController.getFilterMap().get("dbEntity");
    }

    public void setDbEntityFilter(Boolean value) {
        this.filterController.getFilterMap().put("dbEntity", value);
    }

    public Boolean getObjEntityFilter() {
        return this.filterController.getFilterMap().get("objEntity");
    }

    public void setObjEntityFilter(Boolean value) {
        this.filterController.getFilterMap().put("objEntity", value);
    }

    public Boolean getEmbeddableFilter() {
        return this.filterController.getFilterMap().get("embeddable");
    }

    public void setEmbeddableFilter(Boolean value) {
        this.filterController.getFilterMap().put("embeddable", value);
    }

    public Boolean getProcedureFilter() {
        return this.filterController.getFilterMap().get("procedure");
    }

    public void setProcedureFilter(Boolean value) {
        this.filterController.getFilterMap().put("procedure", value);
    }

    public Boolean getQueryFilter() {
        return this.filterController.getFilterMap().get("query");
    }

    public void setQueryFilter(Boolean value) {
        this.filterController.getFilterMap().put("query", value);
    }

    public Boolean getAllFilter() {
        for (Boolean selected : this.filterController.getFilterMap().values()) {
            if (selected.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public void setAllFilter(Boolean value) {
    }

    public FilterDialog(FilterController filterController) {
        this.filterController = filterController;
        this.eventController = filterController.getEventController();
        this.initView();
        this.initController();
    }

    public void initView() {
        this.all = new JCheckBox("Show all");
        this.dbEntity = new JCheckBox("DbEntity");
        this.objEntity = new JCheckBox("ObjEntity");
        this.embeddable = new JCheckBox("Embeddable");
        this.procedure = new JCheckBox("Procedure");
        this.query = new JCheckBox("Query");
        this.add(this.all);
        this.addSeparator();
        this.add(this.dbEntity);
        this.add(this.objEntity);
        this.add(this.embeddable);
        this.add(this.procedure);
        this.add(this.query);
    }

    private void initController() {
        BindingBuilder builder = new BindingBuilder(this.eventController.getApplication().getBindingFactory(), this);
        builder.bindToStateChange(this.dbEntity, "dbEntityFilter").updateView();
        builder.bindToStateChange(this.objEntity, "objEntityFilter").updateView();
        builder.bindToStateChange(this.embeddable, "embeddableFilter").updateView();
        builder.bindToStateChange(this.procedure, "procedureFilter").updateView();
        builder.bindToStateChange(this.query, "queryFilter").updateView();
        builder.bindToStateChange(this.all, "allFilter").updateView();
        this.dbEntity.addActionListener(new CheckListener("dbEntity"));
        this.objEntity.addActionListener(new CheckListener("objEntity"));
        this.embeddable.addActionListener(new CheckListener("embeddable"));
        this.procedure.addActionListener(new CheckListener("procedure"));
        this.query.addActionListener(new CheckListener("query"));
        this.all.setEnabled(false);
        this.all.addActionListener(e -> {
            this.dbEntity.setSelected(true);
            this.objEntity.setSelected(true);
            this.embeddable.setSelected(true);
            this.procedure.setSelected(true);
            this.query.setSelected(true);
            this.all.setEnabled(false);
            this.filterController.getTreeModel().setFiltered(this.filterController.getFilterMap());
            this.filterController.getTree().updateUI();
        });
    }

    void checkAllStates() {
        if (!this.getAllFilter().booleanValue()) {
            this.all.setSelected(false);
            this.all.setEnabled(true);
        } else {
            this.all.setSelected(true);
            this.all.setEnabled(false);
        }
    }

    private class CheckListener
    implements ActionListener {
        String key;

        public CheckListener(String key) {
            this.key = key;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FilterDialog.this.filterController.getFilterMap().put(this.key, ((JCheckBox)e.getSource()).isSelected());
            FilterDialog.this.filterController.getTreeModel().setFiltered(FilterDialog.this.filterController.getFilterMap());
            FilterDialog.this.filterController.getTree().updateUI();
            FilterDialog.this.checkAllStates();
        }
    }
}

