/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.eventing.shared.handlers;

import jakarta.xml.soap.SOAPException;
import jakarta.xml.ws.handler.MessageContext;
import jakarta.xml.ws.handler.soap.SOAPHandler;
import jakarta.xml.ws.handler.soap.SOAPMessageContext;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SubscriptionReferenceParsingHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Logger LOG = LogUtils.getLogger(SubscriptionReferenceParsingHandler.class);
    private final String namespace;
    private final String elementName;

    public SubscriptionReferenceParsingHandler(String namespace, String elementName) {
        this.namespace = namespace;
        this.elementName = elementName;
    }

    public SubscriptionReferenceParsingHandler() {
        this.namespace = "http://cxf.apache.org/ws-eventing";
        this.elementName = "SubscriptionID";
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public boolean handleMessage(SOAPMessageContext context) {
        if (((Boolean)context.get((Object)"jakarta.xml.ws.handler.message.outbound")).booleanValue()) {
            return true;
        }
        try {
            LOG.finer("Examining header elements");
            Element el = DOMUtils.getFirstElement((Node)context.getMessage().getSOAPHeader());
            while (el != null) {
                if (el.getNamespaceURI().equals(this.namespace) && el.getLocalName().equals(this.elementName)) {
                    LOG.log(Level.FINE, "found UUID parameter in header, uuid={0}", el.getTextContent());
                    context.put((Object)"uuid", (Object)el.getTextContent());
                }
                el = DOMUtils.getNextElement((Element)el);
            }
        }
        catch (SOAPException e) {
            throw new RuntimeException(e);
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    public void close(MessageContext context) {
    }
}

