/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.transport.http.netty.server.NettyHttpHandler;
import org.apache.cxf.transport.http.netty.server.servlet.NettyServletContext;

public class NettyHttpContextHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpContextHandler.class);
    private final ServletContext servletContext;
    private List<NettyHttpHandler> nettyHttpHandlerList = new CopyOnWriteArrayList<NettyHttpHandler>();

    public NettyHttpContextHandler(String contextPath) {
        this.servletContext = new NettyServletContext(contextPath);
    }

    public void addNettyHttpHandler(NettyHttpHandler handler) {
        handler.setServletContext(this.servletContext);
        this.nettyHttpHandlerList.add(handler);
    }

    public NettyHttpHandler getNettyHttpHandler(String urlName) {
        for (NettyHttpHandler handler : this.nettyHttpHandlerList) {
            if (!urlName.equals(handler.getName())) continue;
            return handler;
        }
        return null;
    }

    public boolean isEmpty() {
        return this.nettyHttpHandlerList.isEmpty();
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public void removeNettyHttpHandler(String urlName) {
        NettyHttpHandler handler = this.getNettyHttpHandler(urlName);
        if (handler != null) {
            this.nettyHttpHandlerList.remove(handler);
        } else {
            LOG.log(Level.WARNING, "REMOVE_HANDLER_FAILED_MSG", urlName);
        }
    }

    public void handle(String target, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        for (NettyHttpHandler handler : this.nettyHttpHandlerList) {
            handler.handle(target, request, response);
        }
    }
}

