/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.PathSegment;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.ext.RuntimeDelegate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.common.util.UrlUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.impl.HttpHeadersImpl;
import org.apache.cxf.jaxrs.impl.HttpServletRequestFilter;
import org.apache.cxf.jaxrs.impl.HttpServletResponseFilter;
import org.apache.cxf.jaxrs.impl.MetadataMap;
import org.apache.cxf.jaxrs.impl.PathSegmentImpl;
import org.apache.cxf.jaxrs.impl.RuntimeDelegateImpl;
import org.apache.cxf.jaxrs.model.ParameterType;
import org.apache.cxf.jaxrs.springmvc.SpringWebUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.transport.http.AbstractHTTPDestination;
import org.apache.cxf.transport.http.Headers;
import org.apache.cxf.transport.servlet.BaseUrlHelper;

public final class HttpUtils {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(HttpUtils.class);
    private static final Logger LOG = LogUtils.getL7dLogger(HttpUtils.class);
    private static final String REQUEST_PATH_TO_MATCH = "path_to_match";
    private static final String REQUEST_PATH_TO_MATCH_SLASH = "path_to_match_slash";
    private static final String HTTP_SCHEME = "http";
    private static final String WS_SCHEME = "ws";
    private static final String WSS_SCHEME = "wss";
    private static final String LOCAL_HOST_IP_ADDRESS = "127.0.0.1";
    private static final String REPLACE_LOOPBACK_PROPERTY = "replace.loopback.address.with.localhost";
    private static final String LOCAL_HOST_IP_ADDRESS_SCHEME = "://127.0.0.1";
    private static final String ANY_IP_ADDRESS = "0.0.0.0";
    private static final String ANY_IP_ADDRESS_SCHEME = "://0.0.0.0";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final Pattern ENCODE_PATTERN = Pattern.compile("%[0-9a-fA-F][0-9a-fA-F]");
    private static final String CHARSET_PARAMETER = "charset";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String PATH_RESERVED_CHARACTERS = "=@/:!$&'(),;~";
    private static final String QUERY_RESERVED_CHARACTERS = "?/,";
    private static final Set<String> KNOWN_HTTP_VERBS_WITH_NO_REQUEST_CONTENT = new HashSet<String>(Arrays.asList("GET", "HEAD", "OPTIONS", "TRACE"));
    private static final Set<String> KNOWN_HTTP_VERBS_WITH_NO_RESPONSE_CONTENT = new HashSet<String>(Arrays.asList("HEAD", "OPTIONS"));
    private static final Pattern HTTP_SCHEME_PATTERN = Pattern.compile("^(?i)(http|https)$");

    private HttpUtils() {
    }

    public static String urlDecode(String value, String enc) {
        return UrlUtils.urlDecode((String)value, (String)enc);
    }

    public static String urlDecode(String value) {
        return UrlUtils.urlDecode((String)value);
    }

    public static String pathDecode(String value) {
        return UrlUtils.pathDecode((String)value);
    }

    private static String componentEncode(String reservedChars, String value) {
        StringBuilder buffer = null;
        int length = value.length();
        int startingIndex = 0;
        for (int i = 0; i < length; ++i) {
            char currentChar = value.charAt(i);
            if (reservedChars.indexOf(currentChar) == -1) continue;
            if (buffer == null) {
                buffer = new StringBuilder(length + 8);
            }
            if (i != startingIndex) {
                buffer.append(HttpUtils.urlEncode(value.substring(startingIndex, i)));
            }
            buffer.append(currentChar);
            startingIndex = i + 1;
        }
        if (buffer == null) {
            return HttpUtils.urlEncode(value);
        }
        if (startingIndex < length) {
            buffer.append(HttpUtils.urlEncode(value.substring(startingIndex, length)));
        }
        return buffer.toString();
    }

    public static String queryEncode(String value) {
        return HttpUtils.componentEncode(QUERY_RESERVED_CHARACTERS, value);
    }

    public static String urlEncode(String value) {
        return HttpUtils.urlEncode(value, StandardCharsets.UTF_8.name());
    }

    public static String urlEncode(String value, String enc) {
        return UrlUtils.urlEncode((String)value, (String)enc);
    }

    public static String pathEncode(String value) {
        String result = HttpUtils.componentEncode(PATH_RESERVED_CHARACTERS, value);
        if (result.indexOf(43) != -1) {
            result = result.replace("+", "%20");
        }
        if (result.indexOf("%2B") != -1) {
            result = result.replace("%2B", "+");
        }
        return result;
    }

    public static boolean isPartiallyEncoded(String value) {
        return ENCODE_PATTERN.matcher(value).find();
    }

    public static String encodePartiallyEncoded(String encoded, boolean query) {
        if (encoded.length() == 0) {
            return encoded;
        }
        Matcher m = ENCODE_PATTERN.matcher(encoded);
        if (!m.find()) {
            return query ? HttpUtils.queryEncode(encoded) : HttpUtils.pathEncode(encoded);
        }
        int length = encoded.length();
        StringBuilder sb = new StringBuilder(length + 8);
        int i = 0;
        do {
            String before = encoded.substring(i, m.start());
            sb.append(query ? HttpUtils.queryEncode(before) : HttpUtils.pathEncode(before));
            sb.append(m.group());
            i = m.end();
        } while (m.find());
        String tail = encoded.substring(i, length);
        sb.append(query ? HttpUtils.queryEncode(tail) : HttpUtils.pathEncode(tail));
        return sb.toString();
    }

    public static SimpleDateFormat getHttpDateFormat() {
        return Headers.getHttpDateFormat();
    }

    public static String toHttpDate(Date date) {
        return Headers.toHttpDate((Date)date);
    }

    public static RuntimeDelegate getOtherRuntimeDelegate() {
        try {
            RuntimeDelegate rd = RuntimeDelegate.getInstance();
            return rd instanceof RuntimeDelegateImpl ? null : rd;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static RuntimeDelegate.HeaderDelegate<Object> getHeaderDelegate(Object o) {
        return HttpUtils.getHeaderDelegate(RuntimeDelegate.getInstance(), o);
    }

    public static RuntimeDelegate.HeaderDelegate<Object> getHeaderDelegate(RuntimeDelegate rd, Object o) {
        return rd == null ? null : rd.createHeaderDelegate(o.getClass());
    }

    public static <T> MultivaluedMap<String, T> getModifiableStringHeaders(Message m) {
        MultivaluedMap<String, Object> headers = HttpUtils.getModifiableHeaders(m);
        HttpUtils.convertHeaderValuesToString(headers, false);
        return headers;
    }

    public static MultivaluedMap<String, Object> getModifiableHeaders(Message m) {
        Map headers = CastUtils.cast((Map)((Map)m.get((Object)Message.PROTOCOL_HEADERS)));
        return new MetadataMap<String, Object>(headers, false, false, true);
    }

    public static void convertHeaderValuesToString(Map<String, List<Object>> headers, boolean delegateOnly) {
        if (headers == null) {
            return;
        }
        RuntimeDelegate rd = HttpUtils.getOtherRuntimeDelegate();
        if (rd == null && delegateOnly) {
            return;
        }
        for (Map.Entry<String, List<Object>> entry : headers.entrySet()) {
            List<Object> values = entry.getValue();
            for (int i = 0; i < values.size(); ++i) {
                Object value = values.get(i);
                if (value == null || value instanceof String) continue;
                RuntimeDelegate.HeaderDelegate<Object> hd = HttpUtils.getHeaderDelegate(rd, value);
                if (hd != null) {
                    value = hd.toString(value);
                } else if (!delegateOnly) {
                    value = value.toString();
                }
                try {
                    values.set(i, value);
                    continue;
                }
                catch (UnsupportedOperationException ex) {
                    ArrayList<Object> newList = new ArrayList<Object>(values);
                    newList.set(i, value);
                    headers.put(entry.getKey(), newList);
                }
            }
        }
    }

    public static Date getHttpDate(String value) {
        if (value == null) {
            return null;
        }
        try {
            return Headers.getHttpDateFormat().parse(value);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public static Locale getLocale(String value) {
        String language;
        if (value == null) {
            return null;
        }
        String locale = null;
        int index = value.indexOf(45);
        if (index == 0 || index == value.length() - 1) {
            throw new IllegalArgumentException("Illegal locale value : " + value);
        }
        if (index > 0) {
            language = value.substring(0, index);
            locale = value.substring(index + 1);
        } else {
            language = value;
        }
        if (locale == null) {
            return new Locale(language);
        }
        return new Locale(language, locale);
    }

    public static int getContentLength(String value) {
        if (value == null) {
            return -1;
        }
        try {
            int len = Integer.parseInt(value);
            return len >= 0 ? len : -1;
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public static String getHeaderString(List<String> values) {
        if (values == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            if (StringUtils.isEmpty((String)value)) continue;
            sb.append(value);
            if (i + 1 >= values.size()) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static boolean isDateRelatedHeader(String headerName) {
        return "Date".equalsIgnoreCase(headerName) || "If-Modified-Since".equalsIgnoreCase(headerName) || "If-Unmodified-Since".equalsIgnoreCase(headerName) || "Expires".equalsIgnoreCase(headerName) || "Last-Modified".equalsIgnoreCase(headerName);
    }

    public static boolean isHttpRequest(Message message) {
        return message.get((Object)"HTTP.REQUEST") != null;
    }

    public static URI toAbsoluteUri(String relativePath, Message message) {
        String base = BaseUrlHelper.getBaseURL((HttpServletRequest)((HttpServletRequest)message.get((Object)"HTTP.REQUEST")));
        return URI.create(base + relativePath);
    }

    public static void setHttpRequestURI(Message message, String uriTemplate) {
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        SpringWebUtils.setHttpRequestURI(request, uriTemplate);
    }

    public static URI toAbsoluteUri(URI u, Message message) {
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        boolean absolute = u.isAbsolute();
        StringBuilder uriBuf = new StringBuilder();
        if (request != null && (!absolute || HttpUtils.isLocalHostOrAnyIpAddress(u, uriBuf, message))) {
            int port;
            Object serverAndPort = request.getServerName();
            boolean localAddressUsed = false;
            if (absolute) {
                if (ANY_IP_ADDRESS.equals(serverAndPort)) {
                    serverAndPort = request.getLocalAddr();
                    localAddressUsed = true;
                }
                if (LOCAL_HOST_IP_ADDRESS.equals(serverAndPort)) {
                    serverAndPort = "localhost";
                    localAddressUsed = true;
                }
            }
            int n = port = localAddressUsed ? request.getLocalPort() : request.getServerPort();
            if (port != 80) {
                serverAndPort = (String)serverAndPort + ":" + port;
            }
            String base = request.getScheme() + "://" + (String)serverAndPort;
            if (!absolute) {
                u = URI.create(base + u.toString());
            } else {
                int originalPort = u.getPort();
                String hostValue = uriBuf.toString().contains(ANY_IP_ADDRESS_SCHEME) ? ANY_IP_ADDRESS : LOCAL_HOST_IP_ADDRESS;
                String replaceValue = originalPort == -1 ? hostValue : hostValue + ":" + originalPort;
                u = URI.create(u.toString().replace(replaceValue, (CharSequence)serverAndPort));
            }
        }
        return u;
    }

    private static boolean isLocalHostOrAnyIpAddress(URI u, StringBuilder uriStringBuffer, Message m) {
        String uriString = u.toString();
        boolean result = uriString.contains(LOCAL_HOST_IP_ADDRESS_SCHEME) && HttpUtils.replaceLoopBackAddress(m) || uriString.contains(ANY_IP_ADDRESS_SCHEME);
        uriStringBuffer.append(uriString);
        return result;
    }

    private static boolean replaceLoopBackAddress(Message m) {
        Object prop = m.getContextualProperty(REPLACE_LOOPBACK_PROPERTY);
        return prop == null || PropertyUtils.isTrue((Object)prop);
    }

    public static void resetRequestURI(Message m, String requestURI) {
        m.remove((Object)REQUEST_PATH_TO_MATCH_SLASH);
        m.remove((Object)REQUEST_PATH_TO_MATCH);
        m.put((Object)"org.apache.cxf.request.uri", (Object)requestURI);
    }

    public static String getPathToMatch(Message m, boolean addSlash) {
        int index;
        String var = addSlash ? REQUEST_PATH_TO_MATCH_SLASH : REQUEST_PATH_TO_MATCH;
        String pathToMatch = (String)m.get((Object)var);
        if (pathToMatch != null) {
            return pathToMatch;
        }
        String requestAddress = HttpUtils.getProtocolHeader(m, "org.apache.cxf.request.uri", "/");
        if (m.get((Object)Message.QUERY_STRING) == null && (index = requestAddress.lastIndexOf(63)) > 0 && index < requestAddress.length()) {
            m.put((Object)Message.QUERY_STRING, (Object)requestAddress.substring(index + 1));
            requestAddress = requestAddress.substring(0, index);
        }
        String baseAddress = HttpUtils.getBaseAddress(m);
        pathToMatch = HttpUtils.getPathToMatch(requestAddress, baseAddress, addSlash);
        m.put((Object)var, (Object)pathToMatch);
        return pathToMatch;
    }

    public static String getProtocolHeader(Message m, String name, String defaultValue) {
        return HttpUtils.getProtocolHeader(m, name, defaultValue, false);
    }

    public static String getProtocolHeader(Message m, String name, String defaultValue, boolean setOnMessage) {
        String value = (String)m.get((Object)name);
        if (value == null && (value = (String)new HttpHeadersImpl(m).getRequestHeaders().getFirst((Object)name)) != null && setOnMessage) {
            m.put((Object)name, (Object)value);
        }
        return value == null ? defaultValue : value;
    }

    public static String getBaseAddress(Message m) {
        String endpointAddress = HttpUtils.getEndpointAddress(m);
        try {
            URI uri = new URI(endpointAddress);
            String path = uri.getRawPath();
            String scheme = uri.getScheme();
            if (scheme != null && !scheme.toLowerCase().startsWith(HTTP_SCHEME) && !scheme.toLowerCase().startsWith(WS_SCHEME) && !scheme.toLowerCase().startsWith(WSS_SCHEME) && HttpUtils.isHttpRequest(m)) {
                path = HttpUtils.toAbsoluteUri(path, m).getRawPath();
            }
            return path == null || path.length() == 0 ? "/" : path;
        }
        catch (URISyntaxException ex) {
            return endpointAddress;
        }
    }

    public static String getEndpointUri(Message m) {
        Object property;
        Object servletRequest = m.get((Object)"HTTP.REQUEST");
        if (servletRequest != null && (property = ((HttpServletRequest)servletRequest).getAttribute("org.apache.cxf.transport.endpoint.uri")) != null) {
            return property.toString();
        }
        return HttpUtils.getEndpointAddress(m);
    }

    public static String getEndpointAddress(Message m) {
        String address;
        Destination d = m.getExchange().getDestination();
        if (d != null) {
            if (d instanceof AbstractHTTPDestination) {
                EndpointInfo ei = ((AbstractHTTPDestination)d).getEndpointInfo();
                HttpServletRequest request = (HttpServletRequest)m.get((Object)"HTTP.REQUEST");
                Object property = request != null ? request.getAttribute("org.apache.cxf.transport.endpoint.address") : null;
                address = property != null ? property.toString() : ei.getAddress();
            } else {
                address = m.containsKey((Object)Message.BASE_PATH) ? (String)m.get((Object)Message.BASE_PATH) : d.getAddress().getAddress().getValue();
            }
        } else {
            address = (String)m.get((Object)Message.ENDPOINT_ADDRESS);
        }
        if (address.startsWith(HTTP_SCHEME) && address.endsWith("//")) {
            address = address.substring(0, address.length() - 1);
        }
        return address;
    }

    public static void updatePath(Message m, String path) {
        String baseAddress = HttpUtils.getBaseAddress(m);
        boolean pathSlash = ((String)path).startsWith("/");
        boolean baseSlash = baseAddress.endsWith("/");
        if (pathSlash && baseSlash) {
            path = ((String)path).substring(1);
        } else if (!pathSlash && !baseSlash) {
            path = "/" + (String)path;
        }
        m.put((Object)"org.apache.cxf.request.uri", (Object)(baseAddress + (String)path));
        m.remove((Object)REQUEST_PATH_TO_MATCH);
        m.remove((Object)REQUEST_PATH_TO_MATCH_SLASH);
    }

    public static String getPathToMatch(String path, String address, boolean addSlash) {
        int ind = ((String)path).indexOf(address);
        if (ind == -1 && address.equals((String)path + "/")) {
            path = (String)path + "/";
            ind = 0;
        }
        if (ind == 0) {
            path = ((String)path).substring(address.length());
        }
        if (addSlash && !((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return path;
    }

    public static String getOriginalAddress(Message m) {
        Destination d = m.getDestination();
        return d == null ? "/" : d.getAddress().getAddress().getValue();
    }

    public static String fromPathSegment(PathSegment ps) {
        if (PathSegmentImpl.class.isAssignableFrom(ps.getClass())) {
            return ((PathSegmentImpl)ps).getOriginalPath();
        }
        StringBuilder sb = new StringBuilder();
        sb.append(ps.getPath());
        for (Map.Entry entry : ps.getMatrixParameters().entrySet()) {
            for (String value : (List)entry.getValue()) {
                sb.append(';').append((String)entry.getKey());
                if (value == null) continue;
                sb.append('=').append(value);
            }
        }
        return sb.toString();
    }

    public static Response.Status getParameterFailureStatus(ParameterType pType) {
        if (pType == ParameterType.MATRIX || pType == ParameterType.PATH || pType == ParameterType.QUERY) {
            return Response.Status.NOT_FOUND;
        }
        return Response.Status.BAD_REQUEST;
    }

    public static String getSetEncoding(MediaType mt, MultivaluedMap<String, Object> headers, String defaultEncoding) {
        String enc = HttpUtils.getMediaTypeCharsetParameter(mt);
        if (enc == null) {
            return defaultEncoding;
        }
        try {
            "0".getBytes(enc);
            return enc;
        }
        catch (UnsupportedEncodingException ex) {
            String message = new org.apache.cxf.common.i18n.Message("UNSUPPORTED_ENCODING", BUNDLE, new Object[]{enc, defaultEncoding}).toString();
            LOG.warning(message);
            headers.putSingle((Object)"Content-Type", (Object)(JAXRSUtils.mediaTypeToString(mt, CHARSET_PARAMETER) + ";charset=" + String.valueOf(defaultEncoding == null ? StandardCharsets.UTF_8 : defaultEncoding)));
            return defaultEncoding;
        }
    }

    public static String getEncoding(MediaType mt, String defaultEncoding) {
        String charset = mt == null ? defaultEncoding : HttpUtils.getMediaTypeCharsetParameter(mt);
        return charset == null ? defaultEncoding : charset;
    }

    public static String getMediaTypeCharsetParameter(MediaType mt) {
        String charset = (String)mt.getParameters().get(CHARSET_PARAMETER);
        if (charset != null && charset.startsWith(DOUBLE_QUOTE) && charset.endsWith(DOUBLE_QUOTE) && charset.length() > 1) {
            charset = charset.substring(1, charset.length() - 1);
        }
        return charset;
    }

    public static URI resolve(UriBuilder baseBuilder, URI uri) {
        if (!uri.isAbsolute()) {
            return baseBuilder.build(new Object[0]).resolve(uri);
        }
        return uri;
    }

    public static URI relativize(URI base, URI uri) {
        if (!base.isAbsolute() || !uri.isAbsolute()) {
            return uri;
        }
        if (base.isOpaque() || uri.isOpaque()) {
            return uri;
        }
        URI root = base.resolve("/");
        if (!root.equals(uri.resolve("/"))) {
            return uri;
        }
        URI baseRel = URI.create("/").resolve(root.relativize(base));
        URI uriRel = URI.create("/").resolve(root.relativize(uri));
        if (baseRel.getPath().equals(uriRel.getPath())) {
            return baseRel.relativize(uriRel);
        }
        URI commonBase = baseRel.resolve("./");
        if (commonBase.equals(uriRel.resolve("./"))) {
            return commonBase.relativize(uriRel);
        }
        URI relative = URI.create("");
        while (!uriRel.getPath().startsWith(commonBase.getPath()) && !"/".equals(commonBase.getPath())) {
            commonBase = commonBase.resolve("../");
            relative = relative.resolve("../");
        }
        URI relToCommon = commonBase.relativize(uriRel);
        return relative.resolve(relToCommon);
    }

    public static String toHttpLanguage(Locale locale) {
        return Headers.toHttpLanguage((Locale)locale);
    }

    public static boolean isPayloadEmpty(MultivaluedMap<String, String> headers) {
        String value;
        if (headers != null && (value = (String)headers.getFirst((Object)"Content-Length")) != null) {
            try {
                Long len = Long.valueOf(value);
                return len <= 0L;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    public static <T> T createServletResourceValue(Message m, Class<T> clazz) {
        Object value = null;
        if (clazz == HttpServletRequest.class) {
            HttpServletRequest request = (HttpServletRequest)m.get((Object)"HTTP.REQUEST");
            value = request != null ? new HttpServletRequestFilter(request, m) : null;
        } else if (clazz == HttpServletResponse.class) {
            HttpServletResponse response = (HttpServletResponse)m.get((Object)"HTTP.RESPONSE");
            value = response != null ? new HttpServletResponseFilter(response, m) : null;
        } else if (clazz == ServletContext.class) {
            value = m.get((Object)"HTTP.CONTEXT");
        } else if (clazz == ServletConfig.class) {
            value = m.get((Object)"HTTP.CONFIG");
        }
        return clazz.cast(value);
    }

    public static boolean isMethodWithNoRequestContent(String method) {
        return KNOWN_HTTP_VERBS_WITH_NO_REQUEST_CONTENT.contains(method);
    }

    public static boolean isMethodWithNoResponseContent(String method) {
        return KNOWN_HTTP_VERBS_WITH_NO_RESPONSE_CONTENT.contains(method);
    }

    public static boolean isHttpScheme(String scheme) {
        return scheme != null && HTTP_SCHEME_PATTERN.matcher(scheme).matches();
    }
}

