/*
 * Decompiled with CFR 0.152.
 */
package org.ehcache.config.builders;

import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.ehcache.CacheManager;
import org.ehcache.PersistentCacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.CacheConfiguration;
import org.ehcache.config.Configuration;
import org.ehcache.config.FluentConfigurationBuilder;
import org.ehcache.config.ResourcePools;
import org.ehcache.config.builders.CacheManagerConfiguration;
import org.ehcache.config.builders.ConfigurationBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.EhcacheManager;
import org.ehcache.impl.config.copy.DefaultCopyProviderConfiguration;
import org.ehcache.impl.config.event.CacheEventDispatcherFactoryConfiguration;
import org.ehcache.impl.config.loaderwriter.writebehind.WriteBehindProviderConfiguration;
import org.ehcache.impl.config.persistence.CacheManagerPersistenceConfiguration;
import org.ehcache.impl.config.serializer.DefaultSerializationProviderConfiguration;
import org.ehcache.impl.config.store.disk.OffHeapDiskStoreProviderConfiguration;
import org.ehcache.impl.config.store.heap.DefaultSizeOfEngineConfiguration;
import org.ehcache.impl.config.store.heap.DefaultSizeOfEngineProviderConfiguration;
import org.ehcache.impl.config.store.shared.SharedStorageConfiguration;
import org.ehcache.spi.copy.Copier;
import org.ehcache.spi.serialization.Serializer;
import org.ehcache.spi.service.Service;
import org.ehcache.spi.service.ServiceCreationConfiguration;

public class CacheManagerBuilder<T extends CacheManager>
implements Builder<T> {
    private final FluentConfigurationBuilder<?> configBuilder;
    private final Set<Service> services;

    public T build(boolean init) {
        T cacheManager = this.newCacheManager(this.services, (Configuration)this.configBuilder.build());
        if (init) {
            cacheManager.init();
        }
        return cacheManager;
    }

    @Override
    public T build() {
        return this.build(false);
    }

    private CacheManagerBuilder() {
        this.configBuilder = ConfigurationBuilder.newConfigurationBuilder();
        this.services = Collections.emptySet();
    }

    private CacheManagerBuilder(CacheManagerBuilder<T> builder, Set<Service> services) {
        this.configBuilder = builder.configBuilder;
        this.services = Collections.unmodifiableSet(services);
    }

    private CacheManagerBuilder(CacheManagerBuilder<T> builder, FluentConfigurationBuilder<?> configBuilder) {
        this.configBuilder = configBuilder;
        this.services = builder.services;
    }

    public static CacheManager newCacheManager(Configuration configuration) {
        return new EhcacheManager(configuration);
    }

    T newCacheManager(Collection<Service> services, Configuration configuration) {
        EhcacheManager ehcacheManager = new EhcacheManager(configuration, services);
        return this.cast(ehcacheManager);
    }

    T cast(EhcacheManager ehcacheManager) {
        return (T)ehcacheManager;
    }

    public <K, V> CacheManagerBuilder<T> withCache(String alias, CacheConfiguration<K, V> configuration) {
        return new CacheManagerBuilder<T>(this, (FluentConfigurationBuilder<?>)this.configBuilder.withCache(alias, configuration));
    }

    public <K, V> CacheManagerBuilder<T> withCache(String alias, Builder<? extends CacheConfiguration<K, V>> configurationBuilder) {
        return this.withCache(alias, configurationBuilder.build());
    }

    public <N extends T> CacheManagerBuilder<N> with(CacheManagerConfiguration<N> cfg) {
        return cfg.builder(this);
    }

    public <N extends T> CacheManagerBuilder<N> with(Builder<? extends CacheManagerConfiguration<N>> cfgBuilder) {
        return this.with(cfgBuilder.build());
    }

    public CacheManagerBuilder<T> using(Service service) {
        HashSet<Service> newServices = new HashSet<Service>(this.services);
        newServices.add(service);
        return new CacheManagerBuilder<T>(this, newServices);
    }

    public <C> CacheManagerBuilder<T> withCopier(Class<C> clazz, Class<? extends Copier<C>> copier) {
        return this.ensureThenUpdate(DefaultCopyProviderConfiguration::new, existing -> existing.addCopierFor(clazz, copier, true));
    }

    public <C> CacheManagerBuilder<T> withSerializer(Class<C> clazz, Class<? extends Serializer<C>> serializer) {
        return this.ensureThenUpdate(DefaultSerializationProviderConfiguration::new, config -> config.addSerializerFor(clazz, serializer, true));
    }

    @Deprecated
    public CacheManagerBuilder<T> withDefaultSizeOfMaxObjectGraph(long size) {
        return this.ensureThenUpdate(() -> new DefaultSizeOfEngineProviderConfiguration(Long.MAX_VALUE, DefaultSizeOfEngineConfiguration.DEFAULT_UNIT, 1000L), existing -> new DefaultSizeOfEngineProviderConfiguration(existing.getMaxObjectSize(), existing.getUnit(), size));
    }

    @Deprecated
    public CacheManagerBuilder<T> withDefaultSizeOfMaxObjectSize(long size, MemoryUnit unit) {
        return this.ensureThenUpdate(() -> new DefaultSizeOfEngineProviderConfiguration(Long.MAX_VALUE, DefaultSizeOfEngineConfiguration.DEFAULT_UNIT, 1000L), existing -> new DefaultSizeOfEngineProviderConfiguration(size, unit, existing.getMaxObjectGraphSize()));
    }

    public CacheManagerBuilder<T> withDefaultWriteBehindThreadPool(String threadPoolAlias) {
        return this.using(new WriteBehindProviderConfiguration(threadPoolAlias));
    }

    public CacheManagerBuilder<T> withDefaultDiskStoreThreadPool(String threadPoolAlias) {
        return this.using(new OffHeapDiskStoreProviderConfiguration(threadPoolAlias));
    }

    public CacheManagerBuilder<T> withDefaultEventListenersThreadPool(String threadPoolAlias) {
        return this.using(new CacheEventDispatcherFactoryConfiguration(threadPoolAlias));
    }

    public CacheManagerBuilder<T> using(ServiceCreationConfiguration<?, ?> serviceConfiguration) {
        return new CacheManagerBuilder<T>(this, (FluentConfigurationBuilder<?>)this.configBuilder.withService(serviceConfiguration));
    }

    @Deprecated
    public CacheManagerBuilder<T> replacing(ServiceCreationConfiguration<?, ?> overwriteServiceConfiguration) {
        return this.using(overwriteServiceConfiguration);
    }

    public CacheManagerBuilder<T> withClassLoader(ClassLoader classLoader) {
        return new CacheManagerBuilder<T>(this, (FluentConfigurationBuilder<?>)this.configBuilder.withClassLoader(classLoader));
    }

    private <R, C extends ServiceCreationConfiguration<?, R>> CacheManagerBuilder<T> ensureThenUpdate(Supplier<C> supplier, UnaryOperator<R> update) {
        ServiceCreationConfiguration emptyConfig = (ServiceCreationConfiguration)supplier.get();
        Class<?> configType = emptyConfig.getClass();
        FluentConfigurationBuilder<?> fluentBuilder = this.configBuilder;
        if (this.configBuilder.getService(configType) == null) {
            fluentBuilder = fluentBuilder.withService(emptyConfig);
        }
        return new CacheManagerBuilder<T>(this, (FluentConfigurationBuilder<?>)fluentBuilder.updateServices(configType, update));
    }

    public static CacheManagerBuilder<CacheManager> newCacheManagerBuilder() {
        return new CacheManagerBuilder<CacheManager>();
    }

    public static CacheManagerConfiguration<PersistentCacheManager> persistence(String rootDirectory) {
        return CacheManagerBuilder.persistence(new File(rootDirectory));
    }

    public static CacheManagerConfiguration<PersistentCacheManager> persistence(File rootDirectory) {
        return new CacheManagerPersistenceConfiguration(rootDirectory);
    }

    public CacheManagerBuilder<T> sharedResources(Builder<? extends ResourcePools> sharedResourcePoolsBuilder) {
        ResourcePools pools = sharedResourcePoolsBuilder.build();
        return new CacheManagerBuilder<T>(this, (FluentConfigurationBuilder<?>)this.configBuilder.withSharedResources(pools).withService(new SharedStorageConfiguration(pools)));
    }
}

