/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ES6Iterator;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Symbol;
import org.mozilla.javascript.SymbolKey;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.lc.type.TypeInfo;
import org.mozilla.javascript.lc.type.TypeInfoFactory;

public class NativeJavaMap
extends NativeJavaObject {
    private static final long serialVersionUID = -3786257752907047381L;
    private final Map<Object, Object> map;
    private final TypeInfo keyType;
    private final TypeInfo valueType;
    private static Callable symbol_iterator = (cx, scope, thisObj, args) -> {
        if (!(thisObj instanceof NativeJavaMap)) {
            throw ScriptRuntime.typeErrorById("msg.incompat.call", SymbolKey.ITERATOR);
        }
        return new NativeJavaMapIterator(scope, (NativeJavaMap)thisObj);
    };

    static void init(ScriptableObject scope, boolean sealed) {
        NativeJavaMapIterator.init(scope, sealed);
    }

    public NativeJavaMap(Scriptable scope, Object map, TypeInfo staticType) {
        super(scope, map, staticType);
        assert (map instanceof Map);
        this.map = (Map)map;
        TypeInfoFactory typeFactory = TypeInfoFactory.getOrElse(scope, TypeInfoFactory.GLOBAL);
        this.keyType = typeFactory.consolidateType(MapTypeVariables.K, staticType);
        this.valueType = typeFactory.consolidateType(MapTypeVariables.V, staticType);
    }

    @Override
    public String getClassName() {
        return "JavaMap";
    }

    @Override
    public boolean has(String name, Scriptable start) {
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.hasFeature(21) && this.map.containsKey(name)) {
            return true;
        }
        return super.has(name, start);
    }

    @Override
    public boolean has(int index, Scriptable start) {
        Integer key;
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.hasFeature(21) && this.map.containsKey(key = Integer.valueOf(index))) {
            return true;
        }
        return super.has(index, start);
    }

    @Override
    public boolean has(Symbol key, Scriptable start) {
        return SymbolKey.ITERATOR.equals(key);
    }

    @Override
    public Object get(String name, Scriptable start) {
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.hasFeature(21) && this.map.containsKey(name)) {
            return cx.getWrapFactory().wrap(cx, (Scriptable)this, this.map.get(name), this.valueType);
        }
        return super.get(name, start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        Integer key;
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.hasFeature(21) && this.map.containsKey(key = Integer.valueOf(index))) {
            return cx.getWrapFactory().wrap(cx, (Scriptable)this, this.map.get(key), this.valueType);
        }
        return super.get(index, start);
    }

    @Override
    public Object get(Symbol key, Scriptable start) {
        if (SymbolKey.ITERATOR.equals(key)) {
            return symbol_iterator;
        }
        return super.get(key, start);
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.hasFeature(21)) {
            this.map.put(name, Context.jsToJava(value, this.valueType));
        } else {
            super.put(name, start, value);
        }
    }

    @Override
    public void put(int index, Scriptable start, Object value) {
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.hasFeature(21)) {
            this.map.put(index, Context.jsToJava(value, this.valueType));
        } else {
            super.put(index, start, value);
        }
    }

    @Override
    public Object[] getIds() {
        Context cx = Context.getCurrentContext();
        if (cx != null && cx.hasFeature(21)) {
            ArrayList<Object> ids = new ArrayList<Object>(this.map.size());
            for (Object key : this.map.keySet()) {
                if (key instanceof Integer) {
                    ids.add(key);
                    continue;
                }
                ids.add(ScriptRuntime.toString(key));
            }
            return ids.toArray();
        }
        return super.getIds();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    private static final class NativeJavaMapIterator
    extends ES6Iterator {
        private static final long serialVersionUID = 1L;
        private static final String ITERATOR_TAG = "JavaMapIterator";
        private Iterator<Map.Entry<Object, Object>> iterator;
        private TypeInfo keyType;
        private TypeInfo valueType;

        static void init(ScriptableObject scope, boolean sealed) {
            ES6Iterator.init(scope, sealed, new NativeJavaMapIterator(), ITERATOR_TAG);
        }

        private NativeJavaMapIterator() {
        }

        NativeJavaMapIterator(Scriptable scope, NativeJavaMap map) {
            super(scope, ITERATOR_TAG);
            this.iterator = map.map.entrySet().iterator();
            this.keyType = map.keyType;
            this.valueType = map.valueType;
        }

        @Override
        public String getClassName() {
            return "Java Map Iterator";
        }

        @Override
        protected boolean isDone(Context cx, Scriptable scope) {
            return !this.iterator.hasNext();
        }

        @Override
        protected Object nextValue(Context cx, Scriptable scope) {
            if (!this.iterator.hasNext()) {
                return cx.newArray(scope, new Object[]{Undefined.instance, Undefined.instance});
            }
            Map.Entry<Object, Object> e = this.iterator.next();
            Object key = e.getKey();
            Object value = e.getValue();
            WrapFactory wrapFactory = cx.getWrapFactory();
            key = wrapFactory.wrap(cx, (Scriptable)this, key, this.keyType);
            value = wrapFactory.wrap(cx, (Scriptable)this, value, this.valueType);
            return cx.newArray(scope, new Object[]{key, value});
        }

        @Override
        protected String getTag() {
            return ITERATOR_TAG;
        }
    }

    private static interface MapTypeVariables {
        public static final TypeInfo K = TypeInfoFactory.GLOBAL.create(Map.class.getTypeParameters()[0]);
        public static final TypeInfo V = TypeInfoFactory.GLOBAL.create(Map.class.getTypeParameters()[1]);
    }
}

