/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.unparsers.runtime1;

import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import org.apache.daffodil.io.DirectOrBufferedDataOutputStream;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.unparsers.UState;
import org.apache.daffodil.unparsers.runtime1.StringSpecifiedLengthUnparserBase;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public class StringNoTruncateUnparser
extends StringSpecifiedLengthUnparserBase {
    public StringNoTruncateUnparser(ElementRuntimeData erd) {
        super(erd);
    }

    private ElementRuntimeData erd$accessor() {
        return super.erd();
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    @Override
    public void unparse(UState state) {
        long l;
        DirectOrBufferedDataOutputStream dos = state.getDataOutputStream();
        String valueToWrite = this.contentString(state);
        try {
            l = dos.putString(valueToWrite, state);
        }
        catch (MalformedInputException m) {
            throw this.UE(state, "%s - MalformedInputException: \n%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.nom(), m.getMessage()}));
        }
        catch (UnmappableCharacterException u) {
            throw this.UE(state, "%s - UnmappableCharacterException: \n%s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{this.nom(), u.getMessage()}));
        }
        long nCharsWritten = l;
        if (nCharsWritten != (long)valueToWrite.length()) {
            throw Assert$.MODULE$.abort("Invariant broken: nCharsWritten.==(valueToWrite.length())");
        }
    }
}

