/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.actionstate;

import java.util.ArrayList;
import java.util.List;
import org.apache.flink.agents.api.Event;
import org.apache.flink.agents.api.context.MemoryUpdate;

public class ActionState {
    private final Event taskEvent;
    private final List<MemoryUpdate> memoryUpdates;
    private final List<Event> outputEvents;

    public ActionState(Event taskEvent) {
        this.taskEvent = taskEvent;
        this.memoryUpdates = new ArrayList<MemoryUpdate>();
        this.outputEvents = new ArrayList<Event>();
    }

    public ActionState() {
        this.taskEvent = null;
        this.memoryUpdates = new ArrayList<MemoryUpdate>();
        this.outputEvents = new ArrayList<Event>();
    }

    public ActionState(Event taskEvent, List<MemoryUpdate> memoryUpdates, List<Event> outputEvents) {
        this.taskEvent = taskEvent;
        this.memoryUpdates = memoryUpdates != null ? memoryUpdates : new ArrayList();
        this.outputEvents = outputEvents != null ? outputEvents : new ArrayList();
    }

    public Event getTaskEvent() {
        return this.taskEvent;
    }

    public List<MemoryUpdate> getMemoryUpdates() {
        return this.memoryUpdates;
    }

    public List<Event> getOutputEvents() {
        return this.outputEvents;
    }

    public void addMemoryUpdate(MemoryUpdate memoryUpdate) {
        this.memoryUpdates.add(memoryUpdate);
    }

    public void addEvent(Event event) {
        this.outputEvents.add(event);
    }

    public int hashCode() {
        int result = this.taskEvent != null ? this.taskEvent.hashCode() : 0;
        result = 31 * result + (this.memoryUpdates != null ? this.memoryUpdates.hashCode() : 0);
        result = 31 * result + (this.outputEvents != null ? this.outputEvents.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TaskActionState{taskEvent=" + String.valueOf(this.taskEvent) + ", memoryUpdates=" + String.valueOf(this.memoryUpdates) + ", outputEvents=" + String.valueOf(this.outputEvents) + "}";
    }
}

