/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.metrics.stats;

import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;

public abstract class SampledStat
implements MeasurableStat {
    private final double initialValue;
    private int current = 0;
    protected List<Sample> samples;

    public SampledStat(double initialValue) {
        this.initialValue = initialValue;
        this.samples = new ArrayList<Sample>(3);
    }

    @Override
    public void record(MetricConfig config, double value, long timeMs) {
        Sample sample = this.current(timeMs);
        if (sample.isComplete(timeMs, config)) {
            sample = this.advance(config, timeMs);
        }
        this.update(sample, config, value, timeMs);
        ++sample.eventCount;
        sample.lastEventMs = timeMs;
    }

    private Sample advance(MetricConfig config, long timeMs) {
        int maxSamples = config.samples() + 1;
        this.current = (this.current + 1) % maxSamples;
        if (this.current >= this.samples.size()) {
            Sample sample = this.newSample(timeMs);
            this.samples.add(sample);
            return sample;
        }
        Sample sample = this.current(timeMs);
        sample.reset(timeMs);
        return sample;
    }

    protected Sample newSample(long timeMs) {
        return new Sample(this.initialValue, timeMs);
    }

    @Override
    public double measure(MetricConfig config, long now) {
        this.purgeObsoleteSamples(config, now);
        return this.combine(this.samples, config, now);
    }

    public Sample current(long timeMs) {
        if (this.samples.isEmpty()) {
            this.samples.add(this.newSample(timeMs));
        }
        return this.samples.get(this.current);
    }

    public Sample oldest(long now) {
        if (this.samples.isEmpty()) {
            this.samples.add(this.newSample(now));
        }
        Sample oldest = this.samples.get(0);
        for (int i = 1; i < this.samples.size(); ++i) {
            Sample curr = this.samples.get(i);
            if (curr.startTimeMs >= oldest.startTimeMs) continue;
            oldest = curr;
        }
        return oldest;
    }

    public String toString() {
        return "SampledStat(initialValue=" + this.initialValue + ", current=" + this.current + ", samples=" + String.valueOf(this.samples) + ")";
    }

    protected abstract void update(Sample var1, MetricConfig var2, double var3, long var5);

    public abstract double combine(List<Sample> var1, MetricConfig var2, long var3);

    protected void purgeObsoleteSamples(MetricConfig config, long now) {
        long expireAge = (long)config.samples() * config.timeWindowMs();
        for (Sample sample : this.samples) {
            if (now - sample.lastEventMs < expireAge) continue;
            sample.reset(now);
        }
    }

    protected static class Sample {
        public double initialValue;
        public long eventCount;
        public long startTimeMs;
        public long lastEventMs;
        public double value;

        public Sample(double initialValue, long now) {
            this.initialValue = initialValue;
            this.eventCount = 0L;
            this.startTimeMs = now;
            this.lastEventMs = now;
            this.value = initialValue;
        }

        public void reset(long now) {
            this.eventCount = 0L;
            this.startTimeMs = now;
            this.lastEventMs = now;
            this.value = this.initialValue;
        }

        public boolean isComplete(long timeMs, MetricConfig config) {
            return timeMs - this.startTimeMs >= config.timeWindowMs() || this.eventCount >= config.eventWindow();
        }

        public String toString() {
            return "Sample(value=" + this.value + ", eventCount=" + this.eventCount + ", startTimeMs=" + this.startTimeMs + ", lastEventMs=" + this.lastEventMs + ", initialValue=" + this.initialValue + ")";
        }
    }
}

