/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.util.Locale;
import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.CookieRestrictionViolationException;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.core5.annotation.Contract;
import org.apache.hc.core5.annotation.ThreadingBehavior;
import org.apache.hc.core5.net.InetAddressUtils;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TextUtils;

@Contract(threading=ThreadingBehavior.STATELESS)
public class BasicDomainHandler
implements CommonCookieAttributeHandler {
    public static final BasicDomainHandler INSTANCE = new BasicDomainHandler();

    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        if (TextUtils.isBlank(value)) {
            throw new MalformedCookieException("Blank or null value for domain attribute");
        }
        if (value.endsWith(".")) {
            return;
        }
        String domain2 = value;
        if (domain2.startsWith(".")) {
            domain2 = domain2.substring(1);
        }
        domain2 = domain2.toLowerCase(Locale.ROOT);
        cookie.setDomain(domain2);
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost();
        String domain2 = cookie.getDomain();
        if (domain2 == null) {
            throw new CookieRestrictionViolationException("Cookie 'domain' may not be null");
        }
        if (!host.equals(domain2) && !BasicDomainHandler.domainMatch(domain2, host)) {
            throw new CookieRestrictionViolationException("Illegal 'domain' attribute \"" + domain2 + "\". Domain of origin: \"" + host + "\"");
        }
    }

    static boolean domainMatch(String domain2, String host) {
        String normalizedDomain;
        if (InetAddressUtils.isIPv4(host) || InetAddressUtils.isIPv6(host)) {
            return false;
        }
        String string = normalizedDomain = domain2.startsWith(".") ? domain2.substring(1) : domain2;
        if (host.endsWith(normalizedDomain)) {
            int prefix = host.length() - normalizedDomain.length();
            if (prefix == 0) {
                return true;
            }
            return prefix > 1 && host.charAt(prefix - 1) == '.';
        }
        return false;
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        String host = origin.getHost();
        String domain2 = cookie.getDomain();
        if (domain2 == null) {
            return false;
        }
        if (domain2.startsWith(".")) {
            domain2 = domain2.substring(1);
        }
        if (host.equals(domain2 = domain2.toLowerCase(Locale.ROOT))) {
            return true;
        }
        if (cookie.containsAttribute("domain")) {
            return BasicDomainHandler.domainMatch(domain2, host);
        }
        return false;
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

