/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.compiler;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.PackageNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.GroovyASTTransformation;
import org.grails.cli.compiler.SpringBootAstTransformation;
import org.grails.cli.groovy.DependencyManagementBom;
import org.springframework.core.Ordered;

@GroovyASTTransformation(phase=CompilePhase.CONVERSION)
public abstract class GenericBomAstTransformation
implements SpringBootAstTransformation,
Ordered {
    private static final ClassNode BOM = ClassHelper.make(DependencyManagementBom.class);

    @Override
    public void visit(ASTNode[] nodes, SourceUnit source) {
        for (ASTNode astNode : nodes) {
            if (!(astNode instanceof ModuleNode)) continue;
            this.visitModule((ModuleNode)astNode, this.getBomModule());
        }
    }

    protected abstract String getBomModule();

    private void visitModule(ModuleNode node, String module) {
        this.addDependencyManagementBom(node, module);
    }

    private void addDependencyManagementBom(ModuleNode node, String module) {
        AnnotatedNode annotated = this.getAnnotatedNode(node);
        if (annotated != null) {
            AnnotationNode bom = this.getAnnotation(annotated);
            ArrayList<Expression> expressions = new ArrayList<Expression>(this.getConstantExpressions(bom.getMember("value")));
            expressions.add(new ConstantExpression(module));
            bom.setMember("value", new ListExpression(expressions));
        }
    }

    private AnnotationNode getAnnotation(AnnotatedNode annotated) {
        List<AnnotationNode> annotations = annotated.getAnnotations(BOM);
        if (!annotations.isEmpty()) {
            return annotations.get(0);
        }
        AnnotationNode annotation = new AnnotationNode(BOM);
        annotated.addAnnotation(annotation);
        return annotation;
    }

    private AnnotatedNode getAnnotatedNode(ModuleNode node) {
        PackageNode packageNode = node.getPackage();
        if (packageNode != null && !packageNode.getAnnotations(BOM).isEmpty()) {
            return packageNode;
        }
        if (!node.getClasses().isEmpty()) {
            return node.getClasses().get(0);
        }
        return packageNode;
    }

    private List<ConstantExpression> getConstantExpressions(Expression valueExpression) {
        if (valueExpression instanceof ListExpression) {
            return this.getConstantExpressions((ListExpression)valueExpression);
        }
        if (valueExpression instanceof ConstantExpression && ((ConstantExpression)valueExpression).getValue() instanceof String) {
            return Arrays.asList((ConstantExpression)valueExpression);
        }
        return Collections.emptyList();
    }

    private List<ConstantExpression> getConstantExpressions(ListExpression valueExpression) {
        ArrayList<ConstantExpression> expressions = new ArrayList<ConstantExpression>();
        for (Expression expression : valueExpression.getExpressions()) {
            if (!(expression instanceof ConstantExpression) || !(((ConstantExpression)expression).getValue() instanceof String)) continue;
            expressions.add((ConstantExpression)expression);
        }
        return expressions;
    }
}

