/*
 * Decompiled with CFR 0.152.
 */
package org.grails.plugins;

import grails.core.GrailsApplication;
import grails.plugins.DefaultGrailsPluginManager;
import grails.plugins.GrailsPlugin;
import grails.plugins.exceptions.PluginException;
import groovy.lang.GroovySystem;
import groovy.lang.MetaClassRegistry;
import org.grails.core.exceptions.GrailsConfigurationException;
import org.grails.spring.RuntimeSpringConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class ProfilingGrailsPluginManager
extends DefaultGrailsPluginManager {
    public ProfilingGrailsPluginManager(GrailsApplication application2) {
        super(application2);
    }

    public ProfilingGrailsPluginManager(Class<?>[] plugins, GrailsApplication application2) {
        super(plugins, application2);
    }

    public ProfilingGrailsPluginManager(Resource[] pluginFiles, GrailsApplication application2) {
        super(pluginFiles, application2);
    }

    public ProfilingGrailsPluginManager(String resourcePath, GrailsApplication application2) {
        super(resourcePath, application2);
    }

    public ProfilingGrailsPluginManager(String[] pluginResources, GrailsApplication application2) {
        super(pluginResources, application2);
    }

    @Override
    public void loadPlugins() throws PluginException {
        long time = System.currentTimeMillis();
        System.out.println("Loading plugins started");
        super.loadPlugins();
        System.out.println("Loading plugins took " + (System.currentTimeMillis() - time));
    }

    @Override
    public void doDynamicMethods() {
        long time = System.currentTimeMillis();
        System.out.println("doWithDynamicMethods started");
        this.checkInitialised();
        MetaClassRegistry registry = GroovySystem.getMetaClassRegistry();
        for (Class COMMON_CLASS : COMMON_CLASSES) {
            registry.removeMetaClass(COMMON_CLASS);
        }
        for (GrailsPlugin plugin2 : this.pluginList) {
            if (!plugin2.supportsCurrentScopeAndEnvironment()) continue;
            try {
                long pluginTime = System.currentTimeMillis();
                System.out.println("doWithDynamicMethods for plugin [" + plugin2.getName() + "] started");
                plugin2.doWithDynamicMethods(this.applicationContext);
                System.out.println("doWithDynamicMethods for plugin [" + plugin2.getName() + "] took " + (System.currentTimeMillis() - pluginTime));
            }
            catch (Throwable t) {
                throw new GrailsConfigurationException("Error configuring dynamic methods for plugin " + String.valueOf(plugin2) + ": " + t.getMessage(), t);
            }
        }
        System.out.println("doWithDynamicMethods took " + (System.currentTimeMillis() - time));
    }

    @Override
    public void doRuntimeConfiguration(RuntimeSpringConfiguration springConfig) {
        long time = System.currentTimeMillis();
        System.out.println("doWithSpring started");
        this.checkInitialised();
        for (GrailsPlugin plugin2 : this.pluginList) {
            if (!plugin2.supportsCurrentScopeAndEnvironment()) continue;
            long pluginTime = System.currentTimeMillis();
            System.out.println("doWithSpring for plugin [" + plugin2.getName() + "] started");
            plugin2.doWithRuntimeConfiguration(springConfig);
            System.out.println("doWithSpring for plugin [" + plugin2.getName() + "] took " + (System.currentTimeMillis() - pluginTime));
        }
        System.out.println("doWithSpring took " + (System.currentTimeMillis() - time));
    }

    @Override
    public void doPostProcessing(ApplicationContext ctx) {
        long time = System.currentTimeMillis();
        System.out.println("doWithApplicationContext started");
        this.checkInitialised();
        for (GrailsPlugin plugin2 : this.pluginList) {
            if (!plugin2.supportsCurrentScopeAndEnvironment()) continue;
            long pluginTime = System.currentTimeMillis();
            System.out.println("doWithApplicationContext for plugin [" + plugin2.getName() + "] started");
            plugin2.doWithApplicationContext(ctx);
            System.out.println("doWithApplicationContext for plugin [" + plugin2.getName() + "] took " + (System.currentTimeMillis() - pluginTime));
        }
        System.out.println("doWithApplicationContext took " + (System.currentTimeMillis() - time));
    }

    @Override
    public void doArtefactConfiguration() {
        long time = System.currentTimeMillis();
        System.out.println("doArtefactConfiguration started");
        super.doArtefactConfiguration();
        System.out.println("doArtefactConfiguration took " + (System.currentTimeMillis() - time));
    }
}

