/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.convert;

import java.time.Period;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.Set;
import org.springframework.boot.convert.PeriodFormat;
import org.springframework.boot.convert.PeriodStyle;
import org.springframework.boot.convert.PeriodUnit;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.util.ObjectUtils;

final class PeriodToStringConverter
implements GenericConverter {
    PeriodToStringConverter() {
    }

    @Override
    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Collections.singleton(new GenericConverter.ConvertiblePair(Period.class, String.class));
    }

    @Override
    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        if (ObjectUtils.isEmpty(source)) {
            return null;
        }
        return this.convert((Period)source, this.getPeriodStyle(sourceType), this.getPeriodUnit(sourceType));
    }

    private PeriodStyle getPeriodStyle(TypeDescriptor sourceType) {
        PeriodFormat annotation = sourceType.getAnnotation(PeriodFormat.class);
        return annotation != null ? annotation.value() : null;
    }

    private String convert(Period source, PeriodStyle style, ChronoUnit unit) {
        style = style != null ? style : PeriodStyle.ISO8601;
        return style.print(source, unit);
    }

    private ChronoUnit getPeriodUnit(TypeDescriptor sourceType) {
        PeriodUnit annotation = sourceType.getAnnotation(PeriodUnit.class);
        return annotation != null ? annotation.value() : null;
    }
}

