/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.asn1.ber;

import java.nio.ByteBuffer;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.TLVBerDecoderMBean;
import org.apache.directory.api.asn1.ber.tlv.TLVStateEnum;
import org.apache.directory.api.asn1.util.Asn1StringUtils;
import org.apache.directory.api.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Asn1Decoder
implements TLVBerDecoderMBean {
    private static final Logger LOG = LoggerFactory.getLogger(Asn1Decoder.class);
    private static final boolean MORE = true;
    private static final boolean END = false;
    private boolean indefiniteLengthAllowed = false;
    private int maxLengthLength = 1;
    private int maxTagLength = 1;

    private Asn1Decoder() {
    }

    private static boolean treatTagStartState(ByteBuffer stream, Asn1Container container) {
        if (stream.hasRemaining()) {
            byte octet = stream.get();
            TLV tlv = new TLV(container.getNewTlvId());
            tlv.setTag(octet);
            container.setCurrentTLV(tlv);
            tlv.setParent(container.getParentTLV());
            container.setState(TLVStateEnum.LENGTH_STATE_START);
            if (LOG.isDebugEnabled()) {
                byte tag = container.getCurrentTLV().getTag();
                LOG.debug(I18n.msg((I18n)I18n.MSG_01000_TAG_DECODED, (Object[])new Object[]{Asn1StringUtils.dumpByte((byte)tag)}));
            }
            return true;
        }
        return false;
    }

    private static void dumpTLVTree(Asn1Container container) {
        StringBuilder sb = new StringBuilder();
        TLV current = container.getCurrentTLV();
        sb.append("TLV").append(Asn1StringUtils.dumpByte((byte)current.getTag())).append("(").append(current.getExpectedLength()).append(")");
        for (current = current.getParent(); current != null; current = current.getParent()) {
            sb.append("-TLV").append(Asn1StringUtils.dumpByte((byte)current.getTag())).append("(").append(current.getExpectedLength()).append(")");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_01001_TLV_TREE, (Object[])new Object[]{sb.toString()}));
        }
    }

    private static boolean isTLVDecoded(Asn1Container container) {
        TLV current = container.getCurrentTLV();
        for (TLV parent = current.getParent(); parent != null; parent = parent.getParent()) {
            if (parent.getExpectedLength() == 0) continue;
            return false;
        }
        BerValue value = current.getValue();
        if (value != null && value.getData() != null) {
            return current.getExpectedLength() == value.getData().length;
        }
        return current.getExpectedLength() == 0;
    }

    private static boolean treatLengthStartState(ByteBuffer stream, Asn1Container container) throws DecoderException {
        if (stream.hasRemaining()) {
            byte octet = stream.get();
            TLV tlv = container.getCurrentTLV();
            if ((octet & 0x80) == 0) {
                tlv.setLength(octet);
                tlv.setLengthNbBytes(1);
                container.setState(TLVStateEnum.LENGTH_STATE_END);
            } else if ((octet & 0x7F) != 127) {
                int expectedLength = octet & 0x7F;
                if (expectedLength > 4) {
                    String msg = I18n.err((I18n)I18n.ERR_01000_LENGTH_OVERFLOW, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                tlv.setLength(0);
                tlv.setLengthNbBytes(1 + expectedLength);
                tlv.setLengthBytesRead(1);
                container.setState(TLVStateEnum.LENGTH_STATE_PENDING);
            } else {
                String msg = I18n.err((I18n)I18n.ERR_01001_LENGTH_EXTENSION_RESERVED, (Object[])new Object[0]);
                LOG.error(msg);
                throw new DecoderException(msg);
            }
            return true;
        }
        return false;
    }

    private static boolean treatLengthPendingState(ByteBuffer stream, Asn1Container container) throws DecoderException {
        if (stream.hasRemaining()) {
            TLV tlv = container.getCurrentTLV();
            int length = tlv.getLength();
            while (tlv.getLengthBytesRead() < tlv.getLengthNbBytes()) {
                byte octet = stream.get();
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_01002_CURRENT_BYTE, (Object[])new Object[]{Asn1StringUtils.dumpByte((byte)octet)}));
                }
                tlv.incLengthBytesRead();
                length = length << 8 | octet & 0xFF;
                if (length < 0) {
                    String msg = I18n.err((I18n)I18n.ERR_01002_TLV_NULL, (Object[])new Object[0]);
                    LOG.error(msg);
                    throw new DecoderException(msg);
                }
                if (stream.hasRemaining()) continue;
                tlv.setLength(length);
                if (tlv.getLengthBytesRead() < tlv.getLengthNbBytes()) {
                    container.setState(TLVStateEnum.LENGTH_STATE_PENDING);
                    return false;
                }
                container.setState(TLVStateEnum.LENGTH_STATE_END);
                return true;
            }
            tlv.setLength(length);
            container.setState(TLVStateEnum.LENGTH_STATE_END);
            return true;
        }
        return false;
    }

    private static String getParentLength(TLV tlv) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("TLV expected length stack : ");
        TLV currentTlv = tlv;
        while (true) {
            if (currentTlv == null) break;
            buffer.append(" - ").append(currentTlv.getExpectedLength());
            currentTlv = currentTlv.getParent();
        }
        buffer.append(" - null");
        return buffer.toString();
    }

    private static void treatLengthEndState(Asn1Container container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        if (tlv == null) {
            String msg = I18n.err((I18n)I18n.ERR_01002_TLV_NULL, (Object[])new Object[0]);
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        int length = tlv.getLength();
        if (length > container.getMaxPDUSize()) {
            throw new DecoderException(I18n.err((I18n)I18n.ERR_01007_PDU_SIZE_TOO_LONG, (Object[])new Object[]{length, container.getMaxPDUSize()}));
        }
        TLV parentTLV = container.getParentTLV();
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_01003_PARENT_LENGTH, (Object[])new Object[]{Asn1Decoder.getParentLength(parentTLV)}));
        }
        if (parentTLV == null) {
            tlv.setExpectedLength(length);
            container.setParentTLV(tlv);
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_01004_ROOT_TLV, (Object[])new Object[]{length}));
            }
        } else {
            int currentLength;
            int expectedLength = parentTLV.getExpectedLength();
            if (expectedLength < (currentLength = tlv.getSize())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_01005_TLV, (Object[])new Object[]{expectedLength, currentLength}));
                }
                throw new DecoderException(I18n.err((I18n)I18n.ERR_01003_VALUE_LENGTH_ABOVE_EXPECTED_LENGTH, (Object[])new Object[]{currentLength, expectedLength}));
            }
            if (expectedLength == currentLength) {
                parentTLV.setExpectedLength(0);
                if (tlv.isConstructed()) {
                    if (length == 0) {
                        while (parentTLV != null && parentTLV.getExpectedLength() == 0) {
                            parentTLV = parentTLV.getParent();
                        }
                        container.setParentTLV(parentTLV);
                    } else {
                        container.setParentTLV(tlv);
                    }
                    tlv.setParent(parentTLV);
                    tlv.setExpectedLength(length);
                } else {
                    tlv.setExpectedLength(length);
                    while (parentTLV != null && parentTLV.getExpectedLength() == 0) {
                        parentTLV = parentTLV.getParent();
                    }
                    container.setParentTLV(parentTLV);
                }
            } else {
                parentTLV.setExpectedLength(expectedLength - currentLength);
                tlv.setExpectedLength(length);
                if (tlv.isConstructed()) {
                    tlv.setParent(parentTLV);
                    container.setParentTLV(tlv);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_01006_LENGTH_DECODED, (Object[])new Object[]{length}));
        }
        if (length == 0) {
            container.setState(TLVStateEnum.TLV_STATE_DONE);
        } else {
            container.setState(TLVStateEnum.VALUE_STATE_START);
        }
    }

    private static boolean treatValueStartState(ByteBuffer stream, Asn1Container container) {
        TLV currentTlv = container.getCurrentTLV();
        if (TLV.isConstructed(currentTlv.getTag()) && !container.isGathering()) {
            container.setState(TLVStateEnum.TLV_STATE_DONE);
            return true;
        }
        int length = currentTlv.getLength();
        int nbBytes = stream.remaining();
        if (nbBytes < length) {
            currentTlv.getValue().init(length);
            currentTlv.getValue().setData(stream);
            container.setState(TLVStateEnum.VALUE_STATE_PENDING);
            return false;
        }
        currentTlv.getValue().init(length);
        stream.get(currentTlv.getValue().getData(), 0, length);
        container.setState(TLVStateEnum.TLV_STATE_DONE);
        return true;
    }

    private static boolean treatValuePendingState(ByteBuffer stream, Asn1Container container) {
        int nbBytes;
        TLV currentTlv = container.getCurrentTLV();
        int length = currentTlv.getLength();
        int currentLength = currentTlv.getValue().getCurrentLength();
        if (currentLength + (nbBytes = stream.remaining()) < length) {
            currentTlv.getValue().addData(stream);
            container.setState(TLVStateEnum.VALUE_STATE_PENDING);
            return false;
        }
        int remaining = length - currentLength;
        byte[] data = new byte[remaining];
        stream.get(data, 0, remaining);
        currentTlv.getValue().addData(data);
        container.setState(TLVStateEnum.TLV_STATE_DONE);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static boolean treatTLVDoneState(ByteBuffer stream, Asn1Container container) throws DecoderException {
        if (LOG.isDebugEnabled()) {
            Asn1Decoder.dumpTLVTree(container);
        }
        container.getGrammar().executeAction(container);
        if (!Asn1Decoder.isTLVDecoded(container)) {
            container.setState(TLVStateEnum.TAG_STATE_START);
            return stream.hasRemaining();
        }
        if (container.getState() == TLVStateEnum.GRAMMAR_END) {
            container.setState(TLVStateEnum.PDU_DECODED);
            return stream.hasRemaining();
        }
        if (container.isGrammarEndAllowed()) {
            container.setState(TLVStateEnum.PDU_DECODED);
            return stream.hasRemaining();
        }
        LOG.error(I18n.err((I18n)I18n.ERR_01004_MORE_TLV_EXPECTED, (Object[])new Object[0]));
        throw new DecoderException(I18n.err((I18n)I18n.ERR_01005_TRUNCATED_PDU, (Object[])new Object[0]));
    }

    public static void decode(ByteBuffer stream, Asn1Container container) throws DecoderException {
        boolean hasRemaining = stream.hasRemaining();
        container.incrementDecodedBytes(stream.remaining());
        if (container.getDecodedBytes() > container.getMaxPDUSize()) {
            String message = I18n.err((I18n)I18n.ERR_01007_PDU_SIZE_TOO_LONG, (Object[])new Object[]{container.getDecodedBytes(), container.getMaxPDUSize()});
            LOG.error(message);
            throw new DecoderException(message);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_01007_LINE_SEPARATOR1, (Object[])new Object[0]));
            LOG.debug(I18n.msg((I18n)I18n.MSG_01011_DECODING_PDU, (Object[])new Object[0]));
            LOG.debug(I18n.msg((I18n)I18n.MSG_01008_LINE_SEPARATOR2, (Object[])new Object[0]));
        }
        block11: while (hasRemaining) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_01012_STATE, (Object[])new Object[]{container.getState()}));
                if (stream.hasRemaining()) {
                    byte octet = stream.get(stream.position());
                    LOG.debug(I18n.msg((I18n)I18n.MSG_01013_CURRENT_BYTE, (Object[])new Object[]{Asn1StringUtils.dumpByte((byte)octet)}));
                } else {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_01014_NO_MORE_BYTE, (Object[])new Object[0]));
                }
            }
            switch (container.getState()) {
                case TAG_STATE_START: {
                    container.setGrammarEndAllowed(false);
                    hasRemaining = Asn1Decoder.treatTagStartState(stream, container);
                    continue block11;
                }
                case LENGTH_STATE_START: {
                    hasRemaining = Asn1Decoder.treatLengthStartState(stream, container);
                    continue block11;
                }
                case LENGTH_STATE_PENDING: {
                    hasRemaining = Asn1Decoder.treatLengthPendingState(stream, container);
                    continue block11;
                }
                case LENGTH_STATE_END: {
                    Asn1Decoder.treatLengthEndState(container);
                    continue block11;
                }
                case VALUE_STATE_START: {
                    hasRemaining = Asn1Decoder.treatValueStartState(stream, container);
                    continue block11;
                }
                case VALUE_STATE_PENDING: {
                    hasRemaining = Asn1Decoder.treatValuePendingState(stream, container);
                    continue block11;
                }
                case VALUE_STATE_END: {
                    hasRemaining = stream.hasRemaining();
                    continue block11;
                }
                case TLV_STATE_DONE: {
                    hasRemaining = Asn1Decoder.treatTLVDoneState(stream, container);
                    continue block11;
                }
                case PDU_DECODED: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug(I18n.err((I18n)I18n.ERR_01008_REMAINING_BYTES_FOR_DECODED_PDU, (Object[])new Object[0]));
                    }
                    hasRemaining = false;
                    continue block11;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_01009_LINE_SEPARATOR3, (Object[])new Object[0]));
            if (container.getState() == TLVStateEnum.PDU_DECODED) {
                if (container.getCurrentTLV() != null) {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_01015_STOP_DECODING, (Object[])new Object[]{container.getCurrentTLV().toString()}));
                } else {
                    LOG.debug(I18n.msg((I18n)I18n.MSG_01016_STOP_DECODING_NULL_TLV, (Object[])new Object[0]));
                }
            } else if (container.getCurrentTLV() != null) {
                LOG.debug(I18n.msg((I18n)I18n.MSG_01017_END_DECODING, (Object[])new Object[]{container.getCurrentTLV().toString()}));
            } else {
                LOG.debug(I18n.msg((I18n)I18n.MSG_01018_END_DECODING_NULL_TLV, (Object[])new Object[0]));
            }
            LOG.debug(I18n.msg((I18n)I18n.MSG_01010_LINE_SEPARATOR4, (Object[])new Object[0]));
        }
    }

    @Override
    public int getMaxLengthLength() {
        return this.maxLengthLength;
    }

    @Override
    public int getMaxTagLength() {
        return this.maxTagLength;
    }

    @Override
    public boolean isIndefiniteLengthAllowed() {
        return this.indefiniteLengthAllowed;
    }
}

