/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.ConsistencyLevel;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.EmptyIterators;
import org.apache.cassandra.db.Keyspace;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.PartitionRangeReadQuery;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ColumnFilter;
import org.apache.cassandra.db.filter.DataLimits;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.lifecycle.View;
import org.apache.cassandra.db.memtable.Memtable;
import org.apache.cassandra.db.partitions.CachedPartition;
import org.apache.cassandra.db.partitions.PartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterators;
import org.apache.cassandra.db.rows.BaseRowIterator;
import org.apache.cassandra.db.transform.RTBoundValidator;
import org.apache.cassandra.db.transform.Transformation;
import org.apache.cassandra.db.virtual.VirtualKeyspaceRegistry;
import org.apache.cassandra.db.virtual.VirtualTable;
import org.apache.cassandra.dht.AbstractBounds;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.exceptions.RequestExecutionException;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.sstable.format.SSTableReadsListener;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.metrics.TableMetrics;
import org.apache.cassandra.net.Verb;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.schema.TableMetadata;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.service.StorageProxy;
import org.apache.cassandra.tracing.Tracing;
import org.apache.cassandra.transport.Dispatcher;

public class PartitionRangeReadCommand
extends ReadCommand
implements PartitionRangeReadQuery {
    protected static final ReadCommand.SelectionDeserializer selectionDeserializer = new Deserializer();
    protected final DataRange dataRange;

    @VisibleForTesting
    protected PartitionRangeReadCommand(boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange, IndexMetadata index, boolean trackWarnings) {
        super(ReadCommand.Kind.PARTITION_RANGE, isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, index, trackWarnings);
        this.dataRange = dataRange;
    }

    private static PartitionRangeReadCommand create(boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange, IndexMetadata index, boolean trackWarnings) {
        if (metadata.isVirtual()) {
            return new VirtualTablePartitionRangeReadCommand(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, dataRange, index, trackWarnings);
        }
        return new PartitionRangeReadCommand(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, dataRange, index, trackWarnings);
    }

    public static PartitionRangeReadCommand create(TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange) {
        return PartitionRangeReadCommand.create(false, 0, false, metadata, nowInSec, columnFilter, rowFilter, limits, dataRange, PartitionRangeReadCommand.findIndex(metadata, rowFilter), false);
    }

    public static PartitionRangeReadCommand allDataRead(TableMetadata metadata, int nowInSec) {
        return PartitionRangeReadCommand.create(false, 0, false, metadata, nowInSec, ColumnFilter.all(metadata), RowFilter.NONE, DataLimits.NONE, DataRange.allData(metadata.partitioner), null, false);
    }

    @Override
    public DataRange dataRange() {
        return this.dataRange;
    }

    @Override
    public ClusteringIndexFilter clusteringIndexFilter(DecoratedKey key) {
        return this.dataRange.clusteringIndexFilter(key);
    }

    public boolean isNamesQuery() {
        return this.dataRange.isNamesQuery();
    }

    public PartitionRangeReadCommand forSubRange(AbstractBounds<PartitionPosition> range, boolean isRangeContinuation) {
        return PartitionRangeReadCommand.create(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), isRangeContinuation ? this.limits() : this.limits().withoutState(), this.dataRange().forSubRange(range), this.indexMetadata(), this.isTrackingWarnings());
    }

    @Override
    public PartitionRangeReadCommand copy() {
        return PartitionRangeReadCommand.create(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange(), this.indexMetadata(), this.isTrackingWarnings());
    }

    @Override
    protected PartitionRangeReadCommand copyAsDigestQuery() {
        return PartitionRangeReadCommand.create(true, this.digestVersion(), false, this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange(), this.indexMetadata(), this.isTrackingWarnings());
    }

    @Override
    protected PartitionRangeReadCommand copyAsTransientQuery() {
        return PartitionRangeReadCommand.create(false, 0, true, this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange(), this.indexMetadata(), this.isTrackingWarnings());
    }

    @Override
    public PartitionRangeReadCommand withUpdatedLimit(DataLimits newLimits) {
        return PartitionRangeReadCommand.create(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), newLimits, this.dataRange(), this.indexMetadata(), this.isTrackingWarnings());
    }

    @Override
    public PartitionRangeReadCommand withUpdatedLimitsAndDataRange(DataLimits newLimits, DataRange newDataRange) {
        return PartitionRangeReadCommand.create(this.isDigestQuery(), this.digestVersion(), this.acceptsTransient(), this.metadata(), this.nowInSec(), this.columnFilter(), this.rowFilter(), newLimits, newDataRange, this.indexMetadata(), this.isTrackingWarnings());
    }

    @Override
    public long getTimeout(TimeUnit unit) {
        return DatabaseDescriptor.getRangeRpcTimeout(unit);
    }

    @Override
    public boolean isReversed() {
        return this.dataRange.isReversed();
    }

    @Override
    public PartitionIterator execute(ConsistencyLevel consistency, ClientState state, Dispatcher.RequestTime requestTime) throws RequestExecutionException {
        return StorageProxy.getRangeSlice(this, consistency, requestTime);
    }

    @Override
    protected void recordLatency(TableMetrics metric, long latencyNanos) {
        metric.rangeLatency.addNano(latencyNanos);
    }

    @Override
    @VisibleForTesting
    public UnfilteredPartitionIterator queryStorage(ColumnFamilyStore cfs, ReadExecutionController controller) {
        ColumnFamilyStore.ViewFragment view = cfs.select(View.selectLive(this.dataRange().keyRange()));
        Tracing.trace("Executing seq scan across {} sstables for {}", (Object)view.sstables.size(), (Object)this.dataRange().keyRange().getString(this.metadata().partitionKeyType));
        ReadCommand.InputCollector<UnfilteredPartitionIterator> inputCollector = this.iteratorsForRange(view, controller);
        try {
            UnfilteredPartitionIterator iter;
            SSTableReadsListener readCountUpdater = PartitionRangeReadCommand.newReadCountUpdater();
            for (Memtable memtable : view.memtables) {
                iter = memtable.partitionIterator(this.columnFilter(), this.dataRange(), readCountUpdater);
                controller.updateMinOldestUnrepairedTombstone(memtable.getMinLocalDeletionTime());
                inputCollector.addMemtableIterator(RTBoundValidator.validate(iter, RTBoundValidator.Stage.MEMTABLE, false));
            }
            for (SSTableReader sstable : view.sstables) {
                iter = sstable.partitionIterator(this.columnFilter(), this.dataRange(), readCountUpdater);
                inputCollector.addSSTableIterator(sstable, RTBoundValidator.validate(iter, RTBoundValidator.Stage.SSTABLE, false));
                if (sstable.isRepaired()) continue;
                controller.updateMinOldestUnrepairedTombstone(sstable.getMinLocalDeletionTime());
            }
            if (inputCollector.isEmpty()) {
                return EmptyIterators.unfilteredPartition(this.metadata());
            }
            return this.checkCacheFilter(UnfilteredPartitionIterators.mergeLazily(inputCollector.finalizeIterators(cfs, this.nowInSec(), controller.oldestUnrepairedTombstone())), cfs);
        }
        catch (Error | RuntimeException e) {
            try {
                inputCollector.close();
            }
            catch (Exception e1) {
                e.addSuppressed(e1);
            }
            throw e;
        }
    }

    private static SSTableReadsListener newReadCountUpdater() {
        return new SSTableReadsListener(){

            @Override
            public void onScanningStarted(SSTableReader sstable) {
                sstable.incrementReadCount();
            }
        };
    }

    private UnfilteredPartitionIterator checkCacheFilter(UnfilteredPartitionIterator iter, final ColumnFamilyStore cfs) {
        class CacheFilter
        extends Transformation<BaseRowIterator<?>> {
            CacheFilter() {
            }

            @Override
            public BaseRowIterator<?> applyToPartition(BaseRowIterator<?> iter) {
                DecoratedKey dk = iter.partitionKey();
                CachedPartition cached = cfs.getRawCachedPartition(dk);
                ClusteringIndexFilter filter = PartitionRangeReadCommand.this.dataRange().clusteringIndexFilter(dk);
                if (cached != null && cfs.isFilterFullyCoveredBy(filter, PartitionRangeReadCommand.this.limits(), cached, PartitionRangeReadCommand.this.nowInSec(), iter.metadata().enforceStrictLiveness())) {
                    iter.close();
                    return filter.getUnfilteredRowIterator(PartitionRangeReadCommand.this.columnFilter(), cached);
                }
                return iter;
            }
        }
        return Transformation.apply(iter, new CacheFilter());
    }

    @Override
    public Verb verb() {
        return Verb.RANGE_REQ;
    }

    @Override
    protected void appendCQLWhereClause(StringBuilder sb) {
        String filterString = this.dataRange().toCQLString(this.metadata(), this.rowFilter());
        if (!filterString.isEmpty()) {
            sb.append(" WHERE ").append(filterString);
        }
    }

    @Override
    public String loggableTokens() {
        return "token range: " + (this.dataRange.keyRange.inclusiveLeft() ? (char)'[' : '(') + ((PartitionPosition)this.dataRange.keyRange.left).getToken().toString() + ", " + ((PartitionPosition)this.dataRange.keyRange.right).getToken().toString() + (this.dataRange.keyRange.inclusiveRight() ? (char)']' : ')');
    }

    public PartitionIterator postReconciliationProcessing(PartitionIterator result) {
        ColumnFamilyStore cfs = Keyspace.open(this.metadata().keyspace).getColumnFamilyStore(this.metadata().name);
        Index index = this.getIndex(cfs);
        return index == null ? result : index.postProcessorFor(this).apply(result, this);
    }

    public String toString() {
        return String.format("Read(%s columns=%s rowfilter=%s limits=%s %s)", this.metadata().toString(), this.columnFilter(), this.rowFilter(), this.limits(), this.dataRange().toString(this.metadata()));
    }

    @Override
    protected void serializeSelection(DataOutputPlus out, int version) throws IOException {
        DataRange.serializer.serialize(this.dataRange(), out, version, this.metadata());
    }

    @Override
    protected long selectionSerializedSize(int version) {
        return DataRange.serializer.serializedSize(this.dataRange(), version, this.metadata());
    }

    @Override
    public boolean isLimitedToOnePartition() {
        return this.dataRange.keyRange instanceof Bounds && this.dataRange.startKey().kind() == PartitionPosition.Kind.ROW_KEY && this.dataRange.startKey().equals(this.dataRange.stopKey());
    }

    @Override
    public boolean isRangeRequest() {
        return true;
    }

    public static class VirtualTablePartitionRangeReadCommand
    extends PartitionRangeReadCommand {
        private VirtualTablePartitionRangeReadCommand(boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, DataRange dataRange, IndexMetadata index, boolean trackWarnings) {
            super(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, dataRange, index, trackWarnings);
        }

        @Override
        public PartitionIterator execute(ConsistencyLevel consistency, ClientState state, Dispatcher.RequestTime requestTime) throws RequestExecutionException {
            return this.executeInternal(this.executionController());
        }

        @Override
        public UnfilteredPartitionIterator executeLocally(ReadExecutionController executionController) {
            VirtualTable view = VirtualKeyspaceRegistry.instance.getTableNullable(this.metadata().id);
            UnfilteredPartitionIterator resultIterator = view.select(this.dataRange, this.columnFilter());
            return this.limits().filter(this.rowFilter().filter(resultIterator, this.nowInSec()), this.nowInSec(), this.selectsFullPartition());
        }

        @Override
        public ReadExecutionController executionController() {
            return ReadExecutionController.empty();
        }

        @Override
        public ReadExecutionController executionController(boolean trackRepairedStatus) {
            return this.executionController();
        }
    }

    private static class Deserializer
    extends ReadCommand.SelectionDeserializer {
        private Deserializer() {
        }

        @Override
        public ReadCommand deserialize(DataInputPlus in, int version, boolean isDigest, int digestVersion, boolean acceptsTransient, TableMetadata metadata, int nowInSec, ColumnFilter columnFilter, RowFilter rowFilter, DataLimits limits, IndexMetadata index) throws IOException {
            DataRange range = DataRange.serializer.deserialize(in, version, metadata);
            return PartitionRangeReadCommand.create(isDigest, digestVersion, acceptsTransient, metadata, nowInSec, columnFilter, rowFilter, limits, range, index, false);
        }
    }
}

