/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.git;

import java.util.Map;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.extension.ExtensionPoint;
import org.apache.hop.core.extension.IExtensionPoint;
import org.apache.hop.core.gui.IGc;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.svg.SvgFile;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.git.HopDiff;
import org.apache.hop.pipeline.PipelinePainterExtension;
import org.apache.hop.ui.core.PropsUi;

@ExtensionPoint(id="DrawDiffOnPipelineHopExtensionPoint", description="Draws a marker on top of a pipeline Hop if it has added or removed", extensionPointId="PipelinePainterArrow")
public class DrawDiffOnPipelineHopExtensionPoint
implements IExtensionPoint<PipelinePainterExtension> {
    public void callExtensionPoint(ILogChannel log, IVariables variables, PipelinePainterExtension ext) throws HopException {
        IGc gc = ext.gc;
        ClassLoader classLoader = this.getClass().getClassLoader();
        try {
            Map gitHops = ext.pipelineMeta.getAttributes("GitHops");
            if (gitHops == null) {
                return;
            }
            for (String hopName : gitHops.keySet()) {
                String pipelineHopName = HopDiff.getPipelineHopName(ext.pipelineHop);
                if (ext.pipelineHop == null || !pipelineHopName.equals(hopName)) continue;
                SvgFile svgFile = null;
                String status = (String)gitHops.get(hopName);
                if (status == null) continue;
                switch (status) {
                    case "ADDED": {
                        svgFile = new SvgFile("added.svg", classLoader);
                        break;
                    }
                    case "REMOVED": {
                        svgFile = new SvgFile("removed.svg", classLoader);
                        break;
                    }
                    case "CHANGED": {
                        svgFile = new SvgFile("changed.svg", classLoader);
                        break;
                    }
                }
                if (svgFile == null) continue;
                Point fr = ext.pipelineHop.getFromTransform().getLocation();
                Point to = ext.pipelineHop.getToTransform().getLocation();
                Point middle = new Point((fr.x + to.x) / 2, (fr.y + to.y) / 2);
                int iconSize = 32;
                try {
                    iconSize = PropsUi.getInstance().getIconSize();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                gc.drawImage(svgFile, middle.x, middle.y, iconSize / 2, iconSize / 2, gc.getMagnification(), 0.0);
            }
        }
        catch (Exception e) {
            throw new HopException("Error drawing status on pipeline hop", (Throwable)e);
        }
    }
}

