/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.metainject;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopXmlException;
import org.apache.hop.core.extension.ExtensionPointHandler;
import org.apache.hop.core.extension.HopExtensionPoint;
import org.apache.hop.core.injection.bean.BeanInjectionInfo;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.config.PipelineRunConfiguration;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.metainject.MetaInject;
import org.apache.hop.pipeline.transforms.metainject.MetaInjectMeta;
import org.apache.hop.pipeline.transforms.metainject.MetaInjectOutputField;
import org.apache.hop.pipeline.transforms.metainject.SourceTransformField;
import org.apache.hop.pipeline.transforms.metainject.TargetTransformAttribute;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ColumnsResizer;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.apache.hop.ui.util.SwtSvgImageUtil;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class MetaInjectDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = MetaInjectMeta.class;
    public static final String CONST_VALUE = "<const>";
    public static final String CONST_META_INJECT_DIALOG_ERROR_LOADING_SPECIFIED_PIPELINE_TITLE = "MetaInjectDialog.ErrorLoadingSpecifiedPipeline.Title";
    public static final String CONST_META_INJECT_DIALOG_ERROR_LOADING_SPECIFIED_PIPELINE_MESSAGE = "MetaInjectDialog.ErrorLoadingSpecifiedPipeline.Message";
    private final MetaInjectMeta metaInjectMeta;
    private TextVar wPath;
    private CTabFolder wTabFolder;
    private PipelineMeta injectPipelineMeta = null;
    protected boolean transModified;
    private ModifyListener lsMod;
    protected Label wlRunConfiguration;
    protected ComboVar wRunConfiguration;
    protected Button wCreateParentFolder;
    private CCombo wSourceTransform;
    private TableView wSourceFields;
    private TextVar wTargetFile;
    private Button wNoExecution;
    private Button wAllowEmptyStreamOnExecution;
    private CCombo wStreamingSourceTransform;
    private Label wlStreamingTargetTransform;
    private CCombo wStreamingTargetTransform;
    private Tree wTree;
    private Map<TreeItem, TargetTransformAttribute> treeItemTargetMap;
    private final Map<TargetTransformAttribute, SourceTransformField> targetSourceMapping;
    private Text wSearchText = null;
    private String filterString = null;

    public MetaInjectDialog(Shell parent, IVariables variables, MetaInjectMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.metaInjectMeta = transformMeta;
        this.transModified = false;
        this.targetSourceMapping = new HashMap<TargetTransformAttribute, SourceTransformField>();
        this.targetSourceMapping.putAll(this.metaInjectMeta.getTargetSourceMapping());
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.metaInjectMeta);
        this.lsMod = e -> this.metaInjectMeta.setChanged();
        this.changed = this.metaInjectMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 15;
        formLayout.marginHeight = 15;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Shell.Title", (String[])new String[0]));
        Label wicon = new Label((Composite)this.shell, 131072);
        wicon.setImage(this.getImage());
        FormData fdlicon = new FormData();
        fdlicon.top = new FormAttachment(0, 0);
        fdlicon.right = new FormAttachment(100, 0);
        wicon.setLayoutData((Object)fdlicon);
        PropsUi.setLook((Widget)wicon);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Button.EnterMapping", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.enterMapping());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        MetaInjectDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wGet, this.wCancel}, (int)PropsUi.getMargin(), null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, 0);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.right = new FormAttachment(90, 0);
        this.fdTransformName.left = new FormAttachment(0, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 5);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Label spacer = new Label((Composite)this.shell, 258);
        FormData fdSpacer = new FormData();
        fdSpacer.left = new FormAttachment(0, 0);
        fdSpacer.top = new FormAttachment((Control)this.wTransformName, 15);
        fdSpacer.right = new FormAttachment(100, 0);
        spacer.setLayoutData((Object)fdSpacer);
        Label wlPath = new Label((Composite)this.shell, 16384);
        PropsUi.setLook((Widget)wlPath);
        wlPath.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Pipeline.Label", (String[])new String[0]));
        FormData fdlTransformation = new FormData();
        fdlTransformation.left = new FormAttachment(0, 0);
        fdlTransformation.top = new FormAttachment((Control)spacer, 20);
        fdlTransformation.right = new FormAttachment(100, 0);
        wlPath.setLayoutData((Object)fdlTransformation);
        Button wbBrowse = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)wbBrowse);
        wbBrowse.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Browse.Label", (String[])new String[0]));
        FormData fdBrowse = new FormData();
        fdBrowse.right = new FormAttachment(100, -PropsUi.getMargin());
        fdBrowse.top = new FormAttachment((Control)wlPath, Const.isOSX() ? 0 : 5);
        wbBrowse.setLayoutData((Object)fdBrowse);
        this.wPath = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wPath);
        FormData fdTransformation = new FormData();
        fdTransformation.left = new FormAttachment(0, 0);
        fdTransformation.top = new FormAttachment((Control)wlPath, 5);
        fdTransformation.right = new FormAttachment((Control)wbBrowse, -PropsUi.getMargin());
        this.wPath.setLayoutData((Object)fdTransformation);
        this.wPath.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                MetaInjectDialog.this.refreshTree();
            }
        });
        wbBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaInjectDialog.this.selectFileTrans();
                MetaInjectDialog.this.refreshTree();
            }
        });
        this.wlRunConfiguration = new Label((Composite)this.shell, 16384);
        this.wlRunConfiguration.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.RunConfiguration.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlRunConfiguration);
        FormData fdlRunConfiguration = new FormData();
        fdlRunConfiguration.left = new FormAttachment(0, 0);
        fdlRunConfiguration.top = new FormAttachment((Control)this.wPath, 20);
        fdlRunConfiguration.right = new FormAttachment(100, 0);
        this.wlRunConfiguration.setLayoutData((Object)fdlRunConfiguration);
        this.wRunConfiguration = new ComboVar(this.variables, (Composite)this.shell, 18432);
        PropsUi.setLook((Widget)this.wlRunConfiguration);
        FormData fdRunConfiguration = new FormData();
        fdRunConfiguration.left = new FormAttachment(0, 0);
        fdRunConfiguration.top = new FormAttachment((Control)this.wlRunConfiguration, 10);
        fdRunConfiguration.right = new FormAttachment(100, 0);
        this.wRunConfiguration.setLayoutData((Object)fdRunConfiguration);
        PropsUi.setLook((Widget)this.wRunConfiguration);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        Label hSpacer = new Label((Composite)this.shell, 258);
        FormData fdhSpacer = new FormData();
        fdhSpacer.left = new FormAttachment(0, 0);
        fdhSpacer.bottom = new FormAttachment((Control)this.wCancel, -15);
        fdhSpacer.right = new FormAttachment(100, 0);
        hSpacer.setLayoutData((Object)fdhSpacer);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wRunConfiguration, 20);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)hSpacer, -15);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.addInjectTab();
        this.addOptionsTab();
        this.getData();
        this.metaInjectMeta.setChanged(this.changed);
        this.checkInvalidMapping();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"GenericTransform.svg", (int)48, (int)48);
    }

    private void checkInvalidMapping() {
        if (this.injectPipelineMeta == null) {
            try {
                if (!this.loadPipeline()) {
                    return;
                }
            }
            catch (HopException e) {
                this.showErrorOnLoadTransformationDialog(e);
                return;
            }
        }
        Set<SourceTransformField> unavailableSourceTransforms = MetaInject.getUnavailableSourceTransforms(this.targetSourceMapping, this.pipelineMeta, this.transformMeta);
        Set<TargetTransformAttribute> unavailableTargetTransforms = MetaInject.getUnavailableTargetTransforms(this.targetSourceMapping, this.injectPipelineMeta);
        Set<TargetTransformAttribute> missingTargetKeys = MetaInject.getUnavailableTargetKeys(this.targetSourceMapping, this.injectPipelineMeta, unavailableTargetTransforms);
        if (unavailableSourceTransforms.isEmpty() && unavailableTargetTransforms.isEmpty() && missingTargetKeys.isEmpty()) {
            return;
        }
        this.showInvalidMappingDialog(unavailableSourceTransforms, unavailableTargetTransforms, missingTargetKeys);
    }

    private void showInvalidMappingDialog(Set<SourceTransformField> unavailableSourceTransforms, Set<TargetTransformAttribute> unavailableTargetTransforms, Set<TargetTransformAttribute> missingTargetKeys) {
        MessageBox mb = new MessageBox(this.shell, 196);
        mb.setMessage(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InvalidMapping.Question", (String[])new String[0]));
        mb.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InvalidMapping.Title", (String[])new String[0]));
        int id = mb.open();
        if (id == 64) {
            MetaInject.removeUnavailableTransformsFromMapping(this.targetSourceMapping, unavailableSourceTransforms, unavailableTargetTransforms);
            for (TargetTransformAttribute target : missingTargetKeys) {
                this.targetSourceMapping.remove(target);
            }
        }
    }

    private void showErrorOnLoadTransformationDialog(HopException e) {
        new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_META_INJECT_DIALOG_ERROR_LOADING_SPECIFIED_PIPELINE_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_META_INJECT_DIALOG_ERROR_LOADING_SPECIFIED_PIPELINE_MESSAGE, (String[])new String[0]), (Exception)((Object)e));
    }

    private void addOptionsTab() {
        int margin = PropsUi.getMargin();
        CTabItem wOptionsTab = new CTabItem(this.wTabFolder, 0);
        wOptionsTab.setFont(GuiResource.getInstance().getFontDefault());
        wOptionsTab.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.OptionsTab.TabTitle", (String[])new String[0]));
        ScrolledComposite wOptionsSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        wOptionsSComp.setLayout((Layout)new FillLayout());
        Composite wOptionsComp = new Composite((Composite)wOptionsSComp, 0);
        PropsUi.setLook((Widget)wOptionsComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 15;
        fileLayout.marginHeight = 15;
        wOptionsComp.setLayout((Layout)fileLayout);
        Label wlSourceTransform = new Label(wOptionsComp, 131072);
        wlSourceTransform.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.SourceTransform.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSourceTransform);
        FormData fdlSourceTransform = new FormData();
        fdlSourceTransform.left = new FormAttachment(0, 0);
        fdlSourceTransform.top = new FormAttachment(0, 0);
        wlSourceTransform.setLayoutData((Object)fdlSourceTransform);
        this.wSourceTransform = new CCombo(wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wSourceTransform);
        this.wSourceTransform.addModifyListener(this.lsMod);
        FormData fdSourceTransform = new FormData();
        fdSourceTransform.right = new FormAttachment(100, 0);
        fdSourceTransform.left = new FormAttachment(0, 0);
        fdSourceTransform.top = new FormAttachment((Control)wlSourceTransform, 5);
        this.wSourceTransform.setLayoutData((Object)fdSourceTransform);
        this.wSourceTransform.addListener(13, e -> this.updateWidgets());
        int fieldRows = this.metaInjectMeta.getSourceOutputFields().size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.ColumnInfo.Fieldname", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.ColumnInfo.Type", (String[])new String[0]), 2, ValueMetaFactory.getAllValueMetaNames()), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.ColumnInfo.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.ColumnInfo.Precision", (String[])new String[0]), 1, false)};
        this.wSourceFields = new TableView(this.variables, wOptionsComp, 67586, colinf, fieldRows, false, this.lsMod, this.props, false);
        FormData fdFields = new FormData();
        fdFields.top = new FormAttachment((Control)this.wSourceTransform, 10);
        fdFields.bottom = new FormAttachment(50, 0);
        fdFields.left = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        this.wSourceFields.setLayoutData((Object)fdFields);
        this.wSourceFields.getTable().addListener(11, (Listener)new ColumnsResizer(new int[]{0, 25, 25, 25, 25}));
        Label wlTargetFile = new Label(wOptionsComp, 131072);
        wlTargetFile.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.TargetFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTargetFile);
        FormData fdlTargetFile = new FormData();
        fdlTargetFile.left = new FormAttachment(0, 0);
        fdlTargetFile.top = new FormAttachment((Control)this.wSourceFields, 10);
        wlTargetFile.setLayoutData((Object)fdlTargetFile);
        Button wbFilename = new Button(wOptionsComp, 0x1000008);
        PropsUi.setLook((Widget)wbFilename);
        wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        wbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)wlTargetFile, margin);
        wbFilename.setLayoutData((Object)fdbFilename);
        wbFilename.addListener(13, e -> BaseDialog.presentFileDialog((boolean)true, (Shell)this.shell, (TextVar)this.wTargetFile, (IVariables)this.variables, (String[])new String[]{"*.hpl"}, (String[])new String[]{BaseMessages.getString(PKG, (String)"System.FileType.Pipeline", (String[])new String[0])}, (boolean)true));
        this.wTargetFile = new TextVar(this.variables, wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wTargetFile);
        this.wTargetFile.addModifyListener(this.lsMod);
        FormData fdTargetFile = new FormData();
        fdTargetFile.right = new FormAttachment((Control)wbFilename, -margin);
        fdTargetFile.left = new FormAttachment(0, 0);
        fdTargetFile.top = new FormAttachment((Control)wlTargetFile, margin);
        this.wTargetFile.setLayoutData((Object)fdTargetFile);
        this.wCreateParentFolder = new Button(wOptionsComp, 32);
        this.wCreateParentFolder.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.CreateParentFolder.Label", (String[])new String[0]));
        this.wCreateParentFolder.setToolTipText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.CreateParentFolder.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wCreateParentFolder);
        FormData fdCreateParentFolder = new FormData();
        fdCreateParentFolder.left = new FormAttachment(0, 0);
        fdCreateParentFolder.top = new FormAttachment((Control)this.wTargetFile, margin);
        this.wCreateParentFolder.setLayoutData((Object)fdCreateParentFolder);
        this.wCreateParentFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MetaInjectDialog.this.metaInjectMeta.setChanged();
            }
        });
        Label wlStreamingSourceTransform = new Label(wOptionsComp, 131072);
        wlStreamingSourceTransform.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.StreamingSourceTransform.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStreamingSourceTransform);
        FormData fdlStreamingSourceTransform = new FormData();
        fdlStreamingSourceTransform.left = new FormAttachment(0, 0);
        fdlStreamingSourceTransform.top = new FormAttachment((Control)this.wCreateParentFolder, 10);
        wlStreamingSourceTransform.setLayoutData((Object)fdlStreamingSourceTransform);
        this.wStreamingSourceTransform = new CCombo(wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wStreamingSourceTransform);
        FormData fdStreamingSourceTransform = new FormData();
        fdStreamingSourceTransform.right = new FormAttachment(100, 0);
        fdStreamingSourceTransform.left = new FormAttachment(0, 0);
        fdStreamingSourceTransform.top = new FormAttachment((Control)wlStreamingSourceTransform, 5);
        this.wStreamingSourceTransform.setLayoutData((Object)fdStreamingSourceTransform);
        this.wStreamingSourceTransform.setItems(this.pipelineMeta.getTransformNames());
        this.wStreamingSourceTransform.addListener(13, e -> this.updateWidgets());
        this.wlStreamingTargetTransform = new Label(wOptionsComp, 131072);
        this.wlStreamingTargetTransform.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.StreamingTargetTransform.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlStreamingTargetTransform);
        FormData fdlStreamingTargetTransform = new FormData();
        fdlStreamingTargetTransform.left = new FormAttachment(0, 0);
        fdlStreamingTargetTransform.top = new FormAttachment((Control)this.wStreamingSourceTransform, 10);
        this.wlStreamingTargetTransform.setLayoutData((Object)fdlStreamingTargetTransform);
        this.wStreamingTargetTransform = new CCombo(wOptionsComp, 18436);
        PropsUi.setLook((Widget)this.wStreamingTargetTransform);
        FormData fdStreamingTargetTransform = new FormData();
        fdStreamingTargetTransform.right = new FormAttachment(100, 0);
        fdStreamingTargetTransform.left = new FormAttachment(0, 0);
        fdStreamingTargetTransform.top = new FormAttachment((Control)this.wlStreamingTargetTransform, 5);
        this.wStreamingTargetTransform.setLayoutData((Object)fdStreamingTargetTransform);
        this.wNoExecution = new Button(wOptionsComp, 32);
        this.wNoExecution.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.NoExecution.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wNoExecution);
        FormData fdNoExecution = new FormData();
        fdNoExecution.width = 350;
        fdNoExecution.left = new FormAttachment(0, 0);
        fdNoExecution.top = new FormAttachment((Control)this.wStreamingTargetTransform, 10);
        this.wNoExecution.setLayoutData((Object)fdNoExecution);
        this.wAllowEmptyStreamOnExecution = new Button(wOptionsComp, 32);
        this.wAllowEmptyStreamOnExecution.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.AllowEmptyStreamOnExecution.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wAllowEmptyStreamOnExecution);
        FormData fdAllowEmptyStreamOnExecution = new FormData();
        fdAllowEmptyStreamOnExecution.width = 350;
        fdAllowEmptyStreamOnExecution.left = new FormAttachment(0, 0);
        fdAllowEmptyStreamOnExecution.top = new FormAttachment((Control)this.wNoExecution, 10);
        this.wAllowEmptyStreamOnExecution.setLayoutData((Object)fdAllowEmptyStreamOnExecution);
        FormData fdOptionsComp = new FormData();
        fdOptionsComp.left = new FormAttachment(0, 0);
        fdOptionsComp.top = new FormAttachment(0, 0);
        fdOptionsComp.right = new FormAttachment(100, 0);
        fdOptionsComp.bottom = new FormAttachment(100, 0);
        wOptionsComp.setLayoutData((Object)fdOptionsComp);
        wOptionsComp.pack();
        Rectangle bounds = wOptionsComp.getBounds();
        wOptionsSComp.setContent((Control)wOptionsComp);
        wOptionsSComp.setExpandHorizontal(true);
        wOptionsSComp.setExpandVertical(true);
        wOptionsSComp.setMinWidth(bounds.width);
        wOptionsSComp.setMinHeight(bounds.height);
        wOptionsTab.setControl((Control)wOptionsSComp);
    }

    private void addInjectTab() {
        CTabItem wInjectTab = new CTabItem(this.wTabFolder, 0);
        wInjectTab.setFont(GuiResource.getInstance().getFontDefault());
        wInjectTab.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InjectTab.TabTitle", (String[])new String[0]));
        ScrolledComposite wInjectSComp = new ScrolledComposite((Composite)this.wTabFolder, 768);
        wInjectSComp.setLayout((Layout)new FillLayout());
        Composite wInjectComp = new Composite((Composite)wInjectSComp, 0);
        PropsUi.setLook((Widget)wInjectComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 15;
        fileLayout.marginHeight = 15;
        wInjectComp.setLayout((Layout)fileLayout);
        ToolBar treeTb = new ToolBar(wInjectComp, 0x800100);
        PropsUi.setLook((Widget)treeTb, (int)0);
        ToolItem wFilter = new ToolItem(treeTb, 2);
        this.wSearchText = new Text((Composite)treeTb, 896);
        this.wSearchText.setData("NoDefaultHandler", (Object)true);
        PropsUi.setLook((Widget)this.wSearchText);
        this.wSearchText.setToolTipText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InjectTab.FilterString.ToolTip", (String[])new String[0]));
        wFilter.setControl((Control)this.wSearchText);
        wFilter.setWidth((int)(150.0 * this.props.getZoomFactor()));
        ToolItem wExpandAll = new ToolItem(treeTb, 8);
        wExpandAll.setImage(GuiResource.getInstance().getImageExpandAll());
        wExpandAll.setToolTipText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InjectTab.FilterString.ExpandAll", (String[])new String[0]));
        wExpandAll.addListener(13, e -> this.setExpandedState(true));
        ToolItem wCollapseAll = new ToolItem(treeTb, 8);
        wCollapseAll.setImage(GuiResource.getInstance().getImageCollapseAll());
        wCollapseAll.setToolTipText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InjectTab.FilterString.CollapseAll", (String[])new String[0]));
        wCollapseAll.addListener(13, e -> this.setExpandedState(false));
        FormData fd = new FormData();
        fd.right = new FormAttachment(100);
        fd.top = new FormAttachment(0, 0);
        treeTb.setLayoutData((Object)fd);
        Label wlFilter = new Label(wInjectComp, 131072);
        PropsUi.setLook((Widget)wlFilter);
        wlFilter.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InjectTab.FilterString.Label", (String[])new String[0]));
        FormData fdlFilter = new FormData();
        fdlFilter.top = new FormAttachment(0, 5);
        fdlFilter.right = new FormAttachment((Control)treeTb, -5);
        wlFilter.setLayoutData((Object)fdlFilter);
        this.wSearchText.addListener(24, e -> this.updateTransformationFilter());
        Label wlTree = new Label(wInjectComp, 16384);
        PropsUi.setLook((Widget)wlTree);
        wlTree.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.InjectTab.CLickTree.Label", (String[])new String[0]));
        this.wTree = new Tree(wInjectComp, 68356);
        FormData fdTree = new FormData();
        fdTree.left = new FormAttachment(0, 0);
        fdTree.top = new FormAttachment((Control)wlFilter, 5);
        fdTree.right = new FormAttachment(100, 0);
        fdTree.bottom = new FormAttachment(100, 0);
        this.wTree.setLayoutData((Object)fdTree);
        PropsUi.setLook((Widget)this.wTree);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Column.TargetTransform", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Column.SourceTransform", (String[])new String[0]), 2, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"MetaInjectDialog.Column.SourceField", (String[])new String[0]), 2, false, true)};
        this.wTree.setHeaderVisible(true);
        for (ColumnInfo columnInfo : colinf) {
            TreeColumn treeColumn = new TreeColumn(this.wTree, columnInfo.getAlignment());
            treeColumn.setText(columnInfo.getName());
            treeColumn.setWidth((int)(300.0 * this.props.getZoomFactor()));
        }
        this.wTree.addListener(3, this::treeClicked);
        FormData fdInjectComp = new FormData();
        fdInjectComp.left = new FormAttachment(0, 0);
        fdInjectComp.top = new FormAttachment((Control)wlFilter, 5);
        fdInjectComp.right = new FormAttachment(100, 0);
        fdInjectComp.bottom = new FormAttachment(100, 0);
        wInjectComp.setLayoutData((Object)fdInjectComp);
        wInjectComp.pack();
        Rectangle bounds = wInjectComp.getBounds();
        wInjectSComp.setContent((Control)wInjectComp);
        wInjectSComp.setExpandHorizontal(true);
        wInjectSComp.setExpandVertical(true);
        wInjectSComp.setMinWidth(bounds.width);
        wInjectSComp.setMinHeight(bounds.height);
        wInjectTab.setControl((Control)wInjectSComp);
    }

    private void treeClicked(Event event) {
        try {
            TargetTransformAttribute target;
            Point point = new Point(event.x, event.y);
            TreeItem item = this.wTree.getItem(point);
            if (item != null && (target = this.treeItemTargetMap.get(item)) != null) {
                String selectedTransformField;
                SourceTransformField source = this.targetSourceMapping.get(target);
                Object[] prevTransformNames = this.pipelineMeta.getPrevTransformNames(this.transformMeta);
                Arrays.sort(prevTransformNames);
                HashMap<String, SourceTransformField> fieldMap = new HashMap<String, SourceTransformField>();
                for (Object prevTransformName : prevTransformNames) {
                    IRowMeta fields = this.pipelineMeta.getTransformFields(this.variables, (String)prevTransformName);
                    for (IValueMeta field : fields.getValueMetaList()) {
                        String key = this.buildTransformFieldKey((String)prevTransformName, field.getName());
                        fieldMap.put(key, new SourceTransformField((String)prevTransformName, field.getName()));
                    }
                }
                Object[] sourceFields = fieldMap.keySet().toArray(new String[fieldMap.size()]);
                Arrays.sort(sourceFields);
                String constant = source != null && source.getTransformName() == null ? source.getField() : "";
                EnterSelectionDialog selectSourceFieldDialog = new EnterSelectionDialog(this.shell, (String[])sourceFields, BaseMessages.getString(PKG, (String)"MetaInjectDialog.SourceFieldDialog.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetaInjectDialog.SourceFieldDialog.Label", (String[])new String[0]), constant, this.variables);
                selectSourceFieldDialog.setAddNoneOption(true);
                if (source != null) {
                    if (source.getTransformName() != null && !Utils.isEmpty((CharSequence)source.getTransformName())) {
                        String key = this.buildTransformFieldKey(source.getTransformName(), source.getField());
                        selectSourceFieldDialog.setCurrentValue(key);
                        int index = Const.indexOfString((String)key, (String[])sourceFields);
                        if (index >= 0) {
                            selectSourceFieldDialog.setSelectedNrs(new int[]{index});
                        }
                    } else {
                        selectSourceFieldDialog.setCurrentValue(source.getField());
                    }
                }
                if ((selectedTransformField = selectSourceFieldDialog.open()) != null) {
                    SourceTransformField newSource = (SourceTransformField)fieldMap.get(selectedTransformField);
                    if (newSource == null) {
                        newSource = new SourceTransformField(null, selectedTransformField);
                        item.setText(1, CONST_VALUE);
                        item.setText(2, selectedTransformField);
                    } else {
                        item.setText(1, newSource.getTransformName());
                        item.setText(2, newSource.getField());
                    }
                    this.targetSourceMapping.put(target, newSource);
                } else if (selectSourceFieldDialog.isNoneClicked()) {
                    item.setText(1, "");
                    item.setText(2, "");
                    this.targetSourceMapping.remove(target);
                }
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Oops", "Unexpected Error", e);
        }
    }

    private void selectFileTrans() {
        try {
            HopPipelineFileType fileType = HopGui.getExplorerPerspective().getPipelineFileType();
            String filename = BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wPath, (IVariables)this.variables, (String[])fileType.getFilterExtensions(), (String[])fileType.getFilterNames(), (boolean)true);
            if (filename != null) {
                this.loadPipelineFile(filename);
                this.wPath.setText(filename);
            }
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingPipeline.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MetaInjectDialog.ErrorLoadingPipeline.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void loadPipelineFile(String filename) throws HopException {
        String realFilename = this.variables.resolve(filename);
        try {
            this.injectPipelineMeta = new PipelineMeta(realFilename, this.metadataProvider, this.variables);
            this.injectPipelineMeta.clearChanged();
        }
        catch (HopXmlException e) {
            MessageBox box = new MessageBox(this.shell, 40);
            box.setText(BaseMessages.getString(PKG, (String)CONST_META_INJECT_DIALOG_ERROR_LOADING_SPECIFIED_PIPELINE_TITLE, (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)CONST_META_INJECT_DIALOG_ERROR_LOADING_SPECIFIED_PIPELINE_MESSAGE, (String[])new String[0]));
            box.open();
        }
    }

    private boolean loadPipeline() throws HopException {
        Object filename = this.wPath.getText();
        if (Utils.isEmpty((CharSequence)filename)) {
            return false;
        }
        if (!((String)filename).endsWith(".hpl")) {
            filename = (String)filename + ".hpl";
            this.wPath.setText((String)filename);
        }
        this.loadPipelineFile((String)filename);
        return this.injectPipelineMeta != null;
    }

    public void updateWidgets() {
        boolean outputCapture = !Utils.isEmpty((CharSequence)this.wSourceTransform.getText());
        this.wSourceFields.setEnabled(outputCapture);
        boolean streaming = !Utils.isEmpty((CharSequence)this.wStreamingSourceTransform.getText());
        this.wStreamingTargetTransform.setEnabled(streaming);
        this.wlStreamingTargetTransform.setEnabled(streaming);
    }

    public void getData() {
        this.wPath.setText(Const.NVL((String)this.metaInjectMeta.getFileName(), (String)""));
        try {
            List runConfigurations = this.metadataProvider.getSerializer(PipelineRunConfiguration.class).listObjectNames();
            try {
                ExtensionPointHandler.callExtensionPoint((ILogChannel)HopGui.getInstance().getLog(), (IVariables)this.variables, (String)HopExtensionPoint.HopGuiRunConfiguration.id, (Object)new Object[]{runConfigurations, "pipeline"});
            }
            catch (HopException hopException) {
                // empty catch block
            }
            this.wRunConfiguration.setItems(runConfigurations.toArray(new String[0]));
            this.wRunConfiguration.setText(Const.NVL((String)this.metaInjectMeta.getRunConfigurationName(), (String)""));
            if (Utils.isEmpty((CharSequence)this.metaInjectMeta.getRunConfigurationName())) {
                this.wRunConfiguration.select(0);
            } else {
                this.wRunConfiguration.setText(this.metaInjectMeta.getRunConfigurationName());
            }
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error getting pipeline run configurations", (Throwable)e);
        }
        this.wSourceTransform.setText(Const.NVL((String)this.metaInjectMeta.getSourceTransformName(), (String)""));
        int rownr = 0;
        for (MetaInjectOutputField field : this.metaInjectMeta.getSourceOutputFields()) {
            int colNr = 1;
            this.wSourceFields.setText(field.getName(), colNr++, rownr);
            this.wSourceFields.setText(field.getTypeDescription(), colNr++, rownr);
            this.wSourceFields.setText(field.getLength() < 0 ? "" : Integer.toString(field.getLength()), colNr++, rownr);
            this.wSourceFields.setText(field.getPrecision() < 0 ? "" : Integer.toString(field.getPrecision()), colNr, rownr);
            ++rownr;
        }
        this.wTargetFile.setText(Const.NVL((String)this.metaInjectMeta.getTargetFile(), (String)""));
        this.wCreateParentFolder.setSelection(this.metaInjectMeta.isCreateParentFolder());
        this.wNoExecution.setSelection(!this.metaInjectMeta.isNoExecution());
        this.wAllowEmptyStreamOnExecution.setSelection(this.metaInjectMeta.isAllowEmptyStreamOnExecution());
        this.wStreamingSourceTransform.setText(Const.NVL(this.metaInjectMeta.getStreamSourceTransform() == null ? null : this.metaInjectMeta.getStreamSourceTransform().getName(), (String)""));
        this.wStreamingTargetTransform.setText(Const.NVL((String)this.metaInjectMeta.getStreamTargetTransformName(), (String)""));
        this.updateWidgets();
        this.refreshTree();
        this.wTabFolder.setSelection(0);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    protected String buildTransformFieldKey(String transformName, String field) {
        return transformName + " : " + field;
    }

    protected void updateTransformationFilter() {
        this.filterString = null;
        if (this.wSearchText != null && !this.wSearchText.isDisposed() && !Utils.isEmpty((CharSequence)this.wSearchText.getText())) {
            this.filterString = this.wSearchText.getText().toUpperCase();
        }
        this.refreshTree();
        this.setExpandedState(true);
    }

    private void refreshTree() {
        try {
            this.loadPipeline();
            this.treeItemTargetMap = new HashMap<TreeItem, TargetTransformAttribute>();
            this.wTree.removeAll();
            ArrayList<TransformMeta> injectTransforms = new ArrayList<TransformMeta>();
            for (TransformMeta transformMeta : this.injectPipelineMeta.getTransforms()) {
                ITransformMeta meta = transformMeta.getTransform();
                if (!BeanInjectionInfo.isInjectionSupported(meta.getClass())) continue;
                injectTransforms.add(transformMeta);
            }
            Collections.sort(injectTransforms);
            for (TransformMeta transformMeta : injectTransforms) {
                TreeItem transformItem = new TreeItem(this.wTree, 0);
                transformItem.setText(transformMeta.getName());
                boolean expanded = false;
                Image image = GuiResource.getInstance().getSwtImageTransform(transformMeta.getPluginId()).getAsBitmapForSize((Device)this.shell.getDisplay(), 32, 32);
                transformItem.setImage(image);
                ITransformMeta metaInterface = transformMeta.getTransform();
                if (BeanInjectionInfo.isInjectionSupported(metaInterface.getClass())) {
                    expanded = expanded || this.processMDIDescription(transformMeta, transformItem, metaInterface);
                }
                transformItem.setExpanded(expanded);
            }
        }
        catch (Throwable injectTransforms) {
            // empty catch block
        }
        if (this.injectPipelineMeta != null) {
            Object[] sourceTransforms = this.injectPipelineMeta.getTransformNames();
            Arrays.sort(sourceTransforms);
            this.wSourceTransform.setItems((String[])sourceTransforms);
            this.wStreamingTargetTransform.setItems((String[])sourceTransforms);
        }
    }

    private boolean processMDIDescription(TransformMeta transformMeta, TreeItem transformItem, ITransformMeta metaInterface) {
        boolean hasUsedKeys = false;
        BeanInjectionInfo transformInjectionInfo = new BeanInjectionInfo(metaInterface.getClass());
        List groupsList = transformInjectionInfo.getGroups();
        for (BeanInjectionInfo.Group gr : groupsList) {
            TreeItem groupItem;
            if (!gr.hasMatchingProperty(this.filterString)) continue;
            boolean rootGroup = StringUtils.isEmpty((String)gr.getKey());
            if (!rootGroup) {
                groupItem = new TreeItem(transformItem, 0);
                groupItem.setText(Const.NVL((String)gr.getTranslatedDescription(), (String)gr.getKey()));
                groupItem.setExpanded(true);
            } else {
                groupItem = null;
            }
            List propertyList = gr.getProperties();
            for (BeanInjectionInfo.Property property : propertyList) {
                if (!property.hasMatch(this.filterString) || property.isExcludedFromInjection()) continue;
                TreeItem treeItem = new TreeItem(rootGroup ? transformItem : groupItem, 0);
                treeItem.setText(Const.NVL((String)property.getTranslatedDescription(), (String)property.getKey()));
                TargetTransformAttribute target = new TargetTransformAttribute(transformMeta.getName(), property.getKey(), !rootGroup);
                this.treeItemTargetMap.put(treeItem, target);
                SourceTransformField source = this.targetSourceMapping.get(target);
                if (source == null) continue;
                hasUsedKeys = true;
                treeItem.setText(1, Const.NVL((String)(source.getTransformName() == null ? CONST_VALUE : source.getTransformName()), (String)""));
                treeItem.setText(2, Const.NVL((String)source.getField(), (String)""));
            }
        }
        return hasUsedKeys;
    }

    private void setExpandedState(boolean state) {
        for (TreeItem item : this.wTree.getItems()) {
            this.expandItemAndChildren(item, state);
        }
    }

    private void expandItemAndChildren(TreeItem item, boolean state) {
        item.setExpanded(state);
        for (TreeItem item2 : item.getItems()) {
            this.expandItemAndChildren(item2, state);
        }
    }

    private void cancel() {
        this.transformName = null;
        this.metaInjectMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        try {
            this.loadPipeline();
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_META_INJECT_DIALOG_ERROR_LOADING_SPECIFIED_PIPELINE_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_META_INJECT_DIALOG_ERROR_LOADING_SPECIFIED_PIPELINE_MESSAGE, (String[])new String[0]), (Exception)((Object)e));
        }
        if (Utils.isEmpty((CharSequence)this.wPath.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.FilenameMissing.Header", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"MetaInjectDialog.FilenameMissing.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        if (this.isSelfReferencing()) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"MetaInjectDialog.SelfReference.Header", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"MetaInjectDialog.SelfReference.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        this.getInfo(this.metaInjectMeta);
        this.dispose();
    }

    private void getInfo(MetaInjectMeta meta) {
        meta.setFileName(this.wPath.getText());
        meta.setSourceTransformName(this.wSourceTransform.getText());
        meta.setRunConfigurationName(this.wRunConfiguration.getText());
        meta.setSourceOutputFields(new ArrayList<MetaInjectOutputField>());
        for (int i = 0; i < this.wSourceFields.nrNonEmpty(); ++i) {
            TableItem item = this.wSourceFields.getNonEmpty(i);
            int colIndex = 1;
            String name = item.getText(colIndex++);
            int type = ValueMetaFactory.getIdForValueMeta((String)item.getText(colIndex++));
            int length = Const.toInt((String)item.getText(colIndex++), (int)-1);
            int precision = Const.toInt((String)item.getText(colIndex++), (int)-1);
            meta.getSourceOutputFields().add(new MetaInjectOutputField(name, type, length, precision));
        }
        meta.setTargetFile(this.wTargetFile.getText());
        meta.setCreateParentFolder(this.wCreateParentFolder.getSelection());
        meta.setNoExecution(!this.wNoExecution.getSelection());
        meta.setAllowEmptyStreamOnExecution(this.wAllowEmptyStreamOnExecution.getSelection());
        TransformMeta streamSourceTransform = this.pipelineMeta.findTransform(this.wStreamingSourceTransform.getText());
        meta.setStreamSourceTransform(streamSourceTransform);
        meta.setStreamSourceTransformName(streamSourceTransform != null ? streamSourceTransform.getName() : "");
        meta.setStreamTargetTransformName(this.wStreamingTargetTransform.getText());
        meta.setTargetSourceMapping(this.targetSourceMapping);
        meta.setChanged(true);
    }

    private void enterMapping() {
        try {
            this.loadPipeline();
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_META_INJECT_DIALOG_ERROR_LOADING_SPECIFIED_PIPELINE_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)CONST_META_INJECT_DIALOG_ERROR_LOADING_SPECIFIED_PIPELINE_MESSAGE, (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        MetaInjectMeta meta = new MetaInjectMeta();
        this.getInfo(meta);
        ArrayList<MappingSource> mappingSources = new ArrayList<MappingSource>();
        ArrayList<CallSite> sourceStrings = new ArrayList<CallSite>();
        HashMap<String, IRowMeta> sourceRowMetas = new HashMap<String, IRowMeta>();
        for (TransformMeta previousTransformMeta : this.pipelineMeta.findPreviousTransforms(this.transformMeta)) {
            try {
                IRowMeta previousRowMeta = this.pipelineMeta.getTransformFields(this.variables, previousTransformMeta);
                sourceRowMetas.put(previousTransformMeta.getName(), previousRowMeta);
                for (IValueMeta previousValueMeta : previousRowMeta.getValueMetaList()) {
                    mappingSources.add(new MappingSource(previousTransformMeta, previousValueMeta));
                    sourceStrings.add((CallSite)((Object)(previousTransformMeta.getName() + " - " + previousValueMeta.getName())));
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, "Error", "Error determining output row of transform '" + previousTransformMeta.getName() + "'", e);
            }
        }
        ArrayList<MappingTarget> mappingTargets = new ArrayList<MappingTarget>();
        ArrayList<CallSite> targetStrings = new ArrayList<CallSite>();
        for (TransformMeta transformMeta : this.injectPipelineMeta.getTransforms()) {
            ITransformMeta iTransformMeta = transformMeta.getTransform();
            if (!BeanInjectionInfo.isInjectionSupported(iTransformMeta.getClass())) continue;
            BeanInjectionInfo transformInjectionInfo = new BeanInjectionInfo(iTransformMeta.getClass());
            List groupsList = transformInjectionInfo.getGroups();
            for (BeanInjectionInfo.Group group : groupsList) {
                boolean detail = StringUtils.isNotEmpty((String)group.getKey());
                List propertyList = group.getProperties();
                for (BeanInjectionInfo.Property property : propertyList) {
                    mappingTargets.add(new MappingTarget(transformMeta, property.getKey(), detail));
                    String groupName = group.getKey();
                    String targetString = transformMeta.getName() + " | ";
                    if (StringUtils.isNotEmpty((String)groupName)) {
                        targetString = targetString + groupName + " - ";
                    }
                    targetString = targetString + property.getKey();
                    targetString = targetString + " : ";
                    targetString = targetString + property.getTranslatedDescription();
                    targetStrings.add((CallSite)((Object)targetString));
                }
            }
        }
        ArrayList<SourceToTargetMapping> mappings = new ArrayList<SourceToTargetMapping>();
        Map<TargetTransformAttribute, SourceTransformField> targetSourceMapping = meta.getTargetSourceMapping();
        for (TargetTransformAttribute targetTransformAttribute : targetSourceMapping.keySet()) {
            IValueMeta sourceValueMeta;
            IRowMeta sourceRowMeta;
            SourceTransformField sourceTransformField = targetSourceMapping.get(targetTransformAttribute);
            if (sourceTransformField == null) continue;
            int sourceIndex = -1;
            TransformMeta sourceTransformMeta = this.pipelineMeta.findTransform(sourceTransformField.getTransformName());
            if (sourceTransformMeta != null && (sourceRowMeta = (IRowMeta)sourceRowMetas.get(sourceTransformMeta.getName())) != null && (sourceValueMeta = sourceRowMeta.searchValueMeta(sourceTransformField.getField())) != null) {
                MappingSource mappingSource = new MappingSource(sourceTransformMeta, sourceValueMeta);
                sourceIndex = mappingSources.indexOf(mappingSource);
            }
            int targetIndex = -1;
            TransformMeta targetTransformMeta = this.injectPipelineMeta.findTransform(targetTransformAttribute.getTransformName());
            if (targetTransformMeta != null) {
                MappingTarget mapingTarget = new MappingTarget(targetTransformMeta, targetTransformAttribute.getAttributeKey(), targetTransformAttribute.isDetail());
                targetIndex = mappingTargets.indexOf(mapingTarget);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            mappings.add(new SourceToTargetMapping(sourceIndex, targetIndex));
        }
        String[] src = sourceStrings.toArray(new String[0]);
        String[] tgt = targetStrings.toArray(new String[0]);
        EnterMappingDialog dialog = new EnterMappingDialog(this.shell, src, tgt, mappings);
        dialog.setSourceSeparator(" - ");
        dialog.setTargetSeparator(" : ");
        List newMappings = dialog.open();
        if (newMappings != null) {
            targetSourceMapping.clear();
            for (SourceToTargetMapping newMapping : newMappings) {
                MappingSource mappingSource = (MappingSource)mappingSources.get(newMapping.getSourcePosition());
                SourceTransformField sourceTransformField = new SourceTransformField(mappingSource.transformMeta.getName(), mappingSource.valueMeta.getName());
                MappingTarget mappingTarget = (MappingTarget)mappingTargets.get(newMapping.getTargetPosition());
                TargetTransformAttribute targetTransformAttribute = new TargetTransformAttribute(mappingTarget.transformMeta.getName(), mappingTarget.attributeKey, mappingTarget.detail);
                targetSourceMapping.put(targetTransformAttribute, sourceTransformField);
                this.refreshTree();
            }
        }
    }

    private boolean isSelfReferencing() {
        return this.variables.resolve(this.wPath.getText()).equals(this.variables.resolve(this.pipelineMeta.getFilename()));
    }

    private class MappingSource {
        public TransformMeta transformMeta;
        public IValueMeta valueMeta;

        public MappingSource(TransformMeta transformMeta, IValueMeta valueMeta) {
            this.transformMeta = transformMeta;
            this.valueMeta = valueMeta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappingSource that = (MappingSource)o;
            return Objects.equals(this.transformMeta, that.transformMeta) && Objects.equals(this.valueMeta, that.valueMeta);
        }
    }

    private class MappingTarget {
        public TransformMeta transformMeta;
        public String attributeKey;
        public boolean detail;

        public MappingTarget(TransformMeta transformMeta, String attributeKey, boolean detail) {
            this.transformMeta = transformMeta;
            this.attributeKey = attributeKey;
            this.detail = detail;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MappingTarget that = (MappingTarget)o;
            return Objects.equals(this.transformMeta, that.transformMeta) && Objects.equals(this.attributeKey, that.attributeKey);
        }
    }
}

