/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.joinrows;

import java.io.File;
import java.util.List;
import lombok.Generated;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.Condition;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.metadata.api.IStringObjectConverter;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.joinrows.JoinRows;
import org.apache.hop.pipeline.transforms.joinrows.JoinRowsData;

@Transform(id="JoinRows", image="joinrows.svg", name="i18n::BaseTransform.TypeLongDesc.JoinRows", description="i18n::BaseTransform.TypeTooltipDesc.JoinRows", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Joins", keywords={"i18n::JoinRowsMeta.keyword"}, documentationUrl="/pipeline/transforms/joinrows.html")
public class JoinRowsMeta
extends BaseTransformMeta<JoinRows, JoinRowsData> {
    private static final Class<?> PKG = JoinRowsMeta.class;
    @HopMetadataProperty(key="directory", injectionKey="TEMP_DIR", injectionKeyDescription="JoinRows.Injection.TEMP_DIR")
    private String directory;
    @HopMetadataProperty(key="prefix", injectionKey="TEMP_FILE_PREFIX", injectionKeyDescription="JoinRows.Injection.TEMP_FILE_PREFIX")
    private String prefix;
    @HopMetadataProperty(key="cache_size", injectionKey="MAX_CACHE_SIZE", injectionKeyDescription="JoinRows.Injection.MAX_CACHE_SIZE")
    private int cacheSize;
    private TransformMeta mainTransform;
    @HopMetadataProperty(key="main", injectionKey="MAIN_TRANSFORM", injectionKeyDescription="JoinRows.Injection.MAIN_TRANSFORM")
    private String mainTransformName;
    @HopMetadataProperty(key="compare", injectionKey="CONDITION", injectionKeyDescription="JoinRows.Injection.CONDITION", injectionStringObjectConverter=ConditionXmlConverter.class)
    private JRCompare compare = new JRCompare();

    public void setDefault() {
        this.directory = "%%java.io.tmpdir%%";
        this.prefix = "out";
        this.cacheSize = 500;
        this.mainTransformName = null;
    }

    public void getFields(PipelineMeta pipelineMeta, IRowMeta rowMeta, String origin, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) throws HopTransformException {
        TransformMeta[] transforms = pipelineMeta.getPrevTransforms(pipelineMeta.findTransform(origin));
        TransformMeta firstTransform = pipelineMeta.findTransform(this.getMainTransformName());
        rowMeta.clear();
        if (firstTransform != null) {
            rowMeta.addRowMeta(pipelineMeta.getTransformFields(variables, firstTransform));
        }
        for (TransformMeta transform : transforms) {
            if (transform.equals((Object)firstTransform)) continue;
            IRowMeta transformFields = pipelineMeta.getTransformFields(variables, transform);
            rowMeta.addRowMeta(transformFields);
        }
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && !prev.isEmpty()) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.TransformReceivingDatas", (String[])new String[]{"" + prev.size()}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
            String realDirectory = variables.resolve(this.directory);
            File f = new File(realDirectory);
            if (f.exists()) {
                if (f.isDirectory()) {
                    cr = new CheckResult(1, "[" + realDirectory + BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.DirectoryExists", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                } else {
                    cr = new CheckResult(4, "[" + realDirectory + BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.DirectoryExistsButNotValid", (String[])new String[0]), (ICheckResultSource)transformMeta);
                    remarks.add((ICheckResult)cr);
                }
            } else {
                cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.DirectoryDoesNotExist", (String[])new String[]{realDirectory}), (ICheckResultSource)transformMeta);
                remarks.add((ICheckResult)cr);
            }
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.CouldNotFindFieldsFromPreviousTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.TransformReceivingInfoFromOtherTransforms", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"JoinRowsMeta.CheckResult.NoInputReceived", (String[])new String[0]), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
    }

    public String getLookupTransformName() {
        if (this.mainTransform != null && this.mainTransform.getName() != null && !this.mainTransform.getName().isEmpty()) {
            return this.mainTransform.getName();
        }
        return null;
    }

    public void searchInfoAndTargetTransforms(List<TransformMeta> transforms) {
        this.mainTransform = TransformMeta.findTransform(transforms, (String)this.mainTransformName);
    }

    public boolean excludeFromRowLayoutVerification() {
        return true;
    }

    public boolean cleanAfterHopToRemove(TransformMeta fromTransform) {
        boolean hasChanged = false;
        if (null != fromTransform && fromTransform.equals((Object)this.getMainTransform())) {
            this.setMainTransform(null);
            this.setMainTransformName(null);
            hasChanged = true;
        }
        return hasChanged;
    }

    public Condition getCondition() {
        return this.compare.condition;
    }

    public void setCondition(Condition condition) {
        this.compare.condition = condition;
    }

    @Generated
    public String getDirectory() {
        return this.directory;
    }

    @Generated
    public String getPrefix() {
        return this.prefix;
    }

    @Generated
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Generated
    public TransformMeta getMainTransform() {
        return this.mainTransform;
    }

    @Generated
    public String getMainTransformName() {
        return this.mainTransformName;
    }

    @Generated
    public JRCompare getCompare() {
        return this.compare;
    }

    @Generated
    public void setDirectory(String directory) {
        this.directory = directory;
    }

    @Generated
    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Generated
    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    @Generated
    public void setMainTransform(TransformMeta mainTransform) {
        this.mainTransform = mainTransform;
    }

    @Generated
    public void setMainTransformName(String mainTransformName) {
        this.mainTransformName = mainTransformName;
    }

    @Generated
    public void setCompare(JRCompare compare) {
        this.compare = compare;
    }

    public static final class JRCompare {
        @HopMetadataProperty(key="condition")
        private Condition condition;

        public JRCompare() {
            this.condition = new Condition();
        }

        public JRCompare(Condition condition) {
            this.condition = condition;
        }

        @Generated
        public Condition getCondition() {
            return this.condition;
        }

        @Generated
        public void setCondition(Condition condition) {
            this.condition = condition;
        }
    }

    public static final class ConditionXmlConverter
    implements IStringObjectConverter {
        public String getString(Object object) throws HopException {
            if (!(object instanceof JRCompare)) {
                throw new HopException("We only support XML serialization of Condition objects here");
            }
            try {
                return ((JRCompare)object).getCondition().getXml();
            }
            catch (Exception e) {
                throw new HopException("Error serializing Condition to XML", (Throwable)e);
            }
        }

        public Object getObject(String xml) throws HopException {
            try {
                return new JRCompare(new Condition(xml));
            }
            catch (Exception e) {
                throw new HopException("Error serializing Condition from XML", (Throwable)e);
            }
        }
    }
}

