/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p69p0.com.google.api.client.testing.util;

import java.io.IOException;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.api.client.util.BackOff;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.api.client.util.Beta;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.api.client.util.Preconditions;

@Beta
public class MockBackOff
implements BackOff {
    private long backOffMillis;
    private int maxTries = 10;
    private int numTries;

    @Override
    public void reset() throws IOException {
        this.numTries = 0;
    }

    @Override
    public long nextBackOffMillis() throws IOException {
        if (this.numTries >= this.maxTries || this.backOffMillis == -1L) {
            return -1L;
        }
        ++this.numTries;
        return this.backOffMillis;
    }

    public MockBackOff setBackOffMillis(long backOffMillis) {
        Preconditions.checkArgument(backOffMillis == -1L || backOffMillis >= 0L);
        this.backOffMillis = backOffMillis;
        return this;
    }

    public MockBackOff setMaxTries(int maxTries) {
        Preconditions.checkArgument(maxTries >= 0);
        this.maxTries = maxTries;
        return this;
    }

    public final int getMaxTries() {
        return this.maxTries;
    }

    public final int getNumberOfTries() {
        return this.numTries;
    }
}

