/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.utils;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;

public class DirectorySizeCalculator
extends SimpleFileVisitor<Path> {
    private volatile long size = 0L;

    public boolean isAcceptable(Path file) {
        return true;
    }

    @Override
    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
        if (this.isAcceptable(file)) {
            this.size += attrs.size();
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file, IOException exc) {
        return FileVisitResult.CONTINUE;
    }

    public long getAllocatedSize() {
        return this.size;
    }

    protected void resetSize() {
        this.size = 0L;
    }
}

