/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr;

import net.sf.saxon.expr.MappingFunction;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.AtomizableIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;

public final class MappingIterator
implements SequenceIterator,
AtomizableIterator {
    private SequenceIterator base;
    private MappingFunction action;
    private XPathContext context;
    private SequenceIterator results = null;
    private boolean atomizing = false;
    private Item current = null;
    private int position = 0;

    public MappingIterator(SequenceIterator sequenceIterator, MappingFunction mappingFunction, XPathContext xPathContext) {
        this.base = sequenceIterator;
        this.action = mappingFunction;
        this.context = xPathContext;
    }

    public Item next() throws XPathException {
        Item item;
        block6: {
            while (true) {
                Item item2;
                if (this.results != null) {
                    item = this.results.next();
                    if (item != null) break block6;
                    this.results = null;
                }
                if ((item2 = this.base.next()) == null) break;
                Object object = this.action.map(item2, this.context);
                if (object == null) continue;
                if (object instanceof Item) {
                    item = (Item)object;
                    this.results = null;
                } else {
                    this.results = (SequenceIterator)object;
                    if (this.atomizing && this.results instanceof AtomizableIterator) {
                        ((AtomizableIterator)this.results).setIsAtomizing(this.atomizing);
                    }
                    if ((item = this.results.next()) == null) {
                        this.results = null;
                        continue;
                    }
                }
                break block6;
                break;
            }
            this.results = null;
            this.current = null;
            this.position = -1;
            return null;
        }
        this.current = item;
        ++this.position;
        return item;
    }

    public Item current() {
        return this.current;
    }

    public int position() {
        return this.position;
    }

    public SequenceIterator getAnother() throws XPathException {
        SequenceIterator sequenceIterator = this.base.getAnother();
        XPathContext xPathContext = this.context;
        if (xPathContext != null) {
            xPathContext = xPathContext.newMinorContext();
            xPathContext.setCurrentIterator(sequenceIterator);
            xPathContext.setOrigin(this.context.getOrigin());
        }
        MappingIterator mappingIterator = new MappingIterator(sequenceIterator, this.action, xPathContext);
        mappingIterator.setIsAtomizing(this.atomizing);
        return mappingIterator;
    }

    public int getProperties() {
        return 8;
    }

    public void setIsAtomizing(boolean bl) {
        this.atomizing = bl;
    }
}

