/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.saxon.Err;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceException;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.sort.IntHashMap;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLOutputCharacter;
import net.sf.saxon.style.XSLStylesheet;
import net.sf.saxon.trans.XPathException;

public class XSLCharacterMap
extends StyleElement {
    String use;
    List characterMapElements = null;
    boolean validated = false;
    boolean redundant = false;

    public int getCharacterMapFingerprint() {
        return this.getObjectNameCode() & 0xFFFFF;
    }

    public boolean isRedundant() {
        return this.redundant;
    }

    public void prepareAttributes() throws XPathException {
        String string = null;
        this.use = null;
        AttributeCollection attributeCollection = this.getAttributeList();
        for (int i = 0; i < attributeCollection.getLength(); ++i) {
            int n = attributeCollection.getNameCode(i);
            String string2 = this.getNamePool().getClarkName(n);
            if (string2 == "name") {
                string = attributeCollection.getValue(i).trim();
                continue;
            }
            if (string2 == "use-character-maps") {
                this.use = attributeCollection.getValue(i);
                continue;
            }
            this.checkUnknownAttribute(n);
        }
        if (string == null) {
            this.reportAbsence("name");
            return;
        }
        try {
            this.setObjectNameCode(this.makeNameCode(string.trim()));
        }
        catch (NamespaceException namespaceException) {
            this.compileError(namespaceException.getMessage(), "XTSE0280");
        }
        catch (XPathException xPathException) {
            this.compileError(xPathException.getMessage());
        }
    }

    public void validate() throws XPathException {
        Item item;
        if (this.validated) {
            return;
        }
        this.checkTopLevel(null);
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((item = axisIterator.next()) != null) {
            if (item instanceof XSLOutputCharacter) continue;
            this.compileError("Only xsl:output-character is allowed within xsl:character-map", "XTSE0010");
        }
        item = this.getPrincipalStylesheet();
        XSLCharacterMap xSLCharacterMap = ((XSLStylesheet)item).getCharacterMap(this.getObjectFingerprint());
        if (xSLCharacterMap != this) {
            if (this.getPrecedence() == xSLCharacterMap.getPrecedence()) {
                this.compileError("There are two character-maps with the same name and import precedence", "XTSE1580");
            } else if (this.getPrecedence() < xSLCharacterMap.getPrecedence()) {
                this.redundant = true;
            }
        }
        if (this.use != null) {
            Object object;
            this.characterMapElements = new ArrayList(5);
            StringTokenizer stringTokenizer = new StringTokenizer(this.use);
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                try {
                    int n;
                    XSLCharacterMap xSLCharacterMap2;
                    String[] stringArray = this.getConfiguration().getNameChecker().getQNameParts((CharSequence)object);
                    String string = this.getURIForPrefix(stringArray[0], false);
                    if (string == null) {
                        this.compileError("Undeclared namespace prefix " + Err.wrap(stringArray[0]) + " in character map name", "XTSE0280");
                    }
                    if ((xSLCharacterMap2 = ((XSLStylesheet)item).getCharacterMap((n = this.getTargetNamePool().allocate(stringArray[0], string, stringArray[1])) & 0xFFFFF)) == null) {
                        this.compileError("No character-map named '" + (String)object + "' has been defined", "XTSE1590");
                        continue;
                    }
                    this.characterMapElements.add(xSLCharacterMap2);
                }
                catch (QNameException qNameException) {
                    this.compileError("Invalid character-map name. " + qNameException.getMessage(), "XTSE1590");
                }
            }
            object = this.characterMapElements.iterator();
            while (object.hasNext()) {
                ((XSLCharacterMap)object.next()).checkCircularity(this);
            }
        }
        this.validated = true;
    }

    private void checkCircularity(XSLCharacterMap xSLCharacterMap) throws XPathException {
        if (this == xSLCharacterMap) {
            this.compileError("The definition of the character map is circular", "XTSE1600");
            this.characterMapElements = null;
        } else {
            if (!this.validated) {
                return;
            }
            if (this.characterMapElements != null) {
                Iterator iterator = this.characterMapElements.iterator();
                while (iterator.hasNext()) {
                    ((XSLCharacterMap)iterator.next()).checkCircularity(xSLCharacterMap);
                }
            }
        }
    }

    public void assemble(IntHashMap intHashMap) {
        Item item;
        if (this.characterMapElements != null) {
            for (int i = 0; i < this.characterMapElements.size(); ++i) {
                item = (XSLCharacterMap)this.characterMapElements.get(i);
                ((XSLCharacterMap)item).assemble(intHashMap);
            }
        }
        AxisIterator axisIterator = this.iterateAxis((byte)3);
        while ((item = axisIterator.next()) != null) {
            XSLOutputCharacter xSLOutputCharacter = (XSLOutputCharacter)item;
            intHashMap.put(xSLOutputCharacter.getCodePoint(), xSLOutputCharacter.getReplacementString());
        }
        return;
    }

    public Expression compile(Executable executable) throws XPathException {
        return null;
    }
}

