/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.stanford.nlp.simple;

import java.lang.invoke.StringConcatFactory;
import java.util.List;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.stanford.nlp.simple.ParsedSentence;
import org.apache.hop.pipeline.transforms.stanford.nlp.simple.PennTreebankPartOfSpeech;
import org.apache.hop.pipeline.transforms.stanford.nlp.simple.StanfordSimpleNlpData;
import org.apache.hop.pipeline.transforms.stanford.nlp.simple.StanfordSimpleNlpMeta;

public class StanfordSimpleNlp
extends BaseTransform<StanfordSimpleNlpMeta, StanfordSimpleNlpData> {
    public static final int OVER_ALLOCATE_SIZE = 10;
    private static final Class<?> PKG = StanfordSimpleNlp.class;
    private final int cores = Runtime.getRuntime().availableProcessors();
    private final ForkJoinPool executor = ForkJoinPool.commonPool();
    private final AtomicInteger jobs = new AtomicInteger(0);
    private final int maxJobs = this.cores * 100;
    private final Object lock = new Object();
    private ParsedSentence.Builder sentenceBuilder;

    public StanfordSimpleNlp(TransformMeta transformMeta, StanfordSimpleNlpMeta meta, StanfordSimpleNlpData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        Object object = this.lock;
        synchronized (object) {
            while (this.jobs.get() > 0) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.setOutputDone();
    }

    public boolean processRow() throws HopException {
        block7: {
            Object[] r = this.getRow();
            if (r == null) {
                this.finish();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((StanfordSimpleNlpData)this.data).previousRowMeta = this.getInputRowMeta().clone();
                ((StanfordSimpleNlpData)this.data).NrPrevFields = ((StanfordSimpleNlpData)this.data).previousRowMeta.size();
                ((StanfordSimpleNlpData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((StanfordSimpleNlpMeta)this.meta).getFields(((StanfordSimpleNlpData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                if (Utils.isEmpty((CharSequence)((StanfordSimpleNlpMeta)this.meta).getCorpusField())) {
                    throw new HopException(BaseMessages.getString(PKG, (String)"StanfordSimpleNlp.Error.CorpusFieldMissing", (String[])new String[0]));
                }
                this.cacheIndexPositions();
                this.sentenceBuilder = ParsedSentence.Builder.parsedSentenceBuilder().includePartOfSpeech(((StanfordSimpleNlpMeta)this.meta).isIncludePartOfSpeech());
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            this.process(r);
            try {
                if (this.isRowLevel()) {
                    this.logRowlevel(BaseMessages.getString(PKG, (String)"StanfordSimpleNlp.LineNumber", (String[])new String[]{this.getLinesRead() + " : " + this.getInputRowMeta().getString(r)}));
                }
            }
            catch (Exception e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    this.logError(BaseMessages.getString(PKG, (String)"StanfordSimpleNlp.ErrorInTransformRunning", (String[])new String[0]) + e.getMessage());
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block7;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, ((StanfordSimpleNlpMeta)this.meta).getCorpusField(), "StanfordSimpleNlp001");
            }
        }
        return true;
    }

    private void process(Object[] inputRow) {
        String corpus = StringUtils.trim((String)((String)inputRow[((StanfordSimpleNlpData)this.data).indexOfCorpusField]));
        if (StringUtils.isBlank((CharSequence)corpus)) {
            return;
        }
        if (((StanfordSimpleNlpMeta)this.meta).isParallelism()) {
            this.processAsync(corpus, inputRow);
        } else {
            this.processSync(corpus, inputRow);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAsync(String corpus, Object[] inputRow) {
        Object object = this.lock;
        synchronized (object) {
            while (this.jobs.get() > this.maxJobs) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.executor.submit(() -> {
            try {
                this.processSync(corpus, inputRow);
                this.jobs.decrementAndGet();
                Object object = this.lock;
                synchronized (object) {
                    this.lock.notifyAll();
                }
            }
            catch (Exception e) {
                this.logError(e.getMessage(), e);
            }
        });
        this.jobs.incrementAndGet();
    }

    private void processSync(String corpus, Object[] inputRow) {
        List<ParsedSentence> sentences = this.sentenceBuilder.buildSentences(inputRow, corpus);
        for (ParsedSentence sentence : sentences) {
            try {
                this.processSentence(sentence);
            }
            catch (HopTransformException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void cacheIndexPositions() throws HopException {
        if (((StanfordSimpleNlpData)this.data).indexOfCorpusField < 0) {
            ((StanfordSimpleNlpData)this.data).indexOfCorpusField = ((StanfordSimpleNlpData)this.data).previousRowMeta.indexOfValue(((StanfordSimpleNlpMeta)this.meta).getCorpusField());
            if (((StanfordSimpleNlpData)this.data).indexOfCorpusField < 0) {
                throw new HopException(BaseMessages.getString(PKG, (String)"StanfordSimpleNlp.Exception.CouldnotFindField", (String[])new String[]{((StanfordSimpleNlpMeta)this.meta).getCorpusField()}));
            }
        }
        for (String string : ((StanfordSimpleNlpData)this.data).sentenceFields) {
            String string2 = ((StanfordSimpleNlpMeta)this.meta).getOutputFieldNamePrefix() + string;
            if (((StanfordSimpleNlpData)this.data).indexOfMap.getOrDefault(string2, -1) >= 0) continue;
            ((StanfordSimpleNlpData)this.data).indexOfMap.put(string2, ((StanfordSimpleNlpData)this.data).outputRowMeta.indexOfValue(string2));
            if (((StanfordSimpleNlpData)this.data).indexOfMap.getOrDefault(string2, -1) >= 0) continue;
            throw new HopException(BaseMessages.getString(PKG, (String)"DetectLanguage.Exception.CouldnotFindField", (String[])new String[]{string2}));
        }
        if (((StanfordSimpleNlpMeta)this.meta).isIncludePartOfSpeech()) {
            for (String string : ((StanfordSimpleNlpData)this.data).posFields) {
                String string3 = ((StanfordSimpleNlpMeta)this.meta).getOutputFieldNamePrefix() + string;
                if (((StanfordSimpleNlpData)this.data).indexOfMap.getOrDefault(string3, -1) >= 0) continue;
                ((StanfordSimpleNlpData)this.data).indexOfMap.put(string3, ((StanfordSimpleNlpData)this.data).outputRowMeta.indexOfValue(string3));
                if (((StanfordSimpleNlpData)this.data).indexOfMap.getOrDefault(string3, -1) >= 0) continue;
                throw new HopException(BaseMessages.getString(PKG, (String)"DetectLanguage.Exception.CouldnotFindField", (String[])new String[]{string3}));
            }
            for (PennTreebankPartOfSpeech pennTreebankPartOfSpeech : PennTreebankPartOfSpeech.values()) {
                String field = ((StanfordSimpleNlpMeta)this.meta).getOutputFieldNamePrefix() + "penn_treebank_pos_" + pennTreebankPartOfSpeech.name();
                if (((StanfordSimpleNlpData)this.data).indexOfMap.getOrDefault(field, -1) >= 0) continue;
                ((StanfordSimpleNlpData)this.data).indexOfMap.put(field, ((StanfordSimpleNlpData)this.data).outputRowMeta.indexOfValue(field));
                if (((StanfordSimpleNlpData)this.data).indexOfMap.getOrDefault(field, -1) >= 0) continue;
                throw new HopException(BaseMessages.getString(PKG, (String)"DetectLanguage.Exception.CouldnotFindField", (String[])new String[]{field}));
            }
        }
    }

    private void processSentence(ParsedSentence sentence) throws HopTransformException {
        Object[] outputRow = new Object[sentence.getInputRow().length + ((StanfordSimpleNlpData)this.data).indexOfMap.size() + 10];
        System.arraycopy(sentence.getInputRow(), 0, outputRow, 0, sentence.getInputRow().length);
        outputRow[((StanfordSimpleNlpData)this.data).indexOfMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001text"}, (String)((StanfordSimpleNlpMeta)this.meta).getOutputFieldNamePrefix())).intValue()] = sentence.getSentenceText();
        outputRow[((StanfordSimpleNlpData)this.data).indexOfMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001index"}, (String)((StanfordSimpleNlpMeta)this.meta).getOutputFieldNamePrefix())).intValue()] = sentence.getIndex();
        outputRow[((StanfordSimpleNlpData)this.data).indexOfMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001index_start"}, (String)((StanfordSimpleNlpMeta)this.meta).getOutputFieldNamePrefix())).intValue()] = sentence.getIndexBegin();
        outputRow[((StanfordSimpleNlpData)this.data).indexOfMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001index_end"}, (String)((StanfordSimpleNlpMeta)this.meta).getOutputFieldNamePrefix())).intValue()] = sentence.getIndexEnd();
        outputRow[((StanfordSimpleNlpData)this.data).indexOfMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001character_count"}, (String)((StanfordSimpleNlpMeta)this.meta).getOutputFieldNamePrefix())).intValue()] = sentence.getCharacterCount();
        outputRow[((StanfordSimpleNlpData)this.data).indexOfMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001word_count"}, (String)((StanfordSimpleNlpMeta)this.meta).getOutputFieldNamePrefix())).intValue()] = sentence.getWordCount();
        if (((StanfordSimpleNlpMeta)this.meta).isIncludePartOfSpeech()) {
            outputRow[((StanfordSimpleNlpData)this.data).indexOfMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001pos_tagged"}, (String)((StanfordSimpleNlpMeta)this.meta).getOutputFieldNamePrefix())).intValue()] = StringUtils.join(sentence.getSentencePosTags(), (String)",");
            outputRow[((StanfordSimpleNlpData)this.data).indexOfMap.get((Object)StringConcatFactory.makeConcatWithConstants("makeConcatWithConstants", new Object[]{"\u0001pos_tags"}, (String)((StanfordSimpleNlpMeta)this.meta).getOutputFieldNamePrefix())).intValue()] = sentence.getSentenceTextPosTagged();
            for (PennTreebankPartOfSpeech tag : PennTreebankPartOfSpeech.values()) {
                String field = ((StanfordSimpleNlpMeta)this.meta).getOutputFieldNamePrefix() + "penn_treebank_pos_" + tag.name();
                outputRow[((StanfordSimpleNlpData)this.data).indexOfMap.get((Object)field).intValue()] = (long)sentence.getSentencePosBag().getCount((Object)tag.name());
            }
        }
        this.putRow(((StanfordSimpleNlpData)this.data).outputRowMeta, outputRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putRow(IRowMeta rowMeta, Object[] row) throws HopTransformException {
        StanfordSimpleNlp stanfordSimpleNlp = this;
        synchronized (stanfordSimpleNlp) {
            super.putRow(rowMeta, row);
        }
    }
}

