/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationOverlay;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationTransformation;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.Declaration;
import org.jboss.jandex.DotName;
import org.jboss.jandex.EquivalenceKey;
import org.jboss.jandex.IndexView;

class AnnotationOverlayImpl
implements AnnotationOverlay {
    private static final Set<AnnotationInstance> SENTINEL = Collections.unmodifiableSet(new HashSet());
    final IndexView index;
    final boolean compatibleMode;
    final boolean runtimeAnnotationsOnly;
    final boolean inheritedAnnotations;
    final List<AnnotationTransformation> transformations;
    final Map<EquivalenceKey, Set<AnnotationInstance>> overlay = new ConcurrentHashMap<EquivalenceKey, Set<AnnotationInstance>>();

    AnnotationOverlayImpl(IndexView index, boolean compatibleMode, boolean runtimeAnnotationsOnly, boolean inheritedAnnotations, Collection<AnnotationTransformation> annotationTransformations) {
        this.index = index;
        this.compatibleMode = compatibleMode;
        this.runtimeAnnotationsOnly = runtimeAnnotationsOnly;
        this.inheritedAnnotations = inheritedAnnotations;
        if (!compatibleMode) {
            for (AnnotationTransformation transformation : annotationTransformations) {
                if (!transformation.requiresCompatibleMode()) continue;
                throw new IllegalStateException("Compatible mode required by " + transformation);
            }
        }
        ArrayList<AnnotationTransformation> transformations = new ArrayList<AnnotationTransformation>(annotationTransformations);
        transformations.sort(new Comparator<AnnotationTransformation>(){

            @Override
            public int compare(AnnotationTransformation o1, AnnotationTransformation o2) {
                return Integer.compare(o2.priority(), o1.priority());
            }
        });
        this.transformations = transformations;
    }

    @Override
    public final IndexView index() {
        return this.index;
    }

    @Override
    public final boolean hasAnnotation(Declaration declaration, DotName name) {
        if (this.compatibleMode && declaration.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            throw new UnsupportedOperationException();
        }
        Set<AnnotationInstance> annotations = this.getAnnotationsFor(declaration);
        for (AnnotationInstance annotation : annotations) {
            if (!annotation.name().equals(name)) continue;
            return true;
        }
        if (this.inheritedAnnotations && declaration.kind() == AnnotationTarget.Kind.CLASS) {
            ClassInfo clazz = this.index.getClassByName(declaration.asClass().superName());
            while (clazz != null && !DotName.OBJECT_NAME.equals(clazz.name())) {
                for (AnnotationInstance annotation : this.getAnnotationsFor(clazz)) {
                    ClassInfo annotationClass = this.index.getClassByName(annotation.name());
                    if (annotationClass == null || !annotationClass.hasDeclaredAnnotation(DotName.INHERITED_NAME) || !annotation.name().equals(name)) continue;
                    return true;
                }
                clazz = this.index.getClassByName(clazz.superName());
            }
        }
        return false;
    }

    @Override
    public final boolean hasAnyAnnotation(Declaration declaration, Set<DotName> names) {
        if (this.compatibleMode && declaration.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            throw new UnsupportedOperationException();
        }
        Set<AnnotationInstance> annotations = this.getAnnotationsFor(declaration);
        for (AnnotationInstance annotation : annotations) {
            for (DotName name : names) {
                if (!annotation.name().equals(name)) continue;
                return true;
            }
        }
        if (this.inheritedAnnotations && declaration.kind() == AnnotationTarget.Kind.CLASS) {
            ClassInfo clazz = this.index.getClassByName(declaration.asClass().superName());
            while (clazz != null && !DotName.OBJECT_NAME.equals(clazz.name())) {
                for (AnnotationInstance annotation : this.getAnnotationsFor(clazz)) {
                    ClassInfo annotationClass = this.index.getClassByName(annotation.name());
                    if (annotationClass == null || !annotationClass.hasDeclaredAnnotation(DotName.INHERITED_NAME)) continue;
                    for (DotName name : names) {
                        if (!annotation.name().equals(name)) continue;
                        return true;
                    }
                }
                clazz = this.index.getClassByName(clazz.superName());
            }
        }
        return false;
    }

    @Override
    public final AnnotationInstance annotation(Declaration declaration, DotName name) {
        if (this.compatibleMode && declaration.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            throw new UnsupportedOperationException();
        }
        Set<AnnotationInstance> annotations = this.getAnnotationsFor(declaration);
        for (AnnotationInstance annotation : annotations) {
            if (!annotation.name().equals(name)) continue;
            return annotation;
        }
        if (this.inheritedAnnotations && declaration.kind() == AnnotationTarget.Kind.CLASS) {
            ClassInfo clazz = this.index.getClassByName(declaration.asClass().superName());
            while (clazz != null && !DotName.OBJECT_NAME.equals(clazz.name())) {
                for (AnnotationInstance annotation : this.getAnnotationsFor(clazz)) {
                    ClassInfo annotationClass = this.index.getClassByName(annotation.name());
                    if (annotationClass == null || !annotationClass.hasDeclaredAnnotation(DotName.INHERITED_NAME) || !annotation.name().equals(name)) continue;
                    return annotation;
                }
                clazz = this.index.getClassByName(clazz.superName());
            }
        }
        return null;
    }

    @Override
    public final Collection<AnnotationInstance> annotationsWithRepeatable(Declaration declaration, DotName name) {
        Object repeatable;
        if (this.compatibleMode && declaration.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            throw new UnsupportedOperationException();
        }
        DotName containerName = null;
        ClassInfo annotationClass = this.index.getClassByName(name);
        if (annotationClass != null && (repeatable = annotationClass.declaredAnnotation(DotName.REPEATABLE_NAME)) != null) {
            containerName = ((AnnotationInstance)repeatable).value().asClass().name();
        }
        ArrayList<AnnotationInstance> result = new ArrayList<AnnotationInstance>();
        for (AnnotationInstance annotation : this.getAnnotationsFor(declaration)) {
            AnnotationInstance[] nestedAnnotations;
            if (annotation.name().equals(name)) {
                result.add(annotation);
                continue;
            }
            if (!annotation.name().equals(containerName)) continue;
            for (AnnotationInstance nestedAnnotation : nestedAnnotations = annotation.value().asNestedArray()) {
                result.add(AnnotationInstance.create(nestedAnnotation, annotation.target()));
            }
        }
        if (this.inheritedAnnotations && declaration.kind() == AnnotationTarget.Kind.CLASS) {
            ClassInfo clazz = this.index.getClassByName(declaration.asClass().superName());
            while (result.isEmpty() && clazz != null && !DotName.OBJECT_NAME.equals(clazz.name())) {
                for (AnnotationInstance annotation : this.getAnnotationsFor(clazz)) {
                    AnnotationInstance[] nestedAnnotations;
                    ClassInfo annotationClass2 = this.index.getClassByName(annotation.name());
                    if (annotationClass2 == null || !annotationClass2.hasDeclaredAnnotation(DotName.INHERITED_NAME)) continue;
                    if (annotation.name().equals(name)) {
                        result.add(annotation);
                        continue;
                    }
                    if (!annotation.name().equals(containerName)) continue;
                    for (AnnotationInstance nestedAnnotation : nestedAnnotations = annotation.value().asNestedArray()) {
                        result.add(AnnotationInstance.create(nestedAnnotation, annotation.target()));
                    }
                }
                clazz = this.index.getClassByName(clazz.superName());
            }
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public final Collection<AnnotationInstance> annotations(Declaration declaration) {
        if (this.compatibleMode && declaration.kind() == AnnotationTarget.Kind.METHOD_PARAMETER) {
            throw new UnsupportedOperationException();
        }
        Collection<AnnotationInstance> result = this.getAnnotationsFor(declaration);
        if (this.inheritedAnnotations && declaration.kind() == AnnotationTarget.Kind.CLASS) {
            result = new ArrayList<AnnotationInstance>(result);
            ClassInfo clazz = this.index.getClassByName(declaration.asClass().superName());
            while (clazz != null && !DotName.OBJECT_NAME.equals(clazz.name())) {
                for (AnnotationInstance annotation : this.getAnnotationsFor(clazz)) {
                    ClassInfo annotationClass = this.index.getClassByName(annotation.name());
                    if (annotationClass == null || !annotationClass.hasDeclaredAnnotation(DotName.INHERITED_NAME) || !result.stream().noneMatch(it -> it.name().equals(annotation.name()))) continue;
                    result.add(annotation);
                }
                clazz = this.index.getClassByName(clazz.superName());
            }
        }
        return Collections.unmodifiableCollection(result);
    }

    Set<AnnotationInstance> getAnnotationsFor(Declaration declaration) {
        EquivalenceKey.DeclarationEquivalenceKey key = EquivalenceKey.of(declaration);
        Set<AnnotationInstance> annotations = this.overlay.computeIfAbsent(key, ignored -> {
            Set<AnnotationInstance> original = this.getOriginalAnnotations(declaration);
            TransformationContextImpl transformationContext = new TransformationContextImpl(declaration, original);
            for (AnnotationTransformation transformation : this.transformations) {
                if (!transformation.supports(declaration.kind())) continue;
                transformation.apply(transformationContext);
            }
            Set result = transformationContext.annotations;
            return original.equals(result) ? SENTINEL : Collections.unmodifiableSet(result);
        });
        if (annotations == SENTINEL) {
            annotations = this.getOriginalAnnotations(declaration);
        }
        return annotations;
    }

    final Set<AnnotationInstance> getOriginalAnnotations(Declaration declaration) {
        HashSet<AnnotationInstance> result = new HashSet<AnnotationInstance>();
        if (this.compatibleMode && declaration.kind() == AnnotationTarget.Kind.METHOD) {
            for (AnnotationInstance annotation : declaration.asMethod().annotations()) {
                if (annotation.target() == null || annotation.target().kind() != AnnotationTarget.Kind.METHOD && annotation.target().kind() != AnnotationTarget.Kind.METHOD_PARAMETER || this.runtimeAnnotationsOnly && !annotation.runtimeVisible()) continue;
                result.add(annotation);
            }
        } else {
            for (AnnotationInstance annotation : declaration.declaredAnnotations()) {
                if (this.runtimeAnnotationsOnly && !annotation.runtimeVisible()) continue;
                result.add(annotation);
            }
        }
        return result;
    }

    private static final class TransformationContextImpl
    implements AnnotationTransformation.TransformationContext {
        private final Declaration declaration;
        private final Set<AnnotationInstance> annotations;

        TransformationContextImpl(Declaration declaration, Collection<AnnotationInstance> annotations) {
            this.declaration = declaration;
            this.annotations = new HashSet<AnnotationInstance>(annotations);
        }

        @Override
        public Declaration declaration() {
            return this.declaration;
        }

        @Override
        public Collection<AnnotationInstance> annotations() {
            return this.annotations;
        }

        @Override
        public boolean hasAnnotation(Class<? extends Annotation> annotationClass) {
            Objects.requireNonNull(annotationClass);
            return this.hasAnnotation(DotName.createSimple(annotationClass));
        }

        @Override
        public boolean hasAnnotation(DotName annotationName) {
            Objects.requireNonNull(annotationName);
            for (AnnotationInstance annotation : this.annotations) {
                if (!annotation.name().equals(annotationName)) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean hasAnnotation(Predicate<AnnotationInstance> predicate) {
            Objects.requireNonNull(predicate);
            for (AnnotationInstance annotation : this.annotations) {
                if (!predicate.test(annotation)) continue;
                return true;
            }
            return false;
        }

        @Override
        public void add(Class<? extends Annotation> annotationClass) {
            Objects.requireNonNull(annotationClass);
            this.annotations.add(AnnotationInstance.builder(annotationClass).buildWithTarget(this.declaration));
        }

        @Override
        public void add(AnnotationInstance annotation) {
            if (annotation.target() == null) {
                annotation = AnnotationInstance.create(annotation, this.declaration);
            }
            this.annotations.add(Objects.requireNonNull(annotation));
        }

        @Override
        public void addAll(AnnotationInstance ... annotations) {
            Objects.requireNonNull(annotations);
            for (int i = 0; i < annotations.length; ++i) {
                if (annotations[i].target() != null) continue;
                annotations[i] = AnnotationInstance.create(annotations[i], this.declaration);
            }
            Collections.addAll(this.annotations, annotations);
        }

        @Override
        public void addAll(Collection<AnnotationInstance> annotations) {
            Objects.requireNonNull(annotations);
            if (annotations.stream().anyMatch(it -> it.target() == null)) {
                ArrayList<AnnotationInstance> fixed = new ArrayList<AnnotationInstance>();
                for (AnnotationInstance annotation : annotations) {
                    if (annotation.target() == null) {
                        fixed.add(AnnotationInstance.create(annotation, this.declaration));
                        continue;
                    }
                    fixed.add(annotation);
                }
                annotations = fixed;
            }
            this.annotations.addAll(annotations);
        }

        @Override
        public void remove(Predicate<AnnotationInstance> predicate) {
            this.annotations.removeIf(Objects.requireNonNull(predicate));
        }

        @Override
        public void removeAll() {
            this.annotations.clear();
        }
    }
}

