/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileImpl;
import com.ibm.as400.access.AS400FileRecordDescriptionImplRemote;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DDMRecordCache;
import com.ibm.as400.access.DDMS38OpenFeedback;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.KeyedFile;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.VariableLengthFieldDescription;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.Enumeration;
import java.util.Vector;

abstract class AS400FileImplBase
implements AS400FileImpl,
Cloneable {
    boolean isNative_ = false;
    boolean discardReplys_ = false;
    ConverterImplRemote converter_;
    static final byte DATA_DTA_DTARCD = 0;
    static final byte DATA_NODTA_DTARCD = 1;
    static final byte OPER_GET = 1;
    static final byte OPER_GETD = 2;
    static final byte OPER_GETK = 3;
    static final byte OPER_PUTDR = 4;
    static final byte OPER_PUT = 5;
    static final byte OPER_UPDATE = 7;
    static final byte OPER_DELETE = 8;
    static final byte OPER_FEOD = 9;
    static final byte SHR_READ_NORM = 0;
    static final byte SHR_READ_NORM_RLS = 2;
    static final byte SHR_UPD_NORM = 3;
    static final byte SHR_READ_NOPOS = 16;
    static final byte SHR_READ_NOPOS_RLS = 18;
    static final byte SHR_UPD_NOPOS = 19;
    static final byte SHR_UPD_NORM_NW = 35;
    static final byte SHR_UPD_NOPOS_NW = 51;
    static final byte TYPE_GET_FIRST = 1;
    static final byte TYPE_GET_LAST = 2;
    static final byte TYPE_GET_NEXT = 3;
    static final byte TYPE_GET_PREV = 4;
    static final byte TYPE_GET_SAME = 33;
    static final byte TYPE_GETD_ABSRRN = 8;
    private static final int WDMHLIB = 72;
    private static final int WDMHMBR = 73;
    DDMS38OpenFeedback openFeedback_;
    static final String STR16 = "                ";
    static final String STR18 = "                  ";
    static final String STR44 = "                                            ";
    Vector explicitLocksObtained_ = new Vector(6);
    static Vector commitmentControlSystems_ = new Vector();
    static boolean nativeCommitmentControlStarted_ = false;
    AS400ImplRemote system_ = null;
    String name_ = null;
    RecordFormat recordFormat_ = null;
    String library_ = null;
    String file_ = null;
    String member_ = null;
    DDMRecordCache cache_ = new DDMRecordCache();
    boolean cacheRecords_ = false;
    RecordFormat[] rfCache_ = null;
    int commitLockLevel_ = -1;
    int blockingFactor_;
    boolean readNoUpdate_ = false;
    boolean ssp_ = false;
    int openType_ = -1;
    byte[] recordFormatCTLLName_ = null;
    private String recordFormatName_ = "";
    private static final int EQUAL = 1;
    private static final int LESS_THAN = 2;
    private static final int GREATER_THAN = 3;
    private static final int UNKNOWN = 4;
    private static final boolean CHECK_LENGTHS = true;

    AS400FileImplBase() {
    }

    @Override
    public void doIt(String methodName, Class[] classes, Object[] objects) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        try {
            AS400FileImplBase.invoke(this, methodName, classes, objects);
        }
        catch (InvocationTargetException e) {
            throw AS400FileImplBase.rethrow(e);
        }
        catch (Exception e2) {
            Trace.log(2, e2.toString(), (Throwable)e2);
            throw new InternalErrorException(4, (Throwable)e2);
        }
    }

    public static InternalErrorException rethrow(InvocationTargetException e) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Throwable e2 = e.getTargetException();
        if (e2 instanceof AS400Exception) {
            throw (AS400Exception)e2;
        }
        if (e2 instanceof InterruptedException) {
            throw (InterruptedException)e2;
        }
        if (e2 instanceof AS400SecurityException) {
            throw (AS400SecurityException)e2;
        }
        if (e2 instanceof IOException) {
            throw (IOException)e2;
        }
        if (e2 instanceof RuntimeException) {
            throw (RuntimeException)e2;
        }
        if (e2 instanceof Error) {
            throw (Error)e2;
        }
        return new InternalErrorException(10, e2);
    }

    @Override
    public void doItNoExceptions(String methodName, Class[] classes, Object[] objects) {
        try {
            AS400FileImplBase.invoke(this, methodName, classes, objects);
        }
        catch (Exception e2) {
            Trace.log(2, e2.toString(), (Throwable)e2);
            throw new InternalErrorException(4, (Throwable)e2);
        }
    }

    @Override
    public Record doItRecord(String methodName, Class[] classes, Object[] objects) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        try {
            return (Record)AS400FileImplBase.invoke(this, methodName, classes, objects);
        }
        catch (InvocationTargetException e) {
            throw AS400FileImplBase.rethrow(e);
        }
        catch (Exception e2) {
            Trace.log(2, e2.toString(), (Throwable)e2);
            throw new InternalErrorException(4, (Throwable)e2);
        }
    }

    @Override
    public Record[] doItRecordArray(String methodName, Class[] classes, Object[] objects) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        try {
            return (Record[])AS400FileImplBase.invoke(this, methodName, classes, objects);
        }
        catch (InvocationTargetException e) {
            throw AS400FileImplBase.rethrow(e);
        }
        catch (Exception e2) {
            Trace.log(2, e2);
            throw new InternalErrorException(4, (Throwable)e2);
        }
    }

    @Override
    public RecordFormat doItRecordFormat(String methodName, Class[] classes, Object[] objects) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        try {
            return (RecordFormat)AS400FileImplBase.invoke(this, methodName, classes, objects);
        }
        catch (InvocationTargetException e) {
            throw AS400FileImplBase.rethrow(e);
        }
        catch (Exception e2) {
            Trace.log(2, e2);
            throw new InternalErrorException(4, (Throwable)e2);
        }
    }

    @Override
    public int doItInt(String methodName) {
        try {
            return (Integer)AS400FileImplBase.invoke(this, methodName, new Class[0], new Object[0]);
        }
        catch (Exception e) {
            Trace.log(2, e);
            throw new InternalErrorException(4, (Throwable)e);
        }
    }

    @Override
    public boolean doItBoolean(String methodName) {
        try {
            return (Boolean)AS400FileImplBase.invoke(this, methodName, new Class[0], new Object[0]);
        }
        catch (Exception e) {
            Trace.log(2, e);
            throw new InternalErrorException(4, (Throwable)e);
        }
    }

    @Override
    public boolean doItBoolean(String methodName, Class[] classes, Object[] objects) {
        try {
            return (Boolean)AS400FileImplBase.invoke(this, methodName, classes, objects);
        }
        catch (Exception e) {
            Trace.log(2, e);
            throw new InternalErrorException(4, (Throwable)e);
        }
    }

    static Object invoke(Object object, String methodName, Class[] argumentClasses, Object[] arguments) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = null;
        Class<?> clazz = object.getClass();
        NoSuchMethodException e = null;
        while (clazz != null && method == null) {
            try {
                method = clazz.getMethod(methodName, argumentClasses);
            }
            catch (NoSuchMethodException e1) {
                try {
                    method = clazz.getDeclaredMethod(methodName, argumentClasses);
                }
                catch (NoSuchMethodException e2) {
                    e = e2;
                    clazz = clazz.getSuperclass();
                }
            }
        }
        if (method == null) {
            throw e;
        }
        return method.invoke(object, arguments);
    }

    public boolean isReadNoUpdate() {
        return this.readNoUpdate_;
    }

    public void addPhysicalFileMember(String name, String textDescription) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        StringBuilder cmd = new StringBuilder("QSYS/ADDPFM FILE(");
        cmd.append(this.library_);
        cmd.append("/");
        cmd.append(this.file_);
        cmd.append(") MBR(");
        cmd.append(name);
        cmd.append(")  TEXT(");
        if (textDescription == null) {
            cmd.append("*BLANK");
            cmd.append(")");
        } else if (textDescription.length() == 0 || textDescription.equalsIgnoreCase("*BLANK")) {
            cmd.append("*BLANK");
            cmd.append(")");
        } else {
            cmd.append("'");
            cmd.append(textDescription);
            cmd.append("')");
        }
        AS400Message[] msgs = this.execute(cmd.toString());
        if (msgs.length <= 0 || !msgs[0].getID().equals("CPC7305")) {
            throw new AS400Exception(msgs);
        }
    }

    private static final int compareArrays(byte[] array1, byte[] array2, boolean checkLengths) {
        if (checkLengths) {
            if (array1.length < array2.length) {
                return 2;
            }
            if (array1.length > array2.length) {
                return 3;
            }
        }
        for (int k = 0; k < array1.length; ++k) {
            if (array1[k] < array2[k]) {
                return 2;
            }
            if (array1[k] <= array2[k]) continue;
            return 3;
        }
        return 1;
    }

    private int compareKeys(Object[] key, Object[] recKey) {
        if (key.length > recKey.length) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(4, "compareKeys: Search key has too many fields.");
            }
            return 4;
        }
        int match = 1;
        for (int j = 0; j < key.length && match == 1; ++j) {
            Object recordKey;
            Object searchKey;
            if (key[j] instanceof byte[] && recKey[j] instanceof byte[]) {
                searchKey = (byte[])key[j];
                recordKey = (byte[])recKey[j];
                match = AS400FileImplBase.compareArrays((byte[])searchKey, (byte[])recordKey, true);
                continue;
            }
            if (this.recordFormat_.getKeyFieldDescription(j) instanceof VariableLengthFieldDescription) {
                int recordKeyLength;
                searchKey = (String)key[j];
                recordKey = (String)recKey[j];
                int searchKeyLength = ((String)searchKey).length();
                if (searchKeyLength < (recordKeyLength = ((String)recordKey).length())) {
                    StringBuilder buf = new StringBuilder((String)searchKey);
                    for (int i = searchKeyLength; i < recordKeyLength; ++i) {
                        buf.append(" ");
                    }
                    searchKey = buf.toString();
                } else if (searchKeyLength > recordKeyLength) {
                    searchKey = ((String)searchKey).substring(0, recordKeyLength);
                }
                FieldDescription fd = this.recordFormat_.getKeyFieldDescription(j);
                byte[] searchKeyAsBytes = fd.getDataType().toBytes(searchKey);
                byte[] recordKeyAsBytes = fd.getDataType().toBytes(recordKey);
                match = AS400FileImplBase.compareArrays(searchKeyAsBytes, recordKeyAsBytes, true);
                continue;
            }
            if (key[j] instanceof BigDecimal && recKey[j] instanceof BigDecimal) {
                searchKey = (BigDecimal)key[j];
                recordKey = (BigDecimal)recKey[j];
                int res = ((BigDecimal)searchKey).compareTo((BigDecimal)recordKey);
                if (res > 0) {
                    match = 3;
                    continue;
                }
                if (res >= 0) continue;
                match = 2;
                continue;
            }
            if (key[j].equals(recKey[j])) continue;
            match = 4;
        }
        return match;
    }

    private int compareKeys(byte[] key, byte[] recKey, int numberOfKeyFields) {
        if (key.length > recKey.length) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(4, "compareKeys: Search key is too long.");
            }
            return 4;
        }
        if (numberOfKeyFields < 1 || numberOfKeyFields > this.recordFormat_.getNumberOfKeyFields()) {
            throw new ExtendedIllegalArgumentException("numberOfKeyFields", 2);
        }
        int keyByteLength = 0;
        FieldDescription[] fd = this.recordFormat_.getKeyFieldDescriptions();
        for (int i = 0; i < numberOfKeyFields; ++i) {
            keyByteLength += fd[i].getDataType().getByteLength();
            if (!(fd[i] instanceof VariableLengthFieldDescription) || !((VariableLengthFieldDescription)((Object)fd[i])).isVariableLength()) continue;
            keyByteLength += 2;
        }
        if (key.length != keyByteLength) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(4, "compareKeys: Search key byte length is not valid.");
            }
            return 4;
        }
        return AS400FileImplBase.compareArrays(key, recKey, false);
    }

    public int getBlockingFactor() {
        return this.blockingFactor_;
    }

    @Override
    public int[] getExplicitLocks() {
        int[] locks = new int[this.explicitLocksObtained_.size()];
        for (int i = 0; i < locks.length; ++i) {
            locks[i] = (Integer)this.explicitLocksObtained_.elementAt(i);
        }
        return locks;
    }

    public int getOpenType() {
        return this.openType_;
    }

    public void close() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.cacheRecords_ = false;
        this.cache_.setIsEmpty();
        this.blockingFactor_ = 0;
        this.openType_ = -1;
        this.commitLockLevel_ = this.isCommitmentControlStarted() ? 3 : -1;
    }

    public void setAll(AS400Impl system, String pathName, RecordFormat rf, boolean readNoUpdate, boolean isKeyed, boolean ssp) throws IOException {
        this.setSystem(system);
        this.setPath(pathName);
        this.setRecordFormat(rf);
        this.setReadNoUpdate(readNoUpdate);
        this.setSSPFile(ssp);
        this.setConverter();
    }

    public abstract void commit() throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void commit(AS400Impl system) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isCommitmentControlStarted(system)) {
            this.setSystem(system);
            this.setConverter();
            this.commit();
        }
    }

    public void setConverter() throws IOException {
        this.converter_ = ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_);
    }

    public void setPath(String name) {
        QSYSObjectPathName ifs = new QSYSObjectPathName(name);
        if (!ifs.getObjectType().equals("FILE") && !ifs.getObjectType().equals("MBR")) {
            throw new IllegalPathNameException(name, 1);
        }
        this.library_ = ifs.getLibraryName();
        this.file_ = ifs.getObjectName();
        this.member_ = ifs.getObjectType().equals("FILE") ? "*FIRST" : (ifs.getMemberName().equalsIgnoreCase("*FILE") ? this.file_ : ifs.getMemberName());
        this.name_ = name;
        this.rfCache_ = null;
    }

    public void setReadNoUpdate(boolean readNoUpdate) {
        this.readNoUpdate_ = readNoUpdate;
    }

    public RecordFormat setRecordFormat(int rf) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.rfCache_ == null) {
            AS400FileRecordDescriptionImplRemote desc = new AS400FileRecordDescriptionImplRemote();
            desc.setPath(this.name_);
            desc.setSystem(this.system_);
            this.rfCache_ = desc.retrieveRecordFormat();
        }
        if (this.rfCache_.length <= rf) {
            throw new ExtendedIllegalArgumentException("recordFormat (" + String.valueOf(rf) + ") too large", 4);
        }
        return this.rfCache_[rf];
    }

    public RecordFormat setRecordFormat(String rf) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.rfCache_ == null) {
            AS400FileRecordDescriptionImplRemote desc = new AS400FileRecordDescriptionImplRemote();
            desc.setPath(this.name_);
            desc.setSystem(this.system_);
            this.rfCache_ = desc.retrieveRecordFormat();
        }
        RecordFormat toSet = null;
        for (int i = 0; i < this.rfCache_.length; ++i) {
            if (!this.rfCache_[i].getName().equals(rf)) continue;
            toSet = this.rfCache_[i];
        }
        if (toSet == null) {
            throw new ExtendedIllegalArgumentException("recordFormat (" + rf + ") not found", 5);
        }
        return toSet;
    }

    public void setRecordFormat(RecordFormat rf) throws IOException {
        if (rf != null) {
            this.recordFormat_ = rf;
            if (this.converter_ != null) {
                this.setConverter();
            }
            for (int i = 0; i < this.recordFormat_.getNumberOfFields(); ++i) {
                AS400DataType dt = this.recordFormat_.getFieldDescription((int)i).dataType_;
                if (dt.getInstanceType() != 9) continue;
                int textCcsid = ((AS400Text)dt).getCcsid();
                if (textCcsid != 65535) {
                    ((AS400Text)dt).setConverter(ConverterImplRemote.getConverter(textCcsid, this.system_));
                    continue;
                }
                ((AS400Text)dt).setConverter(this.converter_);
            }
        }
    }

    public void setSSPFile(boolean treatAsSSP) {
        this.ssp_ = treatAsSSP;
    }

    public void setSystem(AS400Impl system) {
        this.system_ = (AS400ImplRemote)system;
        this.rfCache_ = null;
    }

    public byte[] createUFCB(int openType, int bf, String access, boolean userBuffering) throws IOException {
        int i;
        int userBufferingAndODPSharingOff;
        if (this.converter_ == null) {
            this.setConverter();
        }
        byte[] ufcb = null;
        boolean isCommitmentControlStarted = this.isCommitmentControlStarted();
        boolean isSSPviaDDM = this.ssp_;
        ufcb = isSSPviaDDM ? (access.equalsIgnoreCase("SEQ") && openType == 2 ? new byte[isCommitmentControlStarted ? 93 : 90] : new byte[isCommitmentControlStarted ? 96 : 93]) : (access.equalsIgnoreCase("SEQ") && openType == 2 ? new byte[isCommitmentControlStarted ? 109 : 106] : new byte[isCommitmentControlStarted ? 112 : 109]);
        int n = userBufferingAndODPSharingOff = userBuffering ? 4099 : 4098;
        int openOptions = openType == 0 ? 0x20 | userBufferingAndODPSharingOff : (openType == 1 ? (isSSPviaDDM ? 0x2C | userBufferingAndODPSharingOff : 0x3C | userBufferingAndODPSharingOff) : (isSSPviaDDM ? 0x18 | userBufferingAndODPSharingOff : 0x10 | userBufferingAndODPSharingOff));
        this.converter_.stringToByteArray(this.file_, ufcb, 0);
        for (i = this.file_.length(); i < 10; ++i) {
            ufcb[i] = 64;
        }
        BinaryConverter.unsignedShortToByteArray(72, ufcb, 10);
        this.converter_.stringToByteArray(this.library_, ufcb, 12);
        for (i = this.library_.length(); i < 10; ++i) {
            ufcb[i + 12] = 64;
        }
        BinaryConverter.unsignedShortToByteArray(73, ufcb, 22);
        this.converter_.stringToByteArray(this.member_, ufcb, 24);
        for (i = this.member_.length(); i < 10; ++i) {
            ufcb[i + 24] = 64;
        }
        BinaryConverter.unsignedShortToByteArray(openOptions, ufcb, 46);
        ufcb[48] = -16;
        ufcb[49] = -15;
        ufcb[50] = -16;
        ufcb[51] = -16;
        ufcb[56] = 32;
        ufcb[60] = isSSPviaDDM && openType == 2 ? 0 : 2;
        int offset = 80;
        BinaryConverter.unsignedShortToByteArray(6, ufcb, offset);
        ufcb[offset + 2] = 0;
        offset += 3;
        if (!access.equalsIgnoreCase("SEQ") || openType != 2) {
            BinaryConverter.unsignedShortToByteArray(60, ufcb, offset);
            ufcb[offset + 2] = access.equalsIgnoreCase("SEQ") ? -128 : (openType == 2 ? -128 : 0);
            offset += 3;
        }
        if (isCommitmentControlStarted) {
            BinaryConverter.unsignedShortToByteArray(59, ufcb, offset);
            switch (this.commitLockLevel_) {
                case 3: {
                    ufcb[offset + 2] = 0;
                    break;
                }
                case 4: {
                    ufcb[offset + 2] = -128;
                    break;
                }
                case 1: {
                    ufcb[offset + 2] = -126;
                    break;
                }
                case 2: {
                    ufcb[offset + 2] = -122;
                    break;
                }
                case 0: {
                    ufcb[offset + 2] = -121;
                }
            }
            offset += 3;
        }
        BinaryConverter.unsignedShortToByteArray(58, ufcb, offset);
        if ((access.equalsIgnoreCase("SEQ") || access.equalsIgnoreCase("KEY")) && openType != 1) {
            ufcb[offset + 2] = -64;
            BinaryConverter.unsignedShortToByteArray(bf, ufcb, offset + 3);
        } else {
            ufcb[offset + 2] = 64;
            BinaryConverter.unsignedShortToByteArray(bf, ufcb, offset + 3);
        }
        offset += 5;
        if (!isSSPviaDDM) {
            BinaryConverter.unsignedShortToByteArray(9, ufcb, offset);
            BinaryConverter.unsignedShortToByteArray(1, ufcb, offset + 2);
            BinaryConverter.unsignedShortToByteArray(1, ufcb, offset + 4);
            String rfName = this.recordFormat_.getName();
            if (rfName.length() > 10) {
                rfName = rfName.substring(0, 10);
            }
            this.converter_.stringToByteArray(rfName, ufcb, offset + 6);
            for (int i2 = rfName.length(); i2 < 10 && i2 + offset + 6 < ufcb.length; ++i2) {
                ufcb[i2 + offset + 6] = 64;
            }
            offset += 16;
        }
        BinaryConverter.unsignedShortToByteArray(Short.MAX_VALUE, ufcb, offset);
        return ufcb;
    }

    public abstract void deleteCurrentRecord() throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void deleteMember() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        AS400Message[] msgs = this.execute("QSYS/RMVM FILE(" + this.library_ + "/" + this.file_ + ") MBR(" + this.member_ + ")");
        if (msgs.length > 0 && msgs[0].getID() != null) {
            if (!msgs[0].getID().equals("CPC7309")) {
                throw new AS400Exception(msgs);
            }
        } else {
            Trace.log(2, "No messages from server");
            throw new InternalErrorException(6);
        }
    }

    public void discardReplies() {
        this.discardReplys_ = true;
    }

    public void endCommitmentControl() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.endCommitmentControl(this.system_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCommitmentControl(AS400Impl system) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Vector vector = commitmentControlSystems_;
        synchronized (vector) {
            if (this.isNative_ && nativeCommitmentControlStarted_ || commitmentControlSystems_.contains(system)) {
                this.setSystem(system);
                this.setConverter();
                AS400Message[] msgs = this.execute("QSYS/ENDCMTCTL");
                if (msgs.length > 0 && msgs[0].getID() != null && !msgs[0].getID().equals("CPI8351")) {
                    throw new AS400Exception(msgs);
                }
                if (this.isNative_) {
                    nativeCommitmentControlStarted_ = false;
                } else {
                    commitmentControlSystems_.removeElement(this.system_);
                }
            }
        }
    }

    public void startCommitmentControl(int commitLockLevel) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.startCommitmentControl(this.system_, commitLockLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCommitmentControl(AS400Impl system, int commitLockLevel) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Vector vector = commitmentControlSystems_;
        synchronized (vector) {
            if (this.isNative_ && nativeCommitmentControlStarted_ || commitmentControlSystems_.contains(system)) {
                throw new ExtendedIllegalStateException(1);
            }
            this.setSystem(system);
            this.setConverter();
            StringBuilder cmd = new StringBuilder("QSYS/STRCMTCTL LCKLVL(*");
            switch (commitLockLevel) {
                case 1: {
                    cmd.append("CHG)");
                    break;
                }
                case 2: {
                    cmd.append("CS)");
                    break;
                }
                case 0: {
                    cmd.append("ALL)");
                    break;
                }
                default: {
                    throw new ExtendedIllegalArgumentException("commitLockLevel", 2);
                }
            }
            AS400Message[] msgs = this.execute(cmd.toString());
            if (msgs.length > 0 && msgs[0].getID() != null && !msgs[0].getID().equals("CPI8351")) {
                throw new AS400Exception(msgs);
            }
            if (this.isNative_) {
                nativeCommitmentControlStarted_ = true;
            } else if (!commitmentControlSystems_.contains(this.system_)) {
                commitmentControlSystems_.addElement(this.system_);
            }
        }
    }

    public synchronized void resetState() {
        this.cacheRecords_ = false;
        this.cache_.setIsEmpty();
        this.blockingFactor_ = 0;
        this.openType_ = -1;
        this.commitLockLevel_ = -1;
    }

    public void releaseExplicitLocks() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.explicitLocksObtained_.size() > 0) {
            StringBuilder cmd = new StringBuilder("QSYS/DLCOBJ OBJ(");
            Enumeration e = this.explicitLocksObtained_.elements();
            while (e.hasMoreElements()) {
                cmd.append("(");
                cmd.append(this.library_);
                cmd.append("/");
                cmd.append(this.file_);
                cmd.append(" *FILE ");
                int lockType = (Integer)e.nextElement();
                switch (lockType) {
                    case 1: {
                        cmd.append("*SHRNUP ");
                        break;
                    }
                    case 0: {
                        cmd.append("*SHRRD ");
                        break;
                    }
                    case 4: 
                    case 5: {
                        cmd.append("*EXCL ");
                        break;
                    }
                    case 3: {
                        cmd.append("*EXCLRD ");
                        break;
                    }
                    case 2: {
                        cmd.append("*SHRUPD ");
                        break;
                    }
                    default: {
                        Trace.log(2, "Unrecognized lock type: " + lockType);
                        throw new InternalErrorException(6, lockType);
                    }
                }
                cmd.append(this.member_);
                cmd.append(") ");
            }
            cmd.append(")");
            AS400Message[] msgs = this.execute(cmd.toString());
            if (msgs.length > 0 && msgs[0].getID() != null) {
                throw new AS400Exception(msgs);
            }
            this.explicitLocksObtained_.removeAllElements();
        }
    }

    @Override
    public abstract AS400Message[] execute(String var1) throws AS400SecurityException, InterruptedException, IOException;

    public int getCommitLockLevel() {
        return this.isCommitmentControlStarted() ? this.commitLockLevel_ : -1;
    }

    public boolean isCommitmentControlStarted() {
        if (this.isNative_) {
            return nativeCommitmentControlStarted_;
        }
        return commitmentControlSystems_.contains(this.system_);
    }

    public boolean isCommitmentControlStarted(AS400Impl system) {
        if (this.isNative_) {
            return nativeCommitmentControlStarted_;
        }
        return commitmentControlSystems_.contains(system);
    }

    public void create(int recordLength, String fileType, String textDescription) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        StringBuilder cmd = new StringBuilder("QSYS/CRTPF FILE(");
        cmd.append(this.library_);
        cmd.append("/");
        cmd.append(this.file_);
        cmd.append(") RCDLEN(");
        cmd.append(recordLength);
        cmd.append(") MBR(");
        cmd.append(this.member_);
        cmd.append(") TEXT(");
        if (textDescription == null) {
            cmd.append("*BLANK");
        } else if (textDescription.length() == 0 || textDescription.equalsIgnoreCase("*BLANK")) {
            cmd.append("*BLANK");
        } else {
            cmd.append("'");
            cmd.append(textDescription);
            cmd.append("'");
        }
        cmd.append(") FILETYPE(");
        cmd.append(fileType);
        cmd.append(")");
        AS400Message[] msgs = this.execute(cmd.toString());
        if (msgs.length <= 0 || !msgs[0].getID().equals("CPC7301")) {
            throw new AS400Exception(msgs);
        }
    }

    public void create(String ddsSourceFile, String textDescription) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        QSYSObjectPathName ifs = new QSYSObjectPathName(ddsSourceFile);
        if (!ifs.getObjectType().equals("FILE") && !ifs.getObjectType().equals("MBR")) {
            throw new IllegalPathNameException(ddsSourceFile, 1);
        }
        StringBuilder cmd = new StringBuilder("QSYS/CRTPF FILE(");
        cmd.append(this.library_);
        cmd.append("/");
        cmd.append(this.file_);
        cmd.append(") SRCFILE(");
        cmd.append(ifs.getLibraryName());
        cmd.append("/");
        cmd.append(ifs.getObjectName());
        cmd.append(") SRCMBR(");
        cmd.append(ifs.getMemberName());
        cmd.append(") MBR(");
        if (this.member_.equals("*FIRST")) {
            if (Trace.traceOn_) {
                Trace.log(1, "Setting MBR to *FILE.");
            }
            cmd.append("*FILE");
        } else {
            cmd.append(this.member_);
        }
        cmd.append(") TEXT(");
        if (textDescription == null) {
            cmd.append("*BLANK");
            cmd.append(")");
        } else if (textDescription.length() == 0 || textDescription.equalsIgnoreCase("*BLANK")) {
            cmd.append("*BLANK");
            cmd.append(")");
        } else if (textDescription.equalsIgnoreCase("*SRCMBRTXT")) {
            cmd.append(textDescription);
            cmd.append(")");
        } else {
            cmd.append("'");
            cmd.append(textDescription);
            cmd.append("')");
        }
        AS400Message[] msgs = this.execute(cmd.toString());
        if (msgs.length <= 0 || !msgs[0].getID().equals("CPC7301")) {
            throw new AS400Exception(msgs);
        }
    }

    public abstract void createDDSSourceFile(RecordFormat var1, String var2, String var3, String var4, String var5, boolean var6, String var7, String var8) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void delete() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        AS400Message[] msgs = this.execute("QSYS/DLTF FILE(" + this.library_ + "/" + this.file_ + ")");
        if (msgs.length > 0) {
            if (msgs[0].getID() != null && !msgs[0].getID().equals("CPC2191")) {
                throw new AS400Exception(msgs);
            }
        } else {
            Trace.log(2, "No messages from server");
            throw new InternalErrorException(6);
        }
    }

    public void lock(int lockToObtain) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Integer l = lockToObtain;
        if (!this.explicitLocksObtained_.contains(l)) {
            StringBuilder cmd = new StringBuilder("QSYS/ALCOBJ OBJ((");
            cmd.append(this.library_);
            cmd.append("/");
            cmd.append(this.file_);
            cmd.append(" *FILE ");
            switch (lockToObtain) {
                case 1: {
                    cmd.append("*SHRNUP ");
                    break;
                }
                case 0: {
                    cmd.append("*SHRRD ");
                    break;
                }
                case 4: 
                case 5: {
                    cmd.append("*EXCL ");
                    break;
                }
                case 3: {
                    cmd.append("*EXCLRD ");
                    break;
                }
                case 2: {
                    cmd.append("*SHRUPD ");
                    break;
                }
                default: {
                    throw new InternalErrorException(6, lockToObtain);
                }
            }
            cmd.append(this.member_);
            cmd.append("))");
            AS400Message[] msgs = this.execute(cmd.toString());
            if (msgs.length > 0 && msgs[0].getID() != null) {
                throw new AS400Exception(msgs);
            }
            this.explicitLocksObtained_.addElement(l);
        }
    }

    public abstract DDMS38OpenFeedback openFile(int var1, int var2, String var3) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public String[] openFile2(int openType, int blockingFactor, int commitLockLevel, String access) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        return this.openFile2(openType, blockingFactor, commitLockLevel, access.equals("key"));
    }

    @Override
    public String[] openFile2(int openType, int blockingFactor, int commitLockLevel, boolean access) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.commitLockLevel_ = this.isCommitmentControlStarted() ? commitLockLevel : -1;
        this.blockingFactor_ = blockingFactor;
        boolean bl = this.cacheRecords_ = this.blockingFactor_ > 1;
        if (!this.recordFormatName_.equals(this.recordFormat_.getName())) {
            this.recordFormatName_ = this.recordFormat_.getName();
            StringBuilder recordName = new StringBuilder(this.recordFormat_.getName());
            while (recordName.length() < 10) {
                recordName.append(' ');
            }
            ConverterImplRemote c = ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_);
            this.recordFormatCTLLName_ = c.stringToByteArray(recordName.toString());
        }
        DDMS38OpenFeedback openFeedback = this.openFile(openType, this.blockingFactor_, access ? "key" : "seq");
        this.openType_ = openType;
        String[] toReturn = new String[2];
        if (this.library_.charAt(0) == '*') {
            toReturn[0] = this.library_ = openFeedback.getLibraryName().trim();
        }
        if (this.member_.equalsIgnoreCase("*FIRST") || this.member_.equalsIgnoreCase("*LAST")) {
            toReturn[1] = this.member_ = openFeedback.getMemberName().trim();
        }
        return toReturn;
    }

    public void positionCursor(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (!this.cache_.setPosition(recordNumber)) {
                this.positionCursorToIndex(recordNumber);
            }
        } else {
            this.positionCursorToIndex(recordNumber);
        }
    }

    public void positionCursorLong(long recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (!this.cache_.setPositionLong(recordNumber)) {
                this.positionCursorToIndexLong(recordNumber);
            }
        } else {
            this.positionCursorToIndexLong(recordNumber);
        }
    }

    public void positionCursor(Object[] key, int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(key, searchType);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
    }

    public void positionCursorLong(Object[] key, int searchType) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKeyLong(key, searchType);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
    }

    public void positionCursor(byte[] key, int searchType, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(key, searchType, numberOfKeyFields);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
    }

    public void positionCursorLong(byte[] key, int searchType, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKeyLong(key, searchType, numberOfKeyFields);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
    }

    public void positionCursorAfter(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(key, KeyedFile.TYPE_TABLE[0]);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        this.positionCursorToNext();
    }

    public void positionCursorAfterLong(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKeyLong(key, KeyedFile.TYPE_TABLE[0]);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        this.positionCursorToNextLong();
    }

    public void positionCursorAfter(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(key, KeyedFile.TYPE_TABLE[0], numberOfKeyFields);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        this.positionCursorToNext();
    }

    public void positionCursorAfterLong(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKeyLong(key, KeyedFile.TYPE_TABLE[0], numberOfKeyFields);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        this.positionCursorToNextLong();
    }

    public abstract void positionCursorAfterLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record[] positionCursorAt(int var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record[] positionCursorAtLong(int var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void positionCursorBefore(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.setPosition(recordNumber)) {
                if (!this.cache_.isBeginningOfCache()) {
                    this.cache_.setPositionPrevious();
                } else {
                    this.positionCursorToIndex(recordNumber);
                    this.positionCursorToPrevious();
                }
            } else {
                this.positionCursorToIndex(recordNumber);
                this.positionCursorToPrevious();
            }
        } else {
            this.positionCursorToIndex(recordNumber);
            this.positionCursorToPrevious();
        }
    }

    public void positionCursorBefore(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(key, KeyedFile.TYPE_TABLE[0]);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        try {
            this.positionCursorToPrevious();
        }
        catch (AS400Exception e) {
            if (Trace.traceOn_) {
                Trace.log(4, "KeyedFile - Possible attempt to position by key before first record. Manually positioning cursor.", (Throwable)e);
            }
            if (e.getAS400Message().getID().equalsIgnoreCase("CPF5001")) {
                this.positionCursorBeforeFirst();
            }
            throw e;
        }
    }

    public void positionCursorBeforeLong(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKeyLong(key, KeyedFile.TYPE_TABLE[0]);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        try {
            this.positionCursorToPreviousLong();
        }
        catch (AS400Exception e) {
            if (Trace.traceOn_) {
                Trace.log(4, "KeyedFile - Possible attempt to position by key before first record. Manually positioning cursor.", (Throwable)e);
            }
            if (e.getAS400Message().getID().equalsIgnoreCase("CPF5001")) {
                this.positionCursorBeforeFirst();
            }
            throw e;
        }
    }

    public void positionCursorBefore(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(key, KeyedFile.TYPE_TABLE[0], numberOfKeyFields);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        try {
            this.positionCursorToPrevious();
        }
        catch (AS400Exception e) {
            if (Trace.traceOn_) {
                Trace.log(4, "KeyedFile - Possible attempt to position by key before first record. Manually positioning cursor.", (Throwable)e);
            }
            if (e.getAS400Message().getID().equalsIgnoreCase("CPF5001")) {
                this.positionCursorBeforeFirst();
            }
            throw e;
        }
    }

    public void positionCursorBeforeLong(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKeyLong(key, KeyedFile.TYPE_TABLE[0], numberOfKeyFields);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        try {
            this.positionCursorToPreviousLong();
        }
        catch (AS400Exception e) {
            if (Trace.traceOn_) {
                Trace.log(4, "KeyedFile - Possible attempt to position by key before first record. Manually positioning cursor.", (Throwable)e);
            }
            if (e.getAS400Message().getID().equalsIgnoreCase("CPF5001")) {
                this.positionCursorBeforeFirst();
            }
            throw e;
        }
    }

    public abstract void positionCursorBeforeFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void positionCursorToFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && this.cache_.containsFirstRecord()) {
            this.cache_.setPositionFirst();
        } else {
            if (this.cacheRecords_) {
                this.cache_.setIsEmpty();
            }
            this.positionCursorAt(1);
        }
    }

    public void positionCursorToFirstLong() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && this.cache_.containsFirstRecord()) {
            this.cache_.setPositionFirst();
        } else {
            if (this.cacheRecords_) {
                this.cache_.setIsEmpty();
            }
            this.positionCursorAtLong(1);
        }
    }

    public abstract Record positionCursorToIndex(int var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record positionCursorToIndexLong(long var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record positionCursorToKey(Object[] var1, int var2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record positionCursorToKeyLong(Object[] var1, int var2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record positionCursorToKey(byte[] var1, int var2, int var3) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record positionCursorToKeyLong(byte[] var1, int var2, int var3) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void positionCursorToLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && this.cache_.containsLastRecord()) {
            this.cache_.setPositionLast();
        } else {
            if (this.cacheRecords_) {
                this.cache_.setIsEmpty();
            }
            this.positionCursorAt(2);
        }
    }

    public void positionCursorToLastLong() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && this.cache_.containsLastRecord()) {
            this.cache_.setPositionLast();
        } else {
            if (this.cacheRecords_) {
                this.cache_.setIsEmpty();
            }
            this.positionCursorAtLong(2);
        }
    }

    public void positionCursorToNext() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.isEmpty() || this.cache_.isEndOfCache() && this.cache_.currentDirection_ == 0) {
                this.cache_.refresh(this.positionCursorAt(3), 0, false, false);
            } else if (this.cache_.isEndOfCache() && this.cache_.currentDirection_ != 0) {
                this.refreshCache(null, 0, false, false);
            } else {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "positionCursorToNext: positioning in cache.");
                }
                this.cache_.setPositionNext();
            }
        } else {
            this.positionCursorAt(3);
        }
    }

    public void positionCursorToNextLong() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.isEmpty() || this.cache_.isEndOfCache() && this.cache_.currentDirection_ == 0) {
                this.cache_.refresh(this.positionCursorAtLong(3), 0, false, false);
            } else if (this.cache_.isEndOfCache() && this.cache_.currentDirection_ != 0) {
                this.refreshCacheLong(null, 0, false, false);
            } else {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "positionCursorToNext: positioning in cache.");
                }
                this.cache_.setPositionNext();
            }
        } else {
            this.positionCursorAtLong(3);
        }
    }

    public void positionCursorToPrevious() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.isEmpty() || this.cache_.isBeginningOfCache() && this.cache_.currentDirection_ == 1) {
                this.cache_.refresh(this.positionCursorAt(4), 1, false, false);
            } else if (this.cache_.isBeginningOfCache() && this.cache_.currentDirection_ != 1) {
                this.refreshCache(null, 1, false, false);
            } else {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "positionCursorToPrev: positioning in cache.");
                }
                this.cache_.setPositionPrevious();
            }
        } else {
            this.positionCursorAt(4);
        }
    }

    public void positionCursorToPreviousLong() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.isEmpty() || this.cache_.isBeginningOfCache() && this.cache_.currentDirection_ == 1) {
                this.cache_.refresh(this.positionCursorAt(4), 1, false, false);
            } else if (this.cache_.isBeginningOfCache() && this.cache_.currentDirection_ != 1) {
                this.refreshCacheLong(null, 1, false, false);
            } else {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "positionCursorToPrev: positioning in cache.");
                }
                this.cache_.setPositionPrevious();
            }
        } else {
            this.positionCursorAtLong(4);
        }
    }

    public Record read() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        if (this.cacheRecords_) {
            r = this.cache_.getCurrent();
        }
        if (r == null) {
            r = this.readRecord(33);
        }
        return r;
    }

    public Record readLong() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        if (this.cacheRecords_) {
            r = this.cache_.getCurrent();
        }
        if (r == null) {
            r = this.readRecordLong(33);
        }
        return r;
    }

    public Record read(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = this.cache_.getRecord(recordNumber);
        if (r == null) {
            try {
                r = this.positionCursorToIndex(recordNumber);
                this.refreshCache(null, 0, false, false);
                this.cache_.add(r, false);
                this.cache_.setPositionFirst();
            }
            catch (AS400Exception e) {
                String id = e.getAS400Message().getID();
                if (id.equals("CPF5001") || id.equals("CPF5006")) {
                    return null;
                }
                throw e;
            }
        }
        return r;
    }

    public abstract Record read(Object[] var1, int var2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record readLong(Object[] var1, int var2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record read(byte[] var1, int var2, int var3) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record readLong(byte[] var1, int var2, int var3) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public Record readAfter(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.setPosition(recordNumber)) {
                if (!this.cache_.isEndOfCache()) {
                    return this.cache_.getNext();
                }
                this.positionCursorToIndex(recordNumber);
                return this.readNext();
            }
            this.cache_.setIsEmpty();
            this.positionCursorToIndex(recordNumber);
            return this.readNext();
        }
        this.positionCursorToIndex(recordNumber);
        return this.readNext();
    }

    public Record readAfter(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(key, KeyedFile.TYPE_TABLE[0]);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return this.readNext();
    }

    public Record readAfterLong(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKeyLong(key, KeyedFile.TYPE_TABLE[0]);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return this.readNextLong();
    }

    public Record readAfter(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(key, KeyedFile.TYPE_TABLE[0], numberOfKeyFields);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return this.readNext();
    }

    public Record readAfterLong(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKeyLong(key, KeyedFile.TYPE_TABLE[0], numberOfKeyFields);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return this.readNextLong();
    }

    public abstract Record[] readAll(String var1, int var2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record[] readAllLong(String var1, int var2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public Record readBefore(int recordNumber) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.setPosition(recordNumber)) {
                if (!this.cache_.isBeginningOfCache()) {
                    return this.cache_.getPrevious();
                }
                this.positionCursorToIndex(recordNumber);
                return this.readPrevious();
            }
            this.cache_.setIsEmpty();
            this.positionCursorToIndex(recordNumber);
            return this.readPrevious();
        }
        this.positionCursorToIndex(recordNumber);
        return this.readPrevious();
    }

    public Record readBefore(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(key, KeyedFile.TYPE_TABLE[0]);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return this.readPrevious();
    }

    public Record readBeforeLong(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKeyLong(key, KeyedFile.TYPE_TABLE[0]);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return this.readPreviousLong();
    }

    public Record readBefore(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(key, KeyedFile.TYPE_TABLE[0], numberOfKeyFields);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return this.readPrevious();
    }

    public Record readBeforeLong(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKeyLong(key, KeyedFile.TYPE_TABLE[0], numberOfKeyFields);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return this.readPreviousLong();
    }

    public Record readFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.containsFirstRecord()) {
                return this.cache_.getFirst();
            }
            this.cache_.setIsEmpty();
        }
        return this.readRecord(1);
    }

    public Record readLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.containsLastRecord()) {
                return this.cache_.getLast();
            }
            this.cache_.setIsEmpty();
        }
        return this.readRecord(2);
    }

    public Record readLastLong() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.containsLastRecord()) {
                return this.cache_.getLast();
            }
            this.cache_.setIsEmpty();
        }
        return this.readRecordLong(2);
    }

    public Record readNext() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        if (this.cacheRecords_) {
            r = this.cache_.getNext();
            if (r == null) {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "AS400FileImplBase.readNext(): cache_.getNext() returned null.");
                }
                this.refreshCache(null, 0, false, false);
                return this.cache_.getCurrent();
            }
            return r;
        }
        return this.readRecord(3);
    }

    public Record readNextLong() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        if (this.cacheRecords_) {
            r = this.cache_.getNext();
            if (r == null) {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "AS400FileImplBase.readNext(): cache_.getNext() returned null.");
                }
                this.refreshCacheLong(null, 0, false, false);
                return this.cache_.getCurrent();
            }
            return r;
        }
        return this.readRecordLong(3);
    }

    public Record readNextEqual() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && !this.cache_.isEmpty()) {
            Record r = null;
            Record current = this.cache_.getCurrent();
            if (current != null) {
                Object[] key = current.getKeyFields();
                try {
                    r = this.readNext();
                    int match = 4;
                    if (r != null) {
                        match = this.compareKeys(key, r.getKeyFields());
                    }
                    while (r != null && (match == 3 || match == 4)) {
                        r = this.readNext();
                        if (r == null) continue;
                        match = this.compareKeys(key, r.getKeyFields());
                    }
                    if (match != 1) {
                        r = null;
                    }
                }
                catch (AS400Exception e) {
                    if (e.getAS400Message().getID().equals("CPF5025")) {
                        return null;
                    }
                    throw e;
                }
                return r;
            }
        }
        Object[] key = this.recordFormat_.getNewRecord().getKeyFields();
        return this.read(key, 14);
    }

    public Record readNextEqualLong() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && !this.cache_.isEmpty()) {
            Record r = null;
            Record current = this.cache_.getCurrent();
            if (current != null) {
                Object[] key = current.getKeyFields();
                try {
                    r = this.readNextLong();
                    int match = 4;
                    if (r != null) {
                        match = this.compareKeys(key, r.getKeyFields());
                    }
                    while (r != null && (match == 3 || match == 4)) {
                        r = this.readNextLong();
                        if (r == null) continue;
                        match = this.compareKeys(key, r.getKeyFields());
                    }
                    if (match != 1) {
                        r = null;
                    }
                }
                catch (AS400Exception e) {
                    if (e.getAS400Message().getID().equals("CPF5025")) {
                        return null;
                    }
                    throw e;
                }
                return r;
            }
        }
        Object[] key = this.recordFormat_.getNewRecord().getKeyFields();
        return this.readLong(key, 14);
    }

    public Record readNextEqual(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        try {
            r = this.readNext();
            int match = 4;
            if (r != null) {
                match = this.compareKeys(key, r.getKeyFields());
            }
            while (r != null && (match == 3 || match == 4)) {
                r = this.readNext();
                if (r == null) continue;
                match = this.compareKeys(key, r.getKeyFields());
            }
            if (match != 1) {
                r = null;
            }
        }
        catch (AS400Exception e) {
            if (e.getAS400Message().getID().equals("CPF5025")) {
                return null;
            }
            throw e;
        }
        return r;
    }

    public Record readNextEqualLong(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        try {
            r = this.readNextLong();
            int match = 4;
            if (r != null) {
                match = this.compareKeys(key, r.getKeyFields());
            }
            while (r != null && (match == 3 || match == 4)) {
                r = this.readNextLong();
                if (r == null) continue;
                match = this.compareKeys(key, r.getKeyFields());
            }
            if (match != 1) {
                r = null;
            }
        }
        catch (AS400Exception e) {
            if (e.getAS400Message().getID().equals("CPF5025")) {
                return null;
            }
            throw e;
        }
        return r;
    }

    public Record readNextEqual(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        try {
            r = this.readNext();
            int match = 4;
            if (r != null) {
                match = this.compareKeys(key, r.getKeyFieldsAsBytes(), numberOfKeyFields);
            }
            while (r != null && (match == 3 || match == 4)) {
                r = this.readNext();
                if (r == null) continue;
                match = this.compareKeys(key, r.getKeyFieldsAsBytes(), numberOfKeyFields);
            }
            if (match != 1) {
                r = null;
            }
        }
        catch (AS400Exception e) {
            if (e.getAS400Message().getID().equals("CPF5025")) {
                return null;
            }
            throw e;
        }
        return r;
    }

    public Record readNextEqualLong(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        try {
            r = this.readNextLong();
            int match = 4;
            if (r != null) {
                match = this.compareKeys(key, r.getKeyFieldsAsBytes(), numberOfKeyFields);
            }
            while (r != null && (match == 3 || match == 4)) {
                r = this.readNextLong();
                if (r == null) continue;
                match = this.compareKeys(key, r.getKeyFieldsAsBytes(), numberOfKeyFields);
            }
            if (match != 1) {
                r = null;
            }
        }
        catch (AS400Exception e) {
            if (e.getAS400Message().getID().equals("CPF5025")) {
                return null;
            }
            throw e;
        }
        return r;
    }

    public Record readPrevious() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        if (this.cacheRecords_) {
            r = this.cache_.getPrevious();
            if (r == null) {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "AS400FileImplBase.readPrevious(): cache returned null.");
                }
                this.refreshCache(null, 1, false, false);
                return this.cache_.getCurrent();
            }
            return r;
        }
        return this.readRecord(4);
    }

    public Record readPreviousLong() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        if (this.cacheRecords_) {
            r = this.cache_.getPrevious();
            if (r == null) {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "AS400FileImplBase.readPrevious(): cache returned null.");
                }
                this.refreshCacheLong(null, 1, false, false);
                return this.cache_.getCurrent();
            }
            return r;
        }
        return this.readRecordLong(4);
    }

    public Record readPreviousEqual() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record current;
        if (this.cacheRecords_ && !this.cache_.isEmpty() && (current = this.cache_.getCurrent()) != null) {
            Record r;
            Object[] key = current.getKeyFields();
            try {
                r = this.readPrevious();
                int match = 4;
                if (r != null) {
                    match = this.compareKeys(key, r.getKeyFields());
                }
                while (r != null && (match == 2 || match == 4)) {
                    r = this.readPrevious();
                    if (r == null) continue;
                    match = this.compareKeys(key, r.getKeyFields());
                }
                if (match != 1) {
                    r = null;
                }
            }
            catch (AS400Exception e) {
                if (e.getAS400Message().getID().equals("CPF5025")) {
                    return null;
                }
                throw e;
            }
            return r;
        }
        Object[] key = this.recordFormat_.getNewRecord().getKeyFields();
        return this.read(key, 15);
    }

    public Record readPreviousEqualLong() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record current;
        if (this.cacheRecords_ && !this.cache_.isEmpty() && (current = this.cache_.getCurrent()) != null) {
            Record r;
            Object[] key = current.getKeyFields();
            try {
                r = this.readPreviousLong();
                int match = 4;
                if (r != null) {
                    match = this.compareKeys(key, r.getKeyFields());
                }
                while (r != null && (match == 2 || match == 4)) {
                    r = this.readPreviousLong();
                    if (r == null) continue;
                    match = this.compareKeys(key, r.getKeyFields());
                }
                if (match != 1) {
                    r = null;
                }
            }
            catch (AS400Exception e) {
                if (e.getAS400Message().getID().equals("CPF5025")) {
                    return null;
                }
                throw e;
            }
            return r;
        }
        Object[] key = this.recordFormat_.getNewRecord().getKeyFields();
        return this.readLong(key, 15);
    }

    public Record readPreviousEqual(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        try {
            r = this.readPrevious();
            int match = 4;
            if (r != null) {
                match = this.compareKeys(key, r.getKeyFields());
            }
            while (r != null && (match == 2 || match == 4)) {
                r = this.readPrevious();
                if (r == null) continue;
                match = this.compareKeys(key, r.getKeyFields());
            }
            if (match != 1) {
                r = null;
            }
        }
        catch (AS400Exception e) {
            if (e.getAS400Message().getID().equals("CPF5025")) {
                return null;
            }
            throw e;
        }
        return r;
    }

    public Record readPreviousEqualLong(Object[] key) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        try {
            r = this.readPreviousLong();
            int match = 4;
            if (r != null) {
                match = this.compareKeys(key, r.getKeyFields());
            }
            while (r != null && (match == 2 || match == 4)) {
                r = this.readPreviousLong();
                if (r == null) continue;
                match = this.compareKeys(key, r.getKeyFields());
            }
            if (match != 1) {
                r = null;
            }
        }
        catch (AS400Exception e) {
            if (e.getAS400Message().getID().equals("CPF5025")) {
                return null;
            }
            throw e;
        }
        return r;
    }

    public Record readPreviousEqual(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        try {
            r = this.readPrevious();
            int match = 4;
            if (r != null) {
                match = this.compareKeys(key, r.getKeyFieldsAsBytes(), numberOfKeyFields);
            }
            while (r != null && (match == 2 || match == 4)) {
                r = this.readPrevious();
                if (r == null) continue;
                match = this.compareKeys(key, r.getKeyFieldsAsBytes(), numberOfKeyFields);
            }
            if (match != 1) {
                r = null;
            }
        }
        catch (AS400Exception e) {
            if (e.getAS400Message().getID().equals("CPF5025")) {
                return null;
            }
            throw e;
        }
        return r;
    }

    public Record readPreviousEqualLong(byte[] key, int numberOfKeyFields) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record r = null;
        try {
            r = this.readPreviousLong();
            int match = 4;
            if (r != null) {
                match = this.compareKeys(key, r.getKeyFieldsAsBytes(), numberOfKeyFields);
            }
            while (r != null && (match == 2 || match == 4)) {
                r = this.readPreviousLong();
                if (r == null) continue;
                match = this.compareKeys(key, r.getKeyFieldsAsBytes(), numberOfKeyFields);
            }
            if (match != 1) {
                r = null;
            }
        }
        catch (AS400Exception e) {
            if (e.getAS400Message().getID().equals("CPF5025")) {
                return null;
            }
            throw e;
        }
        return r;
    }

    public abstract Record readRecord(int var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record readRecordLong(int var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record[] readRecords(int var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record[] readRecordsLong(int var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void refreshCacheLong(Record[] records, int direction, boolean containsFirstRecord, boolean containsLastRecord) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (Trace.isTraceOn()) {
            Trace.log(3, "AS400FileImplBase.refreshCache: refreshing cache," + String.valueOf(direction));
        }
        Object r = null;
        if (this.cache_.currentDirection_ == direction || this.cache_.isEmpty()) {
            this.cache_.setIsEmpty();
            if (records == null) {
                records = this.readRecordsLong(direction);
            }
            if (Trace.isTraceOn()) {
                Trace.log(3, "AS400FileImplBase.refreshCache(): cursors in synch.");
            }
            this.cache_.refresh(records, direction, containsFirstRecord, containsLastRecord);
        } else {
            long recordNumber;
            long l = recordNumber = this.cache_.getCurrent() == null ? this.cache_.getNext().getRecordNumberLong() : this.cache_.getCurrent().getRecordNumberLong();
            if (Trace.isTraceOn()) {
                Trace.log(3, "AS400FileImplBase.refreshCache(): cursors not in synch.");
            }
            this.cache_.setIsEmpty();
            this.positionCursorLong(recordNumber);
            if (records == null) {
                records = this.readRecordsLong(direction);
            }
            this.cache_.refresh(records, direction, containsFirstRecord, containsLastRecord);
        }
    }

    public void refreshCache(Record[] records, int direction, boolean containsFirstRecord, boolean containsLastRecord) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (Trace.isTraceOn()) {
            Trace.log(3, "AS400FileImplBase.refreshCache: refreshing cache," + String.valueOf(direction));
        }
        Object r = null;
        if (this.cache_.currentDirection_ == direction || this.cache_.isEmpty()) {
            this.cache_.setIsEmpty();
            if (records == null) {
                records = this.readRecords(direction);
            }
            if (Trace.isTraceOn()) {
                Trace.log(3, "AS400FileImplBase.refreshCache(): cursors in synch.");
            }
            this.cache_.refresh(records, direction, containsFirstRecord, containsLastRecord);
        } else {
            int recordNumber;
            int n = recordNumber = this.cache_.getCurrent() == null ? this.cache_.getNext().getRecordNumber() : this.cache_.getCurrent().getRecordNumber();
            if (Trace.isTraceOn()) {
                Trace.log(3, "AS400FileImplBase.refreshCache(): cursors not in synch.");
            }
            this.cache_.setIsEmpty();
            this.positionCursor(recordNumber);
            if (records == null) {
                records = this.readRecords(direction);
            }
            this.cache_.refresh(records, direction, containsFirstRecord, containsLastRecord);
        }
    }

    public void refreshRecordCache() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            this.positionCursorBeforeFirst();
            this.cache_.currentDirection_ = 0;
            this.refreshCache(null, 0, true, false);
        }
    }

    public void refreshRecordCacheLong() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            this.positionCursorBeforeFirst();
            this.cache_.currentDirection_ = 0;
            this.refreshCacheLong(null, 0, true, false);
        }
    }

    public abstract void rollback() throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void rollback(AS400Impl system) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isCommitmentControlStarted(system)) {
            this.setSystem(system);
            this.setConverter();
            this.rollback();
        }
    }

    public abstract void update(Record var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract void write(Record[] var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;
}

