/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConvTable;
import com.ibm.as400.access.DBDataStreamException;
import java.math.BigDecimal;

class DBReplySQLCA {
    private static final String copyright = "Copyright (C) 1997-2001 International Business Machines Corporation and others.";
    private byte[] data_;
    private int offset_;
    private int length_;
    private static final int[] locationFromOffset_ = new int[]{96, 100, 104, 108, 112, 116};

    public DBReplySQLCA(byte[] data, int offset, int length) {
        this.data_ = data;
        this.offset_ = offset;
        this.length_ = length;
    }

    public final int getErrd(int requestedErrd) throws DBDataStreamException {
        if (this.length_ <= 6) {
            return 0;
        }
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + locationFromOffset_[requestedErrd - 1]);
    }

    public final String getErrmc(ConvTable converter) throws DBDataStreamException {
        if (this.length_ <= 6) {
            return "";
        }
        short errml = BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 16);
        return converter.byteArrayToString(this.data_, this.offset_ + 18, errml);
    }

    public final String getErrp(ConvTable converter) {
        int infoLen = 8;
        if (this.length_ <= this.offset_ + 88) {
            return "";
        }
        if (this.length_ < this.offset_ + 88 + infoLen) {
            infoLen = this.length_ - this.offset_ - 88;
        }
        return converter.byteArrayToString(this.data_, this.offset_ + 88, infoLen);
    }

    public final String getErrmc(int substitutionVariable, ConvTable converter) throws DBDataStreamException {
        short currentLength;
        if (this.length_ <= 6) {
            return "";
        }
        int errml = BinaryConverter.byteArrayToShort(this.data_, this.offset_ + 16);
        int currentVariable = 1;
        int i = this.offset_ + 18;
        for (int j = 0; currentVariable < substitutionVariable && j < errml; j += currentLength) {
            ++currentVariable;
            currentLength = (short)(BinaryConverter.byteArrayToShort(this.data_, i) + 2);
            i += currentLength;
        }
        currentLength = BinaryConverter.byteArrayToShort(this.data_, i);
        return converter.byteArrayToString(this.data_, i + 2, currentLength);
    }

    public final boolean getEyecatcherBit54() throws DBDataStreamException {
        if (this.length_ <= 6) {
            return false;
        }
        byte b = this.data_[this.offset_ + 6];
        return (b & 2) > 0;
    }

    public final BigDecimal getGeneratedKey() {
        AS400PackedDecimal typeConverter = new AS400PackedDecimal(30, 0);
        try {
            return (BigDecimal)typeConverter.toObject(this.data_, this.offset_ + 72);
        }
        catch (NumberFormatException nfe) {
            return null;
        }
    }

    public final int getSQLCode() throws DBDataStreamException {
        return BinaryConverter.byteArrayToInt(this.data_, this.offset_ + 12);
    }

    public final String getSQLState(ConvTable converter) throws DBDataStreamException {
        if (this.length_ <= 6) {
            return null;
        }
        return converter.byteArrayToString(this.data_, this.offset_ + 131, 5);
    }

    public final byte getWarn5() throws DBDataStreamException {
        if (this.length_ <= 6) {
            return 0;
        }
        return this.data_[this.offset_ + 124];
    }
}

