/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Objects;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.InternalReadAccessor;
import org.drools.core.spi.ReadAccessor;
import org.drools.core.spi.Tuple;
import org.drools.core.spi.TupleValueExtractor;
import org.drools.core.util.Entry;
import org.drools.core.util.HashTableIterator;
import org.drools.core.util.Iterator;
import org.drools.core.util.index.TupleList;

public abstract class AbstractHashTable
implements Externalizable {
    static final int MAX_CAPACITY = 0x40000000;
    public static final int PRIME = 31;
    protected int size;
    protected int threshold;
    protected float loadFactor;
    protected ObjectComparator comparator;
    protected Entry<TupleList>[] table;
    private HashTableIterator iterator;

    public AbstractHashTable() {
        this(16, 0.75f);
    }

    public AbstractHashTable(int capacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)capacity * loadFactor);
        this.table = new Entry[capacity];
        this.comparator = EqualityEquals.getInstance();
    }

    public AbstractHashTable(Entry[] table) {
        this(0.75f, table);
    }

    public AbstractHashTable(float loadFactor, Entry[] table) {
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)table.length * loadFactor);
        this.table = table;
        this.comparator = EqualityEquals.getInstance();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.size = in.readInt();
        this.threshold = in.readInt();
        this.loadFactor = in.readFloat();
        this.comparator = (ObjectComparator)in.readObject();
        this.table = (Entry[])in.readObject();
        this.iterator = (HashTableIterator)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size);
        out.writeInt(this.threshold);
        out.writeFloat(this.loadFactor);
        out.writeObject(this.comparator);
        out.writeObject(this.table);
        out.writeObject(this.iterator);
    }

    public Iterator iterator() {
        if (this.iterator == null) {
            this.iterator = new HashTableIterator(this);
        } else {
            this.iterator.reset();
        }
        return this.iterator;
    }

    public Iterator newIterator() {
        return new HashTableIterator(this);
    }

    public void setComparator(ObjectComparator comparator) {
        this.comparator = comparator;
    }

    public void ensureCapacity(int itemsToBeAdded) {
        int newCapacity = this.size + itemsToBeAdded;
        if (newCapacity > this.threshold) {
            int newSize;
            for (newSize = this.table.length * 2; newSize < newCapacity; newSize *= 2) {
            }
            this.resize(newSize);
        }
    }

    protected void resize(int newCapacity) {
        Entry<TupleList>[] oldTable = this.table;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] newTable = new Entry[newCapacity];
        for (int i = 0; i < this.table.length; ++i) {
            TupleList entry = this.table[i];
            if (entry == null) continue;
            this.table[i] = null;
            while (entry != null) {
                TupleList next = entry.getNext();
                int index = AbstractHashTable.indexOf(this.getResizeHashcode(entry), newTable.length);
                entry.setNext((TupleList)newTable[index]);
                newTable[index] = entry;
                entry = next;
            }
        }
        this.table = newTable;
        this.threshold = (int)((float)newCapacity * this.loadFactor);
    }

    public abstract int getResizeHashcode(Entry var1);

    public Entry[] toArray() {
        Entry[] result = new Entry[this.size];
        int index = 0;
        for (int i = 0; i < this.table.length; ++i) {
            for (TupleList entry = this.table[i]; entry != null; entry = entry.getNext()) {
                result[index++] = entry;
            }
        }
        return result;
    }

    public Entry<TupleList>[] getTable() {
        return this.table;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public static int rehash(int hash) {
        hash ^= hash >>> 20 ^ hash >>> 12;
        return hash ^ hash >>> 7 ^ hash >>> 4;
    }

    protected static int indexOf(int hashCode, int dataSize) {
        return hashCode & dataSize - 1;
    }

    public String toString() {
        StringBuilder sbuilder = new StringBuilder();
        Iterator it = this.newIterator();
        boolean isFirst = true;
        Entry entry = (Entry)it.next();
        while (entry != null) {
            sbuilder.append(entry.toString());
            if (!isFirst) {
                sbuilder.append(", ");
            }
            isFirst = false;
            entry = (Entry)it.next();
        }
        return sbuilder.toString();
    }

    public void clear() {
        this.table = new Entry[Math.min(this.table.length, 16)];
        this.threshold = (int)((float)this.table.length * this.loadFactor);
        this.size = 0;
        this.iterator = null;
    }

    public static class TripleHashEntry
    implements HashEntry {
        private final int hashCode;
        private final Object obj1;
        private final Object obj2;
        private final Object obj3;

        public TripleHashEntry(int hashSeed, Object obj1, Object obj2, Object obj3) {
            this.obj1 = obj1;
            this.obj2 = obj2;
            this.obj3 = obj3;
            this.hashCode = this.hashCodeOf(hashSeed, obj1, obj2, obj3);
        }

        private int hashCodeOf(int hashSeed, Object obj1, Object obj2, Object obj3) {
            int hashCode = hashSeed;
            hashCode = 31 * hashCode + Objects.hashCode(obj1);
            hashCode = 31 * hashCode + Objects.hashCode(obj2);
            hashCode = 31 * hashCode + Objects.hashCode(obj3);
            return AbstractHashTable.rehash(hashCode);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TripleHashEntry that = (TripleHashEntry)o;
            return this.hashCode == that.hashCode && Objects.equals(this.obj1, that.obj1) && Objects.equals(this.obj2, that.obj2) && Objects.equals(this.obj3, that.obj3);
        }
    }

    public static class DoubleHashEntry
    implements HashEntry {
        private final int hashCode;
        private final Object obj1;
        private final Object obj2;

        public DoubleHashEntry(int hashSeed, Object obj1, Object obj2) {
            this.obj1 = obj1;
            this.obj2 = obj2;
            this.hashCode = this.hashCodeOf(hashSeed, obj1, obj2);
        }

        private int hashCodeOf(int hashSeed, Object obj1, Object obj2) {
            int hashCode = hashSeed;
            hashCode = 31 * hashCode + Objects.hashCode(obj1);
            hashCode = 31 * hashCode + Objects.hashCode(obj2);
            return AbstractHashTable.rehash(hashCode);
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DoubleHashEntry that = (DoubleHashEntry)o;
            return this.hashCode == that.hashCode && Objects.equals(this.obj1, that.obj1) && Objects.equals(this.obj2, that.obj2);
        }
    }

    public static class SingleHashEntry
    implements HashEntry {
        private final int hashCode;
        private final Object obj1;

        public SingleHashEntry(int hashSeed, Object obj1) {
            this.obj1 = obj1;
            this.hashCode = AbstractHashTable.rehash(31 * hashSeed + Objects.hashCode(obj1));
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SingleHashEntry that = (SingleHashEntry)o;
            return this.hashCode == that.hashCode && Objects.equals(this.obj1, that.obj1);
        }
    }

    public static interface HashEntry {
    }

    public static class TripleCompositeIndex
    implements Index {
        private static final long serialVersionUID = 510L;
        private FieldIndex index1;
        private FieldIndex index2;
        private FieldIndex index3;
        private int startResult;

        public TripleCompositeIndex() {
        }

        public TripleCompositeIndex(FieldIndex[] indexes, int startResult) {
            this.startResult = startResult;
            this.index1 = indexes[0];
            this.index2 = indexes[1];
            this.index3 = indexes[2];
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index1 = (FieldIndex)in.readObject();
            this.index2 = (FieldIndex)in.readObject();
            this.index3 = (FieldIndex)in.readObject();
            this.startResult = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.index1);
            out.writeObject(this.index2);
            out.writeObject(this.index3);
            out.writeInt(this.startResult);
        }

        @Override
        public FieldIndex getFieldIndex(int index) {
            switch (index) {
                case 0: {
                    return this.index1;
                }
                case 1: {
                    return this.index2;
                }
                case 2: {
                    return this.index3;
                }
            }
            throw new IllegalArgumentException("IndexUtil position " + index + " does not exist");
        }

        @Override
        public HashEntry hashCodeOf(Tuple tuple, boolean left) {
            return new TripleHashEntry(this.startResult, this.index1.indexedValueOf(tuple, left), this.index2.indexedValueOf(tuple, left), this.index3.indexedValueOf(tuple, left));
        }
    }

    public static class DoubleCompositeIndex
    implements Index {
        private static final long serialVersionUID = 510L;
        private FieldIndex index1;
        private FieldIndex index2;
        private int startResult;

        public DoubleCompositeIndex() {
        }

        public DoubleCompositeIndex(FieldIndex[] indexes, int startResult) {
            this.startResult = startResult;
            this.index1 = indexes[0];
            this.index2 = indexes[1];
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index1 = (FieldIndex)in.readObject();
            this.index2 = (FieldIndex)in.readObject();
            this.startResult = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.index1);
            out.writeObject(this.index2);
            out.writeInt(this.startResult);
        }

        @Override
        public FieldIndex getFieldIndex(int index) {
            switch (index) {
                case 0: {
                    return this.index1;
                }
                case 1: {
                    return this.index2;
                }
            }
            throw new IllegalArgumentException("IndexUtil position " + index + " does not exist");
        }

        @Override
        public HashEntry hashCodeOf(Tuple tuple, boolean left) {
            return new DoubleHashEntry(this.startResult, this.index1.indexedValueOf(tuple, left), this.index2.indexedValueOf(tuple, left));
        }
    }

    public static class IndexTupleList
    extends TupleList {
        private HashEntry hashEntry;
        private Index index;
        private int hashCode;

        public IndexTupleList(Index index, HashEntry hashEntry) {
            this.index = index;
            this.hashEntry = hashEntry;
            this.hashCode = hashEntry.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof IndexTupleList)) {
                return false;
            }
            IndexTupleList other = (IndexTupleList)object;
            return this.hashCode == other.hashCode && this.index == other.index;
        }

        public int hashCode() {
            return this.hashCode;
        }

        @Override
        protected void copyStateInto(TupleList other) {
            super.copyStateInto(other);
            ((IndexTupleList)other).hashEntry = this.hashEntry;
            ((IndexTupleList)other).index = this.index;
            ((IndexTupleList)other).hashCode = this.hashCode;
        }

        public HashEntry getHashEntry() {
            return this.hashEntry;
        }
    }

    public static class SingleIndex
    implements Index {
        private static final long serialVersionUID = 510L;
        private FieldIndex index;
        private int startResult;

        public SingleIndex() {
        }

        public SingleIndex(FieldIndex[] indexes, int startResult) {
            this.startResult = startResult;
            this.index = indexes[0];
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.index = (FieldIndex)in.readObject();
            this.startResult = in.readInt();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.index);
            out.writeInt(this.startResult);
        }

        @Override
        public FieldIndex getFieldIndex(int index) {
            if (index > 0) {
                throw new IllegalArgumentException("IndexUtil position " + index + " does not exist");
            }
            return this.index;
        }

        @Override
        public HashEntry hashCodeOf(Tuple tuple, boolean left) {
            return new SingleHashEntry(this.startResult, this.index.indexedValueOf(tuple, left));
        }
    }

    public static interface Index
    extends Externalizable {
        public FieldIndex getFieldIndex(int var1);

        public HashEntry hashCodeOf(Tuple var1, boolean var2);
    }

    public static class FieldIndex
    implements Externalizable {
        private static final long serialVersionUID = 510L;
        private TupleValueExtractor leftExtractor;
        private InternalReadAccessor rightExtractor;
        private boolean requiresCoercion;

        public FieldIndex() {
        }

        public FieldIndex(InternalReadAccessor rightExtractor, TupleValueExtractor leftExtractor) {
            this.rightExtractor = rightExtractor;
            this.leftExtractor = leftExtractor;
            this.requiresCoercion = this.isCoercionRequired(rightExtractor, leftExtractor);
        }

        private boolean isCoercionRequired(InternalReadAccessor extractor, TupleValueExtractor declaration) {
            return extractor.getValueType() != declaration.getValueType();
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.rightExtractor = (InternalReadAccessor)in.readObject();
            this.leftExtractor = (Declaration)in.readObject();
            this.requiresCoercion = this.isCoercionRequired(this.rightExtractor, this.leftExtractor);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.rightExtractor);
            out.writeObject(this.leftExtractor);
        }

        public TupleValueExtractor getLeftExtractor() {
            return this.leftExtractor;
        }

        public ReadAccessor getRightExtractor() {
            return this.rightExtractor;
        }

        public boolean requiresCoercion() {
            return this.requiresCoercion;
        }

        public Object indexedValueOf(Tuple tuple, boolean left) {
            return left ? (this.requiresCoercion ? this.rightExtractor.getValueType().coerce(this.leftExtractor.getValue(tuple)) : this.leftExtractor.getValue(tuple)) : this.rightExtractor.getValue(null, tuple.getFactHandle().getObject());
        }
    }

    public static class EqualityEquals
    extends AbstractObjectComparator {
        private static final long serialVersionUID = 510L;
        public static final ObjectComparator INSTANCE = new EqualityEquals();

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public static ObjectComparator getInstance() {
            return INSTANCE;
        }

        @Override
        public int hashCodeOf(Object key) {
            return AbstractHashTable.rehash(key.hashCode());
        }

        @Override
        public boolean areEqual(Object object1, Object object2) {
            if (object1 == null) {
                return object2 == null;
            }
            return object1.equals(object2);
        }
    }

    public static class InstanceEquals
    extends AbstractObjectComparator {
        private static final long serialVersionUID = 510L;
        public static final ObjectComparator INSTANCE = new InstanceEquals();

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public static ObjectComparator getInstance() {
            return INSTANCE;
        }

        @Override
        public int hashCodeOf(Object obj) {
            return AbstractHashTable.rehash(System.identityHashCode(obj));
        }

        @Override
        public boolean areEqual(Object object1, Object object2) {
            return object1 == object2;
        }
    }

    public static abstract class AbstractObjectComparator
    implements ObjectComparator {
    }

    public static interface ObjectComparator
    extends Externalizable {
        public int hashCodeOf(Object var1);

        public boolean areEqual(Object var1, Object var2);
    }
}

