/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.functions;

import java.util.Collection;
import org.apache.beam.runners.flink.translation.functions.FlinkAssignContext;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowedValues;
import org.apache.flink.api.common.functions.FlatMapFunction;
import org.apache.flink.util.Collector;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

public class FlinkAssignWindows<@UnknownKeyFor T, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
implements FlatMapFunction<WindowedValue<T>, WindowedValue<T>> {
    private final @UnknownKeyFor @NonNull @Initialized WindowFn<T, W> windowFn;

    public FlinkAssignWindows(@UnknownKeyFor @NonNull @Initialized WindowFn<T, W> windowFn) {
        this.windowFn = windowFn;
    }

    public void flatMap(@UnknownKeyFor @NonNull @Initialized WindowedValue<T> input, @UnknownKeyFor @NonNull @Initialized Collector<@UnknownKeyFor @NonNull @Initialized WindowedValue<T>> collector) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Collection windows = this.windowFn.assignWindows(new FlinkAssignContext<T, W>(this.windowFn, input));
        for (BoundedWindow window : windows) {
            collector.collect((Object)WindowedValues.of((Object)input.getValue(), (Instant)input.getTimestamp(), (BoundedWindow)window, (PaneInfo)input.getPaneInfo()));
        }
    }
}

