/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.types;

import org.apache.hop.core.gui.plugin.GuiPlugin;
import org.apache.hop.core.gui.plugin.menu.GuiMenuElement;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.pipeline.transforms.types.TextExplorerFileTypeHandler;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.HopFileTypeRegistry;
import org.apache.hop.ui.hopgui.file.IHopFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileType;
import org.apache.hop.ui.hopgui.perspective.explorer.file.IExplorerFileTypeHandler;

@GuiPlugin
public class HtmlOpenAsTextPlugin {
    @GuiMenuElement(root="ExplorerPerspective-ContextMenu", id="ExplorerPerspective-Html-OpenAsText", label="i18n:org.apache.hop.ui.hopgui.perspective.explorer:ExplorerPerspective.ToolbarElement.OpenAsText.Label", image="textfile.svg", parentId="ExplorerPerspective-ContextMenu", separator=true)
    public void openAsText() {
        ExplorerPerspective perspective = ExplorerPerspective.getInstance();
        ExplorerFile explorerFile = perspective.getSelectedFile();
        if (explorerFile == null) {
            return;
        }
        String filename = explorerFile.getFilename();
        if (filename == null || !filename.toLowerCase().endsWith(".html")) {
            return;
        }
        try {
            HopGui hopGui = HopGui.getInstance();
            IHopFileType hopFileType = HopFileTypeRegistry.getInstance().findHopFileType("dummy.txt");
            if (hopFileType instanceof IExplorerFileType) {
                IExplorerFileType textFileType = (IExplorerFileType)hopFileType;
                ExplorerFile textExplorerFile = new ExplorerFile();
                String uniqueName = HopVfs.getFileObject((String)filename).getName().getURI();
                textExplorerFile.setFilename(uniqueName);
                textExplorerFile.setName(explorerFile.getName() + " (Text)");
                textExplorerFile.setFileType((IHopFileType)textFileType);
                TextExplorerFileTypeHandler handler = new TextExplorerFileTypeHandler(hopGui, perspective, textExplorerFile);
                perspective.addFile((IExplorerFileTypeHandler)handler);
            }
        }
        catch (Exception e) {
            HopGui.getInstance().getLog().logError("Error opening file as text", (Throwable)e);
        }
    }
}

