/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.types;

import org.apache.hop.core.Const;
import org.apache.hop.core.logging.LogChannel;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerFile;
import org.apache.hop.ui.hopgui.perspective.explorer.ExplorerPerspective;
import org.apache.hop.ui.hopgui.perspective.explorer.file.types.base.BaseExplorerFileTypeHandler;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

public class PdfExplorerFileTypeHandler
extends BaseExplorerFileTypeHandler {
    private Browser wBrowser;

    public PdfExplorerFileTypeHandler(HopGui hopGui, ExplorerPerspective perspective, ExplorerFile explorerFile) {
        super(hopGui, perspective, explorerFile);
    }

    public void renderFile(Composite composite) {
        this.wBrowser = new Browser(composite, 0);
        PropsUi.setLook((Widget)this.wBrowser);
        FormData fdBrowser = new FormData();
        fdBrowser.left = new FormAttachment(0, 0);
        fdBrowser.right = new FormAttachment(100, 0);
        fdBrowser.top = new FormAttachment(0, 0);
        fdBrowser.bottom = new FormAttachment(100, 0);
        this.wBrowser.setLayoutData((Object)fdBrowser);
        this.reload();
    }

    public void reload() {
        try {
            String filename = this.explorerFile.getFilename();
            if (!HopVfs.fileExists((String)filename)) {
                this.showError("File not found: " + filename);
                return;
            }
            String fileUrl = HopVfs.getFileObject((String)filename).getURL().toString();
            this.wBrowser.setUrl(fileUrl);
            this.clearChanged();
        }
        catch (Exception e) {
            LogChannel.UI.logError("Error loading PDF file '" + this.explorerFile.getFilename() + "'", (Throwable)e);
            this.showError("Error loading PDF file: " + Const.NVL((String)e.getMessage(), (String)"Unknown error"));
        }
    }

    private void showError(String message) {
        this.wBrowser.setText("<html><body><h1>Error loading PDF file</h1><p>" + message + "</p></body></html>");
    }

    public void selectAll() {
    }

    public void unselectAll() {
    }

    public void copySelectedToClipboard() {
    }
}

