/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.sqs;

import com.google.auto.value.AutoValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.aws2.common.AsyncBatchWriteHandler;
import org.apache.beam.sdk.io.aws2.common.ClientBuilderFactory;
import org.apache.beam.sdk.io.aws2.common.ClientConfiguration;
import org.apache.beam.sdk.io.aws2.options.AwsOptions;
import org.apache.beam.sdk.io.aws2.sqs.AutoValue_SqsIO_Read;
import org.apache.beam.sdk.io.aws2.sqs.AutoValue_SqsIO_Write;
import org.apache.beam.sdk.io.aws2.sqs.AutoValue_SqsIO_WriteBatches;
import org.apache.beam.sdk.io.aws2.sqs.SqsMessage;
import org.apache.beam.sdk.io.aws2.sqs.SqsUnboundedSource;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.services.sqs.SqsAsyncClient;
import software.amazon.awssdk.services.sqs.model.BatchResultErrorEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequest;
import software.amazon.awssdk.services.sqs.model.SendMessageBatchRequestEntry;
import software.amazon.awssdk.services.sqs.model.SendMessageRequest;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Initialization safe.")
public class SqsIO {
    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_SqsIO_Read.Builder().setClientConfiguration(ClientConfiguration.EMPTY).setMaxNumRecords(Long.MAX_VALUE).build();
    }

    @Deprecated
    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new AutoValue_SqsIO_Write.Builder().setClientConfiguration(ClientConfiguration.EMPTY).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized WriteBatches<T> writeBatches() {
        return new AutoValue_SqsIO_WriteBatches.Builder().clientConfiguration(ClientConfiguration.EMPTY).concurrentRequests(5).batchSize(10).batchTimeout(WriteBatches.DEFAULT_BATCH_TIMEOUT).strictTimeouts(false).build();
    }

    private SqsIO() {
    }

    @AutoValue
    public static abstract class WriteBatches<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, Result> {
        private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(WriteBatches.class);
        private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_CONCURRENCY = 5;
        private static final @UnknownKeyFor @NonNull @Initialized int MAX_BATCH_SIZE = 10;
        private static final @UnknownKeyFor @NonNull @Initialized Duration DEFAULT_BATCH_TIMEOUT = Duration.standardSeconds((long)3L);

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized int concurrentRequests();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized Duration batchTimeout();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized boolean strictTimeouts();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized int batchSize();

        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized ClientConfiguration clientConfiguration();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized EntryMapperFn<T> entryMapper();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized DynamicDestination<T> dynamicDestination();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized String queueUrl();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> builder();

        public @UnknownKeyFor @NonNull @Initialized WriteBatches<T> withClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration config) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"ClientConfiguration cannot be null");
            return this.builder().clientConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized WriteBatches<T> withConcurrentRequests(@UnknownKeyFor @NonNull @Initialized int concurrentRequests) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((concurrentRequests > 0 ? 1 : 0) != 0, (Object)"concurrentRequests must be > 0");
            return this.builder().concurrentRequests(concurrentRequests).build();
        }

        public @UnknownKeyFor @NonNull @Initialized WriteBatches<T> withEntryMapper(@UnknownKeyFor @NonNull @Initialized EntryMapperFn<T> mapper) {
            return this.builder().entryMapper(mapper).build();
        }

        public @UnknownKeyFor @NonNull @Initialized WriteBatches<T> withEntryMapper(@UnknownKeyFor @NonNull @Initialized EntryMapperFn.Builder<T> mapper) {
            return this.builder().entryMapper(mapper).build();
        }

        public @UnknownKeyFor @NonNull @Initialized WriteBatches<T> withBatchSize(@UnknownKeyFor @NonNull @Initialized int batchSize) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((batchSize > 0 && batchSize <= 10 ? 1 : 0) != 0, (Object)"Maximum allowed batch size is 10");
            return this.builder().batchSize(batchSize).build();
        }

        public @UnknownKeyFor @NonNull @Initialized WriteBatches<T> withBatchTimeout(@UnknownKeyFor @NonNull @Initialized Duration timeout) {
            return this.withBatchTimeout(timeout, false);
        }

        public @UnknownKeyFor @NonNull @Initialized WriteBatches<T> withBatchTimeout(@UnknownKeyFor @NonNull @Initialized Duration timeout, @UnknownKeyFor @NonNull @Initialized boolean strict) {
            return this.builder().batchTimeout(timeout).strictTimeouts(strict).build();
        }

        public @UnknownKeyFor @NonNull @Initialized WriteBatches<T> to(@UnknownKeyFor @NonNull @Initialized DynamicDestination<T> destination) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((destination != null ? 1 : 0) != 0, (Object)"DynamicDestination cannot be null");
            return this.builder().queueUrl(null).dynamicDestination(destination).build();
        }

        public @UnknownKeyFor @NonNull @Initialized WriteBatches<T> to(@UnknownKeyFor @NonNull @Initialized String queueUrl) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((queueUrl != null ? 1 : 0) != 0, (Object)"queueUrl cannot be null");
            return this.builder().dynamicDestination(null).queueUrl(queueUrl).build();
        }

        private @UnknownKeyFor @NonNull @Initialized EntryMapperFn<T> schemaEntryMapper(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)input.hasSchema(), (Object)"withEntryMapper is required if schema is not available");
            SchemaRegistry registry = input.getPipeline().getSchemaRegistry();
            try {
                return new SchemaEntryMapper(input.getSchema(), registry.getSchema(SendMessageBatchRequestEntry.class), input.getToRowFunction(), (SerializableFunction<Row, SendMessageBatchRequestEntry>)registry.getFromRowFunction(SendMessageBatchRequestEntry.class));
            }
            catch (NoSuchSchemaException e) {
                throw new RuntimeException(e);
            }
        }

        public @UnknownKeyFor @NonNull @Initialized Result expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            AwsOptions awsOptions = (AwsOptions)input.getPipeline().getOptions().as(AwsOptions.class);
            ClientBuilderFactory.validate(awsOptions, this.clientConfiguration());
            final EntryMapperFn<T> mapper = this.entryMapper() != null ? this.entryMapper() : this.schemaEntryMapper(input);
            input.apply((PTransform)ParDo.of((DoFn)new DoFn<T, Void>(){
                private @Nullable @UnknownKeyFor @Initialized BatchHandler<T> handler = null;

                @DoFn.Setup
                public void setup(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
                    this.handler = new BatchHandler(this, mapper, (AwsOptions)options.as(AwsOptions.class));
                }

                @DoFn.StartBundle
                public void startBundle() {
                    this.handler().startBundle();
                }

                @DoFn.ProcessElement
                public void processElement(/*
                 * Issues handling annotations - annotations may be inaccurate
                 */
                // Could not load outer class - annotation placement on inner may be incorrect
                @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext cxt) throws @UnknownKeyFor @NonNull @Initialized Throwable {
                    this.handler().process(cxt.element());
                }

                @DoFn.FinishBundle
                public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                    this.handler().finishBundle();
                }

                @DoFn.Teardown
                public void teardown() throws @UnknownKeyFor @NonNull @Initialized Exception {
                    if (this.handler != null) {
                        this.handler.close();
                        this.handler = null;
                    }
                }

                private @UnknownKeyFor @NonNull @Initialized BatchHandler<T> handler() {
                    return (BatchHandler)Preconditions.checkStateNotNull(this.handler, (Object)"SQS handler is null");
                }
            }));
            return new Result(input.getPipeline());
        }

        @NotThreadSafe
        private static abstract class Batch {
            private static final @UnknownKeyFor @NonNull @Initialized Instant NEVER = Instant.ofEpochMilli((long)Long.MAX_VALUE);
            private final @UnknownKeyFor @NonNull @Initialized String queue;
            private final @UnknownKeyFor @NonNull @Initialized Instant expirationTime;
            private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SendMessageBatchRequestEntry> entries;

            static @UnknownKeyFor @NonNull @Initialized Batch createLocked(@UnknownKeyFor @NonNull @Initialized String queue, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized WriteBatches<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> spec) {
                return spec.strictTimeouts() ? new BatchWithAtomicLock(queue, spec.batchSize(), spec.batchTimeout()) : new BatchWithNoopLock(queue, spec.batchSize(), spec.batchTimeout());
            }

            private Batch(@UnknownKeyFor @NonNull @Initialized String queue, @UnknownKeyFor @NonNull @Initialized int size, @UnknownKeyFor @NonNull @Initialized Duration timeout) {
                this.queue = queue;
                this.entries = new ArrayList<SendMessageBatchRequestEntry>(size);
                this.expirationTime = Instant.now().plus((ReadableDuration)timeout);
            }

            abstract @UnknownKeyFor @NonNull @Initialized boolean lock(@UnknownKeyFor @NonNull @Initialized boolean var1);

            @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SendMessageBatchRequestEntry> getAndClose() {
                List<SendMessageBatchRequestEntry> res = this.entries;
                this.entries = Collections.EMPTY_LIST;
                return res;
            }

            void add(@UnknownKeyFor @NonNull @Initialized SendMessageBatchRequestEntry entry) {
                this.entries.add(entry);
            }

            @UnknownKeyFor @NonNull @Initialized int size() {
                return this.entries.size();
            }

            @UnknownKeyFor @NonNull @Initialized boolean isExpired() {
                return this.expirationTime.isBeforeNow();
            }

            @UnknownKeyFor @NonNull @Initialized boolean isClosed() {
                return this.entries == Collections.EMPTY_LIST;
            }

            private static class BatchWithAtomicLock
            extends Batch {
                private final @UnknownKeyFor @NonNull @Initialized AtomicBoolean locked = new AtomicBoolean(true);

                BatchWithAtomicLock(@UnknownKeyFor @NonNull @Initialized String queue, @UnknownKeyFor @NonNull @Initialized int size, @UnknownKeyFor @NonNull @Initialized Duration timeout) {
                    super(queue, size, timeout);
                }

                @Override
                @UnknownKeyFor @NonNull @Initialized boolean lock(@UnknownKeyFor @NonNull @Initialized boolean lock) {
                    return !this.isClosed() && this.locked.compareAndSet(!lock, lock);
                }
            }

            private static class BatchWithNoopLock
            extends Batch {
                BatchWithNoopLock(@UnknownKeyFor @NonNull @Initialized String queue, @UnknownKeyFor @NonNull @Initialized int size, @UnknownKeyFor @NonNull @Initialized Duration timeout) {
                    super(queue, size, timeout);
                }

                @Override
                @UnknownKeyFor @NonNull @Initialized boolean lock(@UnknownKeyFor @NonNull @Initialized boolean lock) {
                    return !this.isClosed();
                }
            }
        }

        private static class BatchHandler<@UnknownKeyFor T>
        implements AutoCloseable {
            private static final @UnknownKeyFor @NonNull @Initialized int CHECKS_PER_TIMEOUT_PERIOD = 5;
            public static final @UnknownKeyFor @NonNull @Initialized int EXPIRATION_CHECK_TIMEOUT_SECS = 3;
            private final @UnknownKeyFor @NonNull @Initialized WriteBatches<T> spec;
            private final @UnknownKeyFor @NonNull @Initialized SqsAsyncClient sqs;
            private final @UnknownKeyFor @NonNull @Initialized BatchHandler. @UnknownKeyFor @NonNull @Initialized Batches batches;
            private final @UnknownKeyFor @NonNull @Initialized EntryMapperFn<T> entryMapper;
            private final @UnknownKeyFor @NonNull @Initialized AsyncBatchWriteHandler<@UnknownKeyFor @NonNull @Initialized SendMessageBatchRequestEntry, @UnknownKeyFor @NonNull @Initialized BatchResultErrorEntry> handler;
            private final @Nullable @UnknownKeyFor @Initialized ScheduledExecutorService scheduler;
            private /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @MonotonicNonNull @UnknownKeyFor @Initialized ScheduledFuture<@UnknownKeyFor @KeyForBottom @Nullable @Initialized @NonNull @Initialized ?> expirationCheck = null;

            BatchHandler(@UnknownKeyFor @NonNull @Initialized WriteBatches<T> spec, @UnknownKeyFor @NonNull @Initialized EntryMapperFn<T> entryMapper, @UnknownKeyFor @NonNull @Initialized AwsOptions options) {
                this.spec = spec;
                this.sqs = (SqsAsyncClient)ClientBuilderFactory.buildClient(options, SqsAsyncClient.builder(), spec.clientConfiguration());
                this.entryMapper = entryMapper;
                this.handler = AsyncBatchWriteHandler.byId(spec.concurrentRequests(), spec.batchSize(), spec.clientConfiguration().retry(), AsyncBatchWriteHandler.Stats.NONE, (queue, records) -> BatchHandler.sendMessageBatch(this.sqs, queue, records), error -> error.code(), record -> record.id(), error -> error.id());
                ScheduledExecutorService scheduledExecutorService = this.scheduler = spec.strictTimeouts() ? Executors.newSingleThreadScheduledExecutor() : null;
                if (spec.queueUrl() != null) {
                    this.batches = new Single();
                } else if (spec.dynamicDestination() != null) {
                    this.batches = new Dynamic(spec.dynamicDestination());
                } else {
                    throw new IllegalStateException("to(queueUrl) or to(dynamicDestination) is required");
                }
            }

            private static @UnknownKeyFor @NonNull @Initialized CompletableFuture<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized BatchResultErrorEntry>> sendMessageBatch(@UnknownKeyFor @NonNull @Initialized SqsAsyncClient sqs, @UnknownKeyFor @NonNull @Initialized String queue, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized SendMessageBatchRequestEntry> records) {
                SendMessageBatchRequest request = (SendMessageBatchRequest)SendMessageBatchRequest.builder().queueUrl(queue).entries(records).build();
                return sqs.sendMessageBatch(request).thenApply(resp -> resp.failed());
            }

            public void startBundle() {
                this.handler.reset();
                if (this.scheduler != null && this.spec.strictTimeouts()) {
                    long timeout = this.spec.batchTimeout().getMillis();
                    long period = timeout / 5L;
                    this.expirationCheck = this.scheduler.scheduleWithFixedDelay(() -> this.batches.submitExpired(false), timeout, period, TimeUnit.MILLISECONDS);
                }
            }

            public void process(T msg) {
                SendMessageBatchRequestEntry entry = (SendMessageBatchRequestEntry)this.entryMapper.apply(this.batches.nextId(), msg);
                Batch batch = this.batches.getLocked(msg);
                batch.add(entry);
                if (batch.size() >= this.spec.batchSize() || batch.isExpired()) {
                    this.submitEntries(batch, true);
                } else {
                    org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)batch.lock(false));
                }
                if (this.scheduler == null) {
                    this.batches.submitExpired(true);
                }
            }

            private void submitEntries(@UnknownKeyFor @NonNull @Initialized Batch batch, @UnknownKeyFor @NonNull @Initialized boolean throwFailures) {
                try {
                    this.handler.batchWrite(batch.queue, batch.getAndClose(), throwFailures);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable e) {
                    throw new RuntimeException(e);
                }
            }

            public void finishBundle() throws @UnknownKeyFor @NonNull @Initialized Throwable {
                if (this.expirationCheck != null) {
                    this.expirationCheck.cancel(false);
                    while (true) {
                        try {
                            while (true) {
                                this.expirationCheck.get(3L, TimeUnit.SECONDS);
                            }
                        }
                        catch (TimeoutException e) {
                            LOG.warn("Waiting for timeout check to complete");
                            continue;
                        }
                        catch (CancellationException e) {
                            // empty catch block
                        }
                        break;
                    }
                }
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)this.batches.submitAll());
                this.handler.waitForCompletion();
            }

            @Override
            public void close() throws @UnknownKeyFor @NonNull @Initialized Exception {
                this.sqs.close();
                if (this.scheduler != null) {
                    this.scheduler.shutdown();
                }
            }

            @NotThreadSafe
            private class Dynamic
            extends Batches {
                private final @UnknownKeyFor @NonNull @Initialized BiFunction<@NonNull @UnknownKeyFor @Initialized String, @Nullable @UnknownKeyFor @Initialized Batch, @UnknownKeyFor @NonNull @Initialized Batch> getLocked;
                private final @UnknownKeyFor @NonNull @Initialized Map<@NonNull @UnknownKeyFor @Initialized String, @UnknownKeyFor @NonNull @Initialized Batch> batches;
                private final @UnknownKeyFor @NonNull @Initialized AtomicBoolean submitExpiredRunning;
                private final @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized Instant> nextTimeout;
                private final @UnknownKeyFor @NonNull @Initialized DynamicDestination<T> destination;

                Dynamic(DynamicDestination<T> destination) {
                    this.getLocked = (queue, batch) -> batch != null && batch.lock(true) ? batch : this.createLocked((String)queue);
                    this.batches = new HashMap<String, Batch>();
                    this.submitExpiredRunning = new AtomicBoolean(false);
                    this.nextTimeout = new AtomicReference<Instant>(Batch.NEVER);
                    this.destination = destination;
                }

                @Override
                @UnknownKeyFor @NonNull @Initialized int maxBatches() {
                    return this.batches.size() + 1;
                }

                @Override
                @UnknownKeyFor @NonNull @Initialized Batch getLocked(T record) {
                    return this.batches.compute(this.destination.queueUrl(record), this.getLocked);
                }

                @Override
                @UnknownKeyFor @NonNull @Initialized boolean submitAll() {
                    AtomicBoolean res = new AtomicBoolean(true);
                    this.batches.values().forEach(batch -> res.compareAndSet(true, this.lockAndSubmit((Batch)batch, true)));
                    this.batches.clear();
                    this.nextTimeout.set(Batch.NEVER);
                    return res.get();
                }

                private void updateNextTimeout(@UnknownKeyFor @NonNull @Initialized Batch batch) {
                    Instant prev;
                    do {
                        prev = this.nextTimeout.get();
                    } while (batch.expirationTime.isBefore((ReadableInstant)prev) && !this.nextTimeout.compareAndSet(prev, batch.expirationTime));
                }

                private void submitExpired(@UnknownKeyFor @NonNull @Initialized Batch batch, @UnknownKeyFor @NonNull @Initialized boolean throwFailures) {
                    if (!(batch.isClosed() || batch.isExpired() && this.lockAndSubmit(batch, throwFailures))) {
                        this.updateNextTimeout(batch);
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                void submitExpired(@UnknownKeyFor @NonNull @Initialized boolean throwFailures) {
                    Instant timeout = this.nextTimeout.get();
                    if (timeout.isBeforeNow() && this.submitExpiredRunning.compareAndSet(false, true)) {
                        try {
                            this.nextTimeout.set(Batch.NEVER);
                            this.batches.values().forEach(b -> this.submitExpired((Batch)b, throwFailures));
                        }
                        catch (ConcurrentModificationException e) {
                            this.nextTimeout.set(timeout);
                        }
                        finally {
                            this.submitExpiredRunning.set(false);
                        }
                    }
                }

                @UnknownKeyFor @NonNull @Initialized Batch createLocked(@UnknownKeyFor @NonNull @Initialized String queue) {
                    Batch batch = Batch.createLocked(queue, BatchHandler.this.spec);
                    this.updateNextTimeout(batch);
                    return batch;
                }
            }

            @NotThreadSafe
            private class Single
            extends Batches {
                private @Nullable @UnknownKeyFor @Initialized Batch batch;

                private Single() {
                }

                @Override
                @UnknownKeyFor @NonNull @Initialized int maxBatches() {
                    return 1;
                }

                @Override
                @UnknownKeyFor @NonNull @Initialized Batch getLocked(T record) {
                    if (this.batch == null || !this.batch.lock(true)) {
                        this.batch = Batch.createLocked((String)Preconditions.checkStateNotNull((Object)BatchHandler.this.spec.queueUrl()), BatchHandler.this.spec);
                    }
                    return (Batch)Preconditions.checkStateNotNull((Object)this.batch);
                }

                @Override
                @UnknownKeyFor @NonNull @Initialized boolean submitAll() {
                    return this.batch == null || this.lockAndSubmit(this.batch, true);
                }

                @Override
                void submitExpired(@UnknownKeyFor @NonNull @Initialized boolean throwFailures) {
                    if (this.batch != null && this.batch.isExpired()) {
                        this.lockAndSubmit((Batch)Preconditions.checkStateNotNull((Object)this.batch), throwFailures);
                    }
                }
            }

            @NotThreadSafe
            private abstract class Batches {
                private @UnknownKeyFor @NonNull @Initialized int nextId = 0;

                private Batches() {
                }

                abstract @UnknownKeyFor @NonNull @Initialized int maxBatches();

                @UnknownKeyFor @NonNull @Initialized String nextId() {
                    if (this.nextId >= BatchHandler.this.spec.batchSize() * this.maxBatches()) {
                        this.nextId = 0;
                    }
                    return Integer.toString(this.nextId++);
                }

                abstract @UnknownKeyFor @NonNull @Initialized Batch getLocked(T var1);

                abstract @UnknownKeyFor @NonNull @Initialized boolean submitAll();

                abstract void submitExpired(@UnknownKeyFor @NonNull @Initialized boolean var1);

                protected @UnknownKeyFor @NonNull @Initialized boolean lockAndSubmit(@UnknownKeyFor @NonNull @Initialized Batch batch, @UnknownKeyFor @NonNull @Initialized boolean throwFailures) {
                    if (batch.isClosed()) {
                        return true;
                    }
                    if (batch.lock(true)) {
                        BatchHandler.this.submitEntries(batch, throwFailures);
                        return true;
                    }
                    return false;
                }
            }
        }

        public static class Result
        implements POutput {
            private final @UnknownKeyFor @NonNull @Initialized Pipeline pipeline;

            private Result(@UnknownKeyFor @NonNull @Initialized Pipeline pipeline) {
                this.pipeline = pipeline;
            }

            public @UnknownKeyFor @NonNull @Initialized Pipeline getPipeline() {
                return this.pipeline;
            }

            public /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>, @UnknownKeyFor @NonNull @Initialized PValue> expand() {
                return ImmutableMap.of();
            }

            public void finishSpecifyingOutput(@UnknownKeyFor @NonNull @Initialized String transformName, @UnknownKeyFor @NonNull @Initialized PInput input, /*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?, @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized ?> transform) {
            }
        }

        @VisibleForTesting
        static class SchemaEntryMapper<@UnknownKeyFor T>
        implements EntryMapperFn<T> {
            private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow;
            private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized SendMessageBatchRequestEntry> fromRow;
            private final @UnknownKeyFor @NonNull @Initialized Schema schema;
            private final @UnknownKeyFor @NonNull @Initialized int @UnknownKeyFor @NonNull @Initialized [] fieldMapping;

            SchemaEntryMapper(@UnknownKeyFor @NonNull @Initialized Schema sourceSchema, @UnknownKeyFor @NonNull @Initialized Schema targetSchema, @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized SendMessageBatchRequestEntry> fromRow) {
                this.toRow = toRow;
                this.fromRow = fromRow;
                this.schema = targetSchema;
                this.fieldMapping = new int[targetSchema.getFieldCount()];
                Arrays.fill(this.fieldMapping, -1);
                LinkedList ignored = Lists.newLinkedList();
                LinkedList invalid = Lists.newLinkedList();
                for (int i = 0; i < sourceSchema.getFieldCount(); ++i) {
                    Schema.Field sourceField = sourceSchema.getField(i);
                    if (targetSchema.hasField(sourceField.getName())) {
                        int targetIdx = targetSchema.indexOf(sourceField.getName());
                        if (!sourceField.typesEqual(targetSchema.getField(targetIdx))) {
                            invalid.add(sourceField.getName());
                        }
                        this.fieldMapping[targetIdx] = i;
                        continue;
                    }
                    ignored.add(sourceField.getName());
                }
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((ignored.size() < sourceSchema.getFieldCount() ? 1 : 0) != 0, (String)"No fields matched, expected %s but got %s", (Object)this.schema.getFieldNames(), (Object)ignored);
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((boolean)invalid.isEmpty(), (String)"Detected incompatible types for input fields: {}", (Object)invalid);
                if (!ignored.isEmpty()) {
                    LOG.warn("Ignoring unmatched input fields: {}", (Object)ignored);
                }
            }

            @Override
            public @UnknownKeyFor @NonNull @Initialized SendMessageBatchRequestEntry apply(@UnknownKeyFor @NonNull @Initialized String entryId, T input) {
                Row row = (Row)this.toRow.apply(input);
                Object[] values = new Object[this.fieldMapping.length];
                values[0] = entryId;
                for (int i = 0; i < values.length; ++i) {
                    if (this.fieldMapping[i] < 0) continue;
                    values[i] = row.getValue(this.fieldMapping[i]);
                }
                return (SendMessageBatchRequestEntry)this.fromRow.apply((Object)Row.withSchema((Schema)this.schema).attachValues(values));
            }
        }

        public static interface EntryMapperFn<@UnknownKeyFor T>
        extends BiFunction<String, T, SendMessageBatchRequestEntry>,
        Serializable {

            public static interface Builder<@UnknownKeyFor T>
            extends BiConsumer<SendMessageBatchRequestEntry.Builder, T>,
            EntryMapperFn<T> {
                @Override
                default public @UnknownKeyFor @NonNull @Initialized SendMessageBatchRequestEntry apply(@UnknownKeyFor @NonNull @Initialized String entryId, T msg) {
                    SendMessageBatchRequestEntry.Builder builder = SendMessageBatchRequestEntry.builder();
                    this.accept(builder, msg);
                    return (SendMessageBatchRequestEntry)builder.id(entryId).build();
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> concurrentRequests(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> batchTimeout(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> strictTimeouts(@UnknownKeyFor @NonNull @Initialized boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> batchSize(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> clientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> entryMapper(@Nullable @UnknownKeyFor @Initialized EntryMapperFn<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> dynamicDestination(@Nullable @UnknownKeyFor @Initialized DynamicDestination<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> queueUrl(@Nullable @UnknownKeyFor @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized WriteBatches<T> build();
        }

        public static interface DynamicDestination<@UnknownKeyFor T>
        extends Serializable {
            public @UnknownKeyFor @NonNull @Initialized String queueUrl(T var1);
        }
    }

    @Deprecated
    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<SendMessageRequest>, PDone> {
        @Pure
        abstract @UnknownKeyFor @NonNull @Initialized ClientConfiguration getClientConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized Write withClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration config) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"ClientConfiguration cannot be null");
            return this.builder().setClientConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SendMessageRequest> input) {
            input.apply(SqsIO.writeBatches().withBatchSize(1).to(SendMessageRequest::queueUrl));
            return PDone.in((Pipeline)input.getPipeline());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<SqsMessage>> {
        abstract @UnknownKeyFor @NonNull @Initialized ClientConfiguration clientConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized String queueUrl();

        abstract @UnknownKeyFor @NonNull @Initialized long maxNumRecords();

        @Pure
        abstract @Nullable @UnknownKeyFor @Initialized Duration maxReadTime();

        abstract @UnknownKeyFor @NonNull @Initialized Builder builder();

        public @UnknownKeyFor @NonNull @Initialized Read withMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long maxNumRecords) {
            return this.builder().setMaxNumRecords(maxNumRecords).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration maxReadTime) {
            return this.builder().setMaxReadTime(maxReadTime).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQueueUrl(@UnknownKeyFor @NonNull @Initialized String queueUrl) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((queueUrl != null ? 1 : 0) != 0, (Object)"queueUrl can not be null");
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((!queueUrl.isEmpty() ? 1 : 0) != 0, (Object)"queueUrl can not be empty");
            return this.builder().setQueueUrl(queueUrl).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration config) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"ClientConfiguration cannot be null");
            return this.builder().setClientConfiguration(config).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized SqsMessage> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Read.Unbounded unbounded;
            AwsOptions awsOptions = (AwsOptions)input.getPipeline().getOptions().as(AwsOptions.class);
            ClientBuilderFactory.validate(awsOptions, this.clientConfiguration());
            Read.Unbounded transform = unbounded = org.apache.beam.sdk.io.Read.from((UnboundedSource)new SqsUnboundedSource(this));
            if (this.maxNumRecords() < Long.MAX_VALUE || this.maxReadTime() != null) {
                transform = unbounded.withMaxReadTime(this.maxReadTime()).withMaxNumRecords(this.maxNumRecords());
            }
            return (PCollection)input.getPipeline().apply((PTransform)transform);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setClientConfiguration(@UnknownKeyFor @NonNull @Initialized ClientConfiguration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setQueueUrl(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxNumRecords(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxReadTime(@UnknownKeyFor @NonNull @Initialized Duration var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }
}

