/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.dataflow.util;

import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.services.dataflow.Dataflow;
import com.google.auth.Credentials;
import com.google.auth.http.HttpCredentialsAdapter;
import com.google.cloud.hadoop.util.ChainingHttpRequestInitializer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import org.apache.beam.runners.dataflow.options.DataflowPipelineOptions;
import org.apache.beam.sdk.extensions.gcp.auth.NullCredentialInitializer;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.extensions.gcp.util.Transport;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class DataflowTransport {
    private static @UnknownKeyFor @NonNull @Initialized ApiComponents apiComponentsFromUrl(@UnknownKeyFor @NonNull @Initialized String urlString) {
        try {
            URL url = new URL(urlString);
            String rootUrl = url.getProtocol() + "://" + url.getHost() + (url.getPort() > 0 ? ":" + url.getPort() : "");
            return new ApiComponents(rootUrl, url.getPath());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid URL: " + urlString);
        }
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Dataflow.Builder newDataflowClient(@UnknownKeyFor @NonNull @Initialized DataflowPipelineOptions options) {
        String servicePath = options.getDataflowEndpoint();
        ApiComponents components = servicePath.contains("://") ? DataflowTransport.apiComponentsFromUrl(servicePath) : new ApiComponents(options.getApiRootUrl(), servicePath);
        return new Dataflow.Builder(Transport.getTransport(), Transport.getJsonFactory(), DataflowTransport.chainHttpRequestInitializer(options.getGcpCredential(), (HttpRequestInitializer)new RetryHttpRequestInitializer((Collection)ImmutableList.of((Object)404)))).setApplicationName(options.getAppName()).setRootUrl(components.rootUrl).setServicePath(components.servicePath).setGoogleClientRequestInitializer((GoogleClientRequestInitializer)options.getGoogleApiTrace());
    }

    private static @UnknownKeyFor @NonNull @Initialized HttpRequestInitializer chainHttpRequestInitializer(@UnknownKeyFor @NonNull @Initialized Credentials credential, @UnknownKeyFor @NonNull @Initialized HttpRequestInitializer httpRequestInitializer) {
        if (credential == null) {
            NullCredentialInitializer.throwNullCredentialException();
        }
        return new ChainingHttpRequestInitializer(new HttpRequestInitializer[]{new HttpCredentialsAdapter(credential), httpRequestInitializer});
    }

    private static class ApiComponents {
        public @UnknownKeyFor @NonNull @Initialized String rootUrl;
        public @UnknownKeyFor @NonNull @Initialized String servicePath;

        public ApiComponents(@UnknownKeyFor @NonNull @Initialized String root, @UnknownKeyFor @NonNull @Initialized String path) {
            this.rootUrl = root;
            this.servicePath = path;
        }
    }
}

