/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.call.cliconfig.profile;

import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import org.apache.ignite.internal.cli.call.cliconfig.profile.CliConfigProfileCreateCallInput;
import org.apache.ignite.internal.cli.config.ConfigManager;
import org.apache.ignite.internal.cli.config.ConfigManagerProvider;
import org.apache.ignite.internal.cli.config.Profile;
import org.apache.ignite.internal.cli.core.call.Call;
import org.apache.ignite.internal.cli.core.call.CallOutput;
import org.apache.ignite.internal.cli.core.call.DefaultCallOutput;

@Singleton
public class CliConfigProfileCreateCall
implements Call<CliConfigProfileCreateCallInput, String> {
    @Inject
    private ConfigManagerProvider configManagerProvider;

    @Override
    public CallOutput<String> execute(CliConfigProfileCreateCallInput input) {
        ConfigManager configManager = this.configManagerProvider.get();
        Profile copyFrom = null;
        if (input.getCopyFrom() != null) {
            copyFrom = configManager.getProfile(input.getCopyFrom());
        }
        String profileName = input.getName();
        Profile newProfile = configManager.createProfile(profileName);
        if (copyFrom != null) {
            newProfile.setProperties(copyFrom.getAll());
        }
        if (input.isActivate()) {
            configManager.setCurrentProfile(profileName);
        }
        return DefaultCallOutput.success("Profile " + profileName + " was created successfully.");
    }
}

