/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.configuration.hocon;

import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigValue;
import com.typesafe.config.ConfigValueType;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.apache.ignite.configuration.KeyIgnorer;
import org.apache.ignite.internal.configuration.TypeUtils;
import org.apache.ignite.internal.configuration.hocon.HoconObjectConfigurationSource;
import org.apache.ignite.internal.configuration.hocon.HoconPrimitiveConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConfigurationSource;
import org.apache.ignite.internal.configuration.tree.ConstructableTreeNode;
import org.apache.ignite.internal.configuration.tree.NamedListNode;
import org.apache.ignite.internal.configuration.util.ConfigurationUtil;

class HoconListConfigurationSource
implements ConfigurationSource {
    private final List<String> path;
    private final KeyIgnorer keyIgnorer;
    private final ConfigList hoconCfgList;

    HoconListConfigurationSource(KeyIgnorer keyIgnorer, List<String> path, ConfigList hoconCfgList) {
        this.keyIgnorer = keyIgnorer;
        this.path = path;
        this.hoconCfgList = hoconCfgList;
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (!clazz.isArray()) {
            throw HoconPrimitiveConfigurationSource.wrongTypeException(clazz, this.path, -1);
        }
        int size = this.hoconCfgList.size();
        Class<?> componentType = clazz.getComponentType();
        Class<?> boxedComponentType = HoconListConfigurationSource.box(componentType);
        Object resArray = Array.newInstance(componentType, size);
        int idx = 0;
        for (ConfigValue hoconCfgListElement : this.hoconCfgList) {
            switch (hoconCfgListElement.valueType()) {
                case OBJECT: 
                case LIST: {
                    throw HoconPrimitiveConfigurationSource.wrongTypeException(boxedComponentType, this.path, idx);
                }
            }
            Array.set(resArray, idx, HoconPrimitiveConfigurationSource.unwrapPrimitive(hoconCfgListElement, boxedComponentType, this.path, idx));
            ++idx;
        }
        return (T)resArray;
    }

    @Override
    public void descend(ConstructableTreeNode node) {
        if (!(node instanceof NamedListNode)) {
            throw new IllegalArgumentException(String.format("'%s' configuration is expected to be a composite configuration node, not a list", ConfigurationUtil.join(this.path)));
        }
        String syntheticKeyName = ((NamedListNode)node).syntheticKeyName();
        if (this.keyIgnorer.shouldIgnore(ConfigurationUtil.join(ConfigurationUtil.appendKey(this.path, syntheticKeyName)))) {
            return;
        }
        for (int idx = 0; idx < this.hoconCfgList.size(); ++idx) {
            List<String> path;
            String key;
            ConfigValue next = (ConfigValue)this.hoconCfgList.get(idx);
            if (next.valueType() != ConfigValueType.OBJECT) {
                throw new IllegalArgumentException(String.format("'%s' is expected to be a composite configuration node, not a single value", HoconPrimitiveConfigurationSource.formatArrayPath(this.path, idx)));
            }
            ConfigObject hoconCfg = (ConfigObject)next;
            ConfigValue keyValue = hoconCfg.get((Object)syntheticKeyName);
            if (keyValue != null && keyValue.valueType() == ConfigValueType.STRING) {
                key = (String)keyValue.unwrapped();
                path = ConfigurationUtil.appendKey(this.path, key);
            } else if (keyValue == null && hoconCfg.size() == 1) {
                key = (String)((Map.Entry)hoconCfg.entrySet().iterator().next()).getKey();
                path = this.path;
            } else {
                throw new IllegalArgumentException(String.format("'%s' configuration value is mandatory and must be a String", HoconPrimitiveConfigurationSource.formatArrayPath(this.path, idx) + "." + syntheticKeyName));
            }
            node.construct(key, new HoconObjectConfigurationSource(syntheticKeyName, this.keyIgnorer, path, hoconCfg), false);
        }
    }

    public static Class<?> box(Class<?> clazz) {
        Class<?> boxed = TypeUtils.boxed(clazz);
        return boxed == null ? clazz : boxed;
    }
}

