/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.externalize;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.util.Pair;
import org.apache.ignite3.internal.lang.IgniteInternalException;
import org.apache.ignite3.internal.sql.engine.externalize.RelJson;
import org.apache.ignite3.lang.ErrorGroups;

public class RelJsonWriter
implements RelWriter {
    private static final boolean PRETTY_PRINT = false;
    private final RelJson relJson;
    private final List<Object> relList = new ArrayList<Object>();
    private final Map<RelNode, String> relIdMap = new IdentityHashMap<RelNode, String>();
    private final boolean pretty;
    private String previousId;
    private List<Pair<String, Object>> items = new ArrayList<Pair<String, Object>>();

    public static String toJson(RelNode rel) {
        RelJsonWriter writer = new RelJsonWriter(false);
        rel.explain((RelWriter)writer);
        return writer.asString();
    }

    public static String toExprJson(RexNode node) {
        ObjectMapper mapper = new ObjectMapper();
        try {
            RelJson relJson = new RelJson();
            Object map = relJson.toJson((Object)node);
            return mapper.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "RelJson expression serialization error", (Throwable)e);
        }
    }

    public RelJsonWriter(boolean pretty) {
        this.pretty = pretty;
        this.relJson = new RelJson();
    }

    public final void explain(RelNode rel, List<Pair<String, Object>> valueList) {
        this.explain_(rel, valueList);
    }

    public SqlExplainLevel getDetailLevel() {
        return SqlExplainLevel.ALL_ATTRIBUTES;
    }

    public RelWriter item(String term, Object value) {
        this.items.add((Pair<String, Object>)Pair.of((Object)term, (Object)value));
        return this;
    }

    public RelWriter done(RelNode node) {
        List<Pair<String, Object>> current0 = this.items;
        this.items = new ArrayList<Pair<String, Object>>();
        this.explain_(node, current0);
        return this;
    }

    public boolean nest() {
        return true;
    }

    public String asString() {
        try {
            StringWriter writer = new StringWriter();
            ObjectMapper mapper = new ObjectMapper();
            ObjectWriter writer0 = this.pretty ? mapper.writer((PrettyPrinter)new DefaultPrettyPrinter()) : mapper.writer();
            writer0.withRootName("rels").writeValue((Writer)writer, this.relList);
            return writer.toString();
        }
        catch (IOException e) {
            throw new IgniteInternalException(ErrorGroups.Common.INTERNAL_ERR, "RelJson serialization error", (Throwable)e);
        }
    }

    private void explain_(RelNode rel, List<Pair<String, Object>> values) {
        Map map = this.relJson.map();
        map.put("id", null);
        map.put("relOp", this.relJson.classToTypeName(rel.getClass()));
        for (Pair<String, Object> value : values) {
            if (value.right instanceof RelNode) continue;
            map.put((String)value.left, this.relJson.toJson(value.right));
        }
        List<Object> list = this.explainInputs(rel.getInputs());
        if (list.size() != 1 || !list.get(0).equals(this.previousId)) {
            map.put("inputs", list);
        }
        String id = Integer.toString(this.relIdMap.size());
        this.relIdMap.put(rel, id);
        map.put("id", id);
        this.relList.add(map);
        this.previousId = id;
    }

    private List<Object> explainInputs(List<RelNode> inputs) {
        List<Object> list = this.relJson.list();
        for (RelNode input : inputs) {
            String id = this.relIdMap.get(input);
            if (id == null) {
                input.explain((RelWriter)this);
                id = this.previousId;
            }
            list.add(id);
        }
        return list;
    }
}

