/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cache.query.index.sorted;

import org.apache.ignite.internal.cache.query.index.sorted.IndexRow;
import org.apache.ignite.internal.cache.query.index.sorted.InlineIndexRowHandler;
import org.apache.ignite.internal.cache.query.index.sorted.keys.IndexKey;
import org.apache.ignite.internal.processors.cache.CacheObject;
import org.apache.ignite.internal.processors.cache.persistence.CacheDataRow;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.util.typedef.internal.SB;

public class IndexRowImpl
implements IndexRow {
    private final CacheDataRow cacheRow;
    private IndexKey[] keyCache;
    private final InlineIndexRowHandler rowHnd;

    public IndexRowImpl(InlineIndexRowHandler rowHnd, CacheDataRow row) {
        this(rowHnd, row, null);
    }

    public IndexRowImpl(InlineIndexRowHandler rowHnd, CacheDataRow row, IndexKey[] keys) {
        this.rowHnd = rowHnd;
        this.cacheRow = row;
        this.keyCache = keys;
    }

    public CacheObject value() {
        return this.cacheRow.value();
    }

    @Override
    public IndexKey key(int idx) {
        if (this.keyCache != null && this.keyCache[idx] != null) {
            return this.keyCache[idx];
        }
        IndexKey key = this.rowHnd.indexKey(idx, this.cacheRow);
        if (this.keyCache != null) {
            this.keyCache[idx] = key;
        }
        return key;
    }

    @Override
    public int keysCount() {
        return this.rowHnd.indexKeyDefinitions().size();
    }

    @Override
    public long link() {
        return this.cacheRow.link();
    }

    @Override
    public InlineIndexRowHandler rowHandler() {
        return this.rowHnd;
    }

    @Override
    public CacheDataRow cacheDataRow() {
        return this.cacheRow;
    }

    public int cacheId() {
        return this.cacheDataRow().cacheId();
    }

    public void prepareCache() {
        this.keyCache = new IndexKey[this.rowHnd.indexKeyDefinitions().size()];
    }

    public String toString() {
        SB sb = new SB("Row@");
        sb.a(Integer.toHexString(System.identityHashCode(this)));
        Object v = this.rowHnd.cacheKey(this.cacheRow);
        sb.a("[ key: ").a(v == null ? "nil" : v.toString());
        v = this.rowHnd.cacheValue(this.cacheRow);
        sb.a(", val: ").a(v == null ? "nil" : (S.includeSensitive() ? v.toString() : "Data hidden due to IGNITE_TO_STRING_INCLUDE_SENSITIVE flag."));
        sb.a(" ][ ");
        if (v != null) {
            int cnt = this.rowHnd.indexKeyDefinitions().size();
            for (int i = 0; i < cnt; ++i) {
                if (i != 0) {
                    sb.a(", ");
                }
                try {
                    v = this.key(i);
                    sb.a(v == null ? "nil" : (S.includeSensitive() ? v.toString() : "data hidden"));
                    continue;
                }
                catch (Exception e) {
                    sb.a("<value skipped on error: " + e.getMessage() + ">");
                }
            }
        }
        sb.a(" ]");
        return sb.toString();
    }

    @Override
    public boolean indexPlainRow() {
        return false;
    }
}

