/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.cache;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.UUID;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.api.Argument;
import org.apache.ignite.internal.management.api.ArgumentGroup;
import org.apache.ignite.internal.management.api.ArgumentGroupsHolder;
import org.apache.ignite.internal.util.typedef.internal.U;

@ArgumentGroupsHolder(value={@ArgumentGroup(value={"nodeIds", "allNodes", "nodeId"}, onlyOneOf=true, optional=false), @ArgumentGroup(value={"cacheNames", "groupNames"}, onlyOneOf=true, optional=false)})
public class CacheIndexesForceRebuildCommandArg
extends IgniteDataTransferObject {
    private static final long serialVersionUID = 0L;
    @Argument(description="Specify node for indexes rebuild (deprecated. Use --node-ids or --all-nodes instead)", example="nodeId")
    private UUID nodeId;
    @Argument(description="Comma-separated list of nodes ids to run index rebuild on", example="nodeId1,...nodeIdN")
    private UUID[] nodeIds;
    @Argument(description="Rebuild index on all nodes")
    private boolean allNodes;
    @Argument(description="Comma-separated list of cache names for which indexes should be rebuilt", example="cacheName1,...cacheNameN")
    private String[] cacheNames;
    @Argument(description="Comma-separated list of cache group names for which indexes should be rebuilt", example="groupName1,...groupNameN")
    private String[] groupNames;

    @Override
    protected void writeExternalData(ObjectOutput out) throws IOException {
        U.writeUuid(out, this.nodeId);
        U.writeArray(out, this.cacheNames);
        U.writeArray(out, this.groupNames);
        U.writeArray(out, this.nodeIds);
        out.writeBoolean(this.allNodes);
    }

    @Override
    protected void readExternalData(byte protoVer, ObjectInput in) throws IOException, ClassNotFoundException {
        this.nodeId = U.readUuid(in);
        this.cacheNames = U.readArray(in, String.class);
        this.groupNames = U.readArray(in, String.class);
        this.nodeIds = U.readArray(in, UUID.class);
        this.allNodes = in.readBoolean();
    }

    public UUID nodeId() {
        return this.nodeId;
    }

    public void nodeId(UUID nodeId) {
        this.nodeId = nodeId;
    }

    public UUID[] nodeIds() {
        return this.nodeIds;
    }

    public void allNodes(boolean allNodes) {
        this.allNodes = allNodes;
    }

    public boolean allNodes() {
        return this.allNodes;
    }

    public void nodeIds(UUID[] nodeIds) {
        this.nodeIds = nodeIds;
    }

    public String[] cacheNames() {
        return this.cacheNames;
    }

    public void cacheNames(String[] cacheNames) {
        this.cacheNames = cacheNames;
    }

    public String[] groupNames() {
        return this.groupNames;
    }

    public void groupNames(String[] groupNames) {
        this.groupNames = groupNames;
    }
}

