/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.jdbc2;

import java.math.BigDecimal;
import java.net.URL;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcColumnMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcIndexMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcPrimaryKeyMeta;
import org.apache.ignite.internal.processors.odbc.jdbc.JdbcTableMeta;
import org.apache.ignite.internal.processors.query.IgniteSQLException;
import org.apache.ignite.internal.processors.query.QueryUtils;
import org.apache.ignite.internal.util.typedef.F;

public class JdbcUtils {
    public static final String CATALOG_NAME = "IGNITE";
    public static final String TYPE_TABLE = "TABLE";
    public static final String TYPE_VIEW = "VIEW";

    public static int type(String cls) {
        if (Boolean.class.getName().equals(cls) || Boolean.TYPE.getName().equals(cls)) {
            return 16;
        }
        if (Byte.class.getName().equals(cls) || Byte.TYPE.getName().equals(cls)) {
            return -6;
        }
        if (Short.class.getName().equals(cls) || Short.TYPE.getName().equals(cls)) {
            return 5;
        }
        if (Integer.class.getName().equals(cls) || Integer.TYPE.getName().equals(cls)) {
            return 4;
        }
        if (Long.class.getName().equals(cls) || Long.TYPE.getName().equals(cls)) {
            return -5;
        }
        if (Float.class.getName().equals(cls) || Float.TYPE.getName().equals(cls)) {
            return 6;
        }
        if (Double.class.getName().equals(cls) || Double.TYPE.getName().equals(cls)) {
            return 8;
        }
        if (String.class.getName().equals(cls)) {
            return 12;
        }
        if (byte[].class.getName().equals(cls)) {
            return -2;
        }
        if (Time.class.getName().equals(cls)) {
            return 92;
        }
        if (Timestamp.class.getName().equals(cls)) {
            return 93;
        }
        if (java.util.Date.class.getName().equals(cls) || Date.class.getName().equals(cls)) {
            return 91;
        }
        if (BigDecimal.class.getName().equals(cls)) {
            return 3;
        }
        return 1111;
    }

    public static String typeName(String cls) {
        if (Boolean.class.getName().equals(cls) || Boolean.TYPE.getName().equals(cls)) {
            return "BOOLEAN";
        }
        if (Byte.class.getName().equals(cls) || Byte.TYPE.getName().equals(cls)) {
            return "TINYINT";
        }
        if (Short.class.getName().equals(cls) || Short.TYPE.getName().equals(cls)) {
            return "SMALLINT";
        }
        if (Integer.class.getName().equals(cls) || Integer.TYPE.getName().equals(cls)) {
            return "INTEGER";
        }
        if (Long.class.getName().equals(cls) || Long.TYPE.getName().equals(cls)) {
            return "BIGINT";
        }
        if (Float.class.getName().equals(cls) || Float.TYPE.getName().equals(cls)) {
            return "FLOAT";
        }
        if (Double.class.getName().equals(cls) || Double.TYPE.getName().equals(cls)) {
            return "DOUBLE";
        }
        if (String.class.getName().equals(cls)) {
            return "VARCHAR";
        }
        if (byte[].class.getName().equals(cls)) {
            return "BINARY";
        }
        if (Time.class.getName().equals(cls)) {
            return "TIME";
        }
        if (Timestamp.class.getName().equals(cls)) {
            return "TIMESTAMP";
        }
        if (java.util.Date.class.getName().equals(cls) || Date.class.getName().equals(cls)) {
            return "DATE";
        }
        if (BigDecimal.class.getName().equals(cls)) {
            return "DECIMAL";
        }
        return "OTHER";
    }

    public static boolean nullable(String name, String cls) {
        return !"_KEY".equalsIgnoreCase(name) && !"_VAL".equalsIgnoreCase(name) && !Boolean.TYPE.getName().equals(cls) && !Byte.TYPE.getName().equals(cls) && !Short.TYPE.getName().equals(cls) && !Integer.TYPE.getName().equals(cls) && !Long.TYPE.getName().equals(cls) && !Float.TYPE.getName().equals(cls) && !Double.TYPE.getName().equals(cls);
    }

    static boolean isSqlType(Class<?> cls) {
        return QueryUtils.isSqlType(cls) || cls == URL.class;
    }

    public static SQLException convertToSqlException(Exception e, String msgForUnknown) {
        return JdbcUtils.convertToSqlException(e, msgForUnknown, null);
    }

    public static SQLException convertToSqlException(Exception e, String msgForUnknown, String sqlStateForUnknown) {
        Object sqlEx = null;
        for (Throwable t = e; sqlEx == null && t != null; t = t.getCause()) {
            if (t instanceof SQLException) {
                return (SQLException)t;
            }
            if (!(t instanceof IgniteSQLException)) continue;
            return ((IgniteSQLException)t).toJdbcException();
        }
        return new SQLException(msgForUnknown, sqlStateForUnknown, e);
    }

    public static List<Object> columnRow(JdbcColumnMeta colMeta, int pos) {
        ArrayList<Object> row = new ArrayList<Object>(24);
        row.add(CATALOG_NAME);
        row.add(colMeta.schemaName());
        row.add(colMeta.tableName());
        row.add(colMeta.columnName());
        row.add(colMeta.dataType());
        row.add(colMeta.dataTypeName());
        row.add(colMeta.precision() == -1 ? null : Integer.valueOf(colMeta.precision()));
        row.add(null);
        row.add(colMeta.scale() == -1 ? null : Integer.valueOf(colMeta.scale()));
        row.add(10);
        row.add(colMeta.isNullable() ? 1 : 0);
        row.add(null);
        row.add(colMeta.defaultValue());
        row.add(colMeta.dataType());
        row.add(null);
        row.add(Integer.MAX_VALUE);
        row.add(pos);
        row.add(colMeta.isNullable() ? "YES" : "NO");
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add("NO");
        row.add("NO");
        return row;
    }

    public static List<List<Object>> indexRows(JdbcIndexMeta idxMeta) {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(idxMeta.fields().size());
        for (int i = 0; i < idxMeta.fields().size(); ++i) {
            ArrayList<Object> row = new ArrayList<Object>(13);
            row.add(CATALOG_NAME);
            row.add(idxMeta.schemaName());
            row.add(idxMeta.tableName());
            row.add(true);
            row.add(null);
            row.add(idxMeta.indexName());
            row.add((short)3);
            row.add(i + 1);
            row.add(idxMeta.fields().get(i));
            row.add(idxMeta.fieldsAsc().get(i) != false ? "A" : "D");
            row.add(0);
            row.add(0);
            row.add(null);
            rows.add(row);
        }
        return rows;
    }

    public static List<List<Object>> primaryKeyRows(JdbcPrimaryKeyMeta pkMeta) {
        ArrayList<List<Object>> rows = new ArrayList<List<Object>>(pkMeta.fields().size());
        for (int i = 0; i < pkMeta.fields().size(); ++i) {
            ArrayList<Object> row = new ArrayList<Object>(6);
            row.add(CATALOG_NAME);
            row.add(pkMeta.schemaName());
            row.add(pkMeta.tableName());
            row.add(pkMeta.fields().get(i));
            row.add(i + 1);
            row.add(pkMeta.name());
            rows.add(row);
        }
        return rows;
    }

    public static List<Object> tableRow(JdbcTableMeta tblMeta) {
        ArrayList<Object> row = new ArrayList<Object>(10);
        row.add(CATALOG_NAME);
        row.add(tblMeta.schemaName());
        row.add(tblMeta.tableName());
        row.add(tblMeta.tableType());
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        row.add(null);
        return row;
    }

    public static String normalizeSchema(String schemaName) {
        if (F.isEmpty(schemaName)) {
            return "PUBLIC";
        }
        String res = schemaName.startsWith("\"") && schemaName.endsWith("\"") ? schemaName.substring(1, schemaName.length() - 1) : schemaName.toUpperCase();
        return res;
    }
}

